/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePane;
import net.sf.jabref.SidePaneComponent;

public class SidePaneManager {
    JabRefFrame frame;
    BasePanel panel;
    SidePane sidep;
    Map<String, SidePaneComponent> components = new LinkedHashMap<String, SidePaneComponent>();
    List<SidePaneComponent> visible = new LinkedList<SidePaneComponent>();

    public SidePaneManager(JabRefFrame frame) {
        this.frame = frame;
        frame.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SidePaneManager.this.setActiveBasePanel((BasePanel)SidePaneManager.this.frame.tabbedPane.getSelectedComponent());
                    }
                });
            }
        });
        this.sidep = new SidePane();
        this.sidep.setVisible(false);
    }

    public SidePane getPanel() {
        return this.sidep;
    }

    public synchronized boolean hasComponent(String name) {
        return this.components.get(name) != null;
    }

    public boolean isComponentVisible(String name) {
        SidePaneComponent o = this.components.get(name);
        if (o != null) {
            return this.visible.contains(o);
        }
        return false;
    }

    public synchronized void toggle(String name) {
        if (this.isComponentVisible(name)) {
            this.hide(name);
        } else {
            this.show(name);
        }
    }

    public void show(String name) {
        SidePaneComponent o = this.components.get(name);
        if (o != null) {
            this.show(o);
        } else {
            System.err.println("Side pane component '" + name + "' unknown.");
        }
    }

    public void hide(String name) {
        SidePaneComponent o = this.components.get(name);
        if (o != null) {
            this.hideComponent(o);
        } else {
            System.err.println("Side pane component '" + name + "' unknown.");
        }
    }

    public synchronized void register(String name, SidePaneComponent comp) {
        this.components.put(name, comp);
    }

    public synchronized void registerAndShow(String name, SidePaneComponent comp) {
        this.register(name, comp);
        this.show(name);
    }

    private synchronized void show(SidePaneComponent component) {
        if (!this.visible.contains(component)) {
            this.visible.add(0, component);
            this.updateView();
            component.componentOpening();
        }
    }

    public SidePaneComponent getComponent(String name) {
        return this.components.get(name);
    }

    public synchronized void hideComponent(SidePaneComponent comp) {
        if (this.visible.contains(comp)) {
            comp.componentClosing();
            this.visible.remove(comp);
            this.updateView();
        }
    }

    public synchronized void hideComponent(String name) {
        SidePaneComponent comp = this.components.get(name);
        if (comp == null) {
            return;
        }
        if (this.visible.contains(comp)) {
            comp.componentClosing();
            this.visible.remove(comp);
            this.updateView();
        }
    }

    public synchronized void unregisterComponent(String name) {
        this.components.remove(name);
    }

    public void setActiveBasePanel(BasePanel panel) {
        for (String key : this.components.keySet()) {
            this.components.get(key).setActiveBasePanel(panel);
        }
    }

    public void updateView() {
        this.sidep.setComponents(this.visible);
        if (this.visible.size() > 0) {
            boolean wasVisible = this.sidep.isVisible();
            this.sidep.setVisible(true);
            if (!wasVisible) {
                int width = Globals.prefs.getInt("sidePaneWidth");
                if (width > 0) {
                    this.frame.contentPane.setDividerLocation(width);
                } else {
                    this.frame.contentPane.setDividerLocation(this.getPanel().getPreferredSize().width);
                }
            }
        } else {
            if (this.sidep.isVisible()) {
                Globals.prefs.putInt("sidePaneWidth", this.frame.contentPane.getDividerLocation());
            }
            this.sidep.setVisible(false);
        }
    }

    public void revalidate() {
        this.sidep.revalidate();
        this.sidep.repaint();
    }
}

