/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.FontSelectorDialog;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.gui.ColorSetupPanel;

class AppearancePrefsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private JCheckBox colorCodes;
    private JCheckBox overrideFonts;
    private GridBagLayout gbl = new GridBagLayout();
    private JButton fontButton = new JButton(Globals.lang("Set table font"));
    private ColorSetupPanel colorPanel = new ColorSetupPanel();
    private Font font = GUIGlobals.CURRENTFONT;
    private int oldMenuFontSize;
    private boolean oldOverrideFontSize;
    private JTextField fontSize;

    public AppearancePrefsTab(JabRefPreferences prefs) {
        this._prefs = prefs;
        this.setLayout(new BorderLayout());
        this.fontSize = new JTextField(5);
        this.colorCodes = new JCheckBox(Globals.lang("Color codes for required and optional fields"));
        this.overrideFonts = new JCheckBox(Globals.lang("Override default font settings"));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setLeadingColumnOffset(2);
        builder.appendSeparator(Globals.lang("General"));
        JPanel p1 = new JPanel();
        JLabel lab = new JLabel(Globals.lang("Menu and label font size") + ":");
        p1.add(lab);
        p1.add(this.fontSize);
        builder.append(p1);
        builder.nextLine();
        builder.append(this.overrideFonts);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Table appearance"));
        builder.append(this.colorCodes);
        builder.nextLine();
        builder.append(this.fontButton);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Table and entry editor colors"));
        builder.append(this.colorPanel);
        JPanel upper = new JPanel();
        JPanel sort = new JPanel();
        JPanel namesp = new JPanel();
        JPanel iconCol = new JPanel();
        upper.setLayout(this.gbl);
        sort.setLayout(this.gbl);
        namesp.setLayout(this.gbl);
        iconCol.setLayout(this.gbl);
        this.overrideFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppearancePrefsTab.this.fontSize.setEnabled(AppearancePrefsTab.this.overrideFonts.isSelected());
            }
        });
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font f = new FontSelectorDialog(null, GUIGlobals.CURRENTFONT).getSelectedFont();
                if (f == null) {
                    return;
                }
                AppearancePrefsTab.this.font = f;
            }
        });
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.colorCodes.setSelected(this._prefs.getBoolean("tableColorCodesOn"));
        this.fontSize.setText("" + this._prefs.getInt("menuFontSize"));
        this.oldMenuFontSize = this._prefs.getInt("menuFontSize");
        this.overrideFonts.setSelected(this._prefs.getBoolean("overrideDefaultFonts"));
        this.oldOverrideFontSize = this.overrideFonts.isSelected();
        this.fontSize.setEnabled(this.overrideFonts.isSelected());
        this.colorPanel.setValues();
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("tableColorCodesOn", this.colorCodes.isSelected());
        this._prefs.put("fontFamily", this.font.getFamily());
        this._prefs.putInt("fontStyle", this.font.getStyle());
        this._prefs.putInt("fontSize", this.font.getSize());
        this._prefs.putBoolean("overrideDefaultFonts", this.overrideFonts.isSelected());
        GUIGlobals.CURRENTFONT = this.font;
        this.colorPanel.storeSettings();
        try {
            int size = Integer.parseInt(this.fontSize.getText());
            if (this.overrideFonts.isSelected() != this.oldOverrideFontSize || size != this.oldMenuFontSize) {
                this._prefs.putInt("menuFontSize", size);
                JOptionPane.showMessageDialog(null, Globals.lang("You have changed the menu and label font size.").concat(" ").concat(Globals.lang("You must restart JabRef for this to come into effect.")), Globals.lang("Changed font settings"), 2);
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean readyToClose() {
        try {
            Integer.parseInt(this.fontSize.getText());
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, Globals.lang("You must enter an integer value in the text field for") + " '" + Globals.lang("Menu and label font size") + "'", Globals.lang("Changed font settings"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Appearance");
    }
}

