/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.painter;

import com.explodingpixels.painter.Painter;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Graphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusStatePainter
implements Painter<Component> {
    private Painter<Component> fComponentFocusedPainter;
    private Painter<Component> fWindowFocusedPainter;
    private Painter<Component> fWindowUnfocusedPainter;

    public FocusStatePainter(Painter<Component> componentFocusedPainter, Painter<Component> windowUnfocusedPainter) {
        this(componentFocusedPainter, windowUnfocusedPainter, windowUnfocusedPainter);
    }

    public FocusStatePainter(Painter<Component> componentFocusedPainter, Painter<Component> windowFocusedPainter, Painter<Component> windowUnfocusedPainter) {
        if (componentFocusedPainter == null) {
            throw new IllegalArgumentException("Component focused Painter cannot be null.");
        }
        if (windowFocusedPainter == null) {
            throw new IllegalArgumentException("Window focused Painter cannot be null.");
        }
        if (windowUnfocusedPainter == null) {
            throw new IllegalArgumentException("Window unfocused Painter cannot be null.");
        }
        this.fComponentFocusedPainter = componentFocusedPainter;
        this.fWindowFocusedPainter = windowFocusedPainter;
        this.fWindowUnfocusedPainter = windowUnfocusedPainter;
    }

    @Override
    public void paint(Graphics2D g, Component component, int width, int height) {
        Painter<Component> painterToUse = component.hasFocus() ? this.fComponentFocusedPainter : (WindowUtils.isParentWindowFocused(component) ? this.fWindowFocusedPainter : this.fWindowUnfocusedPainter);
        painterToUse.paint(g, component, width, height);
    }
}

