/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacButtonFactory;
import com.explodingpixels.macwidgets.MacIcons;
import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.SourceList;
import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListControlBar;
import com.explodingpixels.macwidgets.SourceListItem;
import com.explodingpixels.macwidgets.SourceListModel;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import com.explodingpixels.widgets.PopupMenuCustomizerUsingStrings;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DEverything {
    private UnifiedToolBar fUnifiedToolBar = this.createUnifiedToolBar();
    private SourceList fSourceList;

    public DEverything(JFrame frame) {
        this.fUnifiedToolBar.installWindowDraggerOnWindow(frame);
        JSplitPane splitPane = this.createSourceListAndMainArea();
        frame.add((Component)this.fUnifiedToolBar.getComponent(), "North");
        frame.add((Component)splitPane, "Center");
    }

    private UnifiedToolBar createUnifiedToolBar() {
        ImageIcon blueGlobeIcon = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/DotMac.png"));
        ImageIcon greyGlobeIcon = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/Network.png"));
        ImageIcon preferences = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/PreferencesGeneral.png"));
        ImageIcon gear = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/Advanced.png"));
        AbstractButton greyGlobeButton = MacButtonFactory.makeUnifiedToolBarButton(new JButton("Network", greyGlobeIcon));
        greyGlobeButton.setEnabled(false);
        JButton blueButton = new JButton("MobileMe", blueGlobeIcon);
        blueButton.setEnabled(true);
        UnifiedToolBar toolBar = new UnifiedToolBar();
        toolBar.addComponentToLeft(MacButtonFactory.makeUnifiedToolBarButton(blueButton));
        toolBar.addComponentToLeft(greyGlobeButton);
        toolBar.addComponentToLeft(MacButtonFactory.makeUnifiedToolBarButton(new JButton("Preferences", preferences)));
        toolBar.addComponentToRight(MacButtonFactory.makeUnifiedToolBarButton(new JButton("Advanced", gear)));
        return toolBar;
    }

    private JSplitPane createSourceListAndMainArea() {
        Image blueGlobeImage = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/DotMac.png")).getImage().getScaledInstance(16, 16, 4);
        Image greyGlobeImage = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/Network.png")).getImage().getScaledInstance(16, 16, 4);
        ImageIcon blueGlobeIcon = new ImageIcon(blueGlobeImage);
        ImageIcon greyGlobeIcon = new ImageIcon(greyGlobeImage);
        SourceListCategory categoryOne = new SourceListCategory("Category 1");
        SourceListCategory categoryTwo = new SourceListCategory("Category 2");
        SourceListCategory categoryThree = new SourceListCategory("Category 3");
        SourceListItem itemA = new SourceListItem("SourceListItem A", blueGlobeIcon);
        SourceListItem itemB = new SourceListItem("SourceListItem B", greyGlobeIcon);
        SourceListItem itemC = new SourceListItem("SourceListItem D", greyGlobeIcon);
        SourceListItem itemD = new SourceListItem("SourceListItem E", greyGlobeIcon);
        SourceListItem itemE = new SourceListItem("Really really really really really long SourceListItem", greyGlobeIcon);
        final SourceListItem itemG = new SourceListItem("SourceListItem G", greyGlobeIcon);
        SourceListItem itemH = new SourceListItem("SourceListItem H", greyGlobeIcon);
        SourceListItem itemI = new SourceListItem("SourceListItem I", greyGlobeIcon);
        SourceListItem itemJ = new SourceListItem("SourceListItem J", greyGlobeIcon);
        SourceListItem itemK = new SourceListItem("SourceListItem K", greyGlobeIcon);
        SourceListItem itemL = new SourceListItem("SourceListItem L", greyGlobeIcon);
        itemA.setCounterValue(1);
        itemC.setCounterValue(385);
        itemE.setCounterValue(3);
        itemI.setCounterValue(17);
        final SourceListModel model = new SourceListModel();
        model.addCategory(categoryOne);
        model.addItemToCategory(itemA, categoryOne);
        model.addItemToCategory(itemB, categoryOne);
        model.addCategory(categoryTwo);
        model.addItemToCategory(itemC, categoryTwo);
        model.addItemToCategory(itemD, categoryTwo);
        model.addItemToCategory(itemE, categoryTwo);
        model.addCategory(categoryThree);
        model.addItemToCategory(itemG, categoryThree);
        model.addItemToCategory(itemH, categoryThree);
        model.addItemToCategory(itemI, categoryThree);
        model.addItemToCategory(itemJ, categoryThree);
        model.addItemToCategory(itemK, categoryThree);
        model.addItemToCategory(itemL, categoryThree);
        this.fSourceList = new SourceList(model);
        SourceListControlBar controlBar = new SourceListControlBar();
        controlBar.createAndAddButton(MacIcons.PLUS, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                model.addItemToItem(new SourceListItem("Hello"), itemG);
            }
        });
        controlBar.createAndAddButton(MacIcons.MINUS, null);
        controlBar.createAndAddPopdownButton(MacIcons.GEAR, new PopupMenuCustomizerUsingStrings(null, "Item One", "Item Two", "Item Three"));
        this.fSourceList.installSourceListControlBar(controlBar);
        JTextArea textArea = new JTextArea();
        JSplitPane splitPane = MacWidgetFactory.createSplitPaneForSourceList(this.fSourceList, textArea);
        splitPane.setDividerLocation(200);
        controlBar.installDraggableWidgetOnSplitPane(splitPane);
        return splitPane;
    }

    public UnifiedToolBar getUnifiedToolBar() {
        return this.fUnifiedToolBar;
    }

    public SourceList getSourceList() {
        return this.fSourceList;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame();
                MacUtils.makeWindowLeopardStyle(frame.getRootPane());
                WindowUtils.createAndInstallRepaintWindowFocusListener(frame);
                DEverything everything = new DEverything(frame);
                frame.setSize(650, 450);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }
}

