/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.LinkTransformer;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayPropertyPage
implements IEntityPropertyPage {
    private List<IEntity> fEntities;
    private Combo fFilterCombo;
    private Combo fGroupCombo;
    private Combo fLayoutCombo;
    private Combo fPageSizeCombo;
    private Button fLoadImagesForNewsCheck;
    private Button fLoadMediaForNewsCheck;
    private Button fDisplayContentsOfNewsRadio;
    private Button fOpenLinkOfNewsRadio;
    private Button fOpenSiteForEmptyNewsCheck;
    private Button fUseTransformerCheck;
    private ComboViewer fLinkTransformerViewer;
    private List<IPreferenceScope> fEntityPreferences;
    private int fPrefSelectedFilter;
    private int fPrefSelectedGroup;
    private int fPrefSelectedLayout;
    private int fPrefSelectedPageSize;
    private boolean fPrefOpenSiteForNews;
    private boolean fPrefOpenSiteForEmptyNews;
    private boolean fPrefUseLinkTransformer;
    private String fPrefLinkTransformerId;
    private boolean fPrefLoadImagesForNews;
    private boolean fPrefLoadMediaForNews;
    private boolean fSettingsChanged;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        Assert.isTrue((!entities.isEmpty() ? 1 : 0) != 0);
        this.fEntities = entities;
        this.fEntityPreferences = new ArrayList<IPreferenceScope>(this.fEntities.size());
        for (IEntity entity : entities) {
            this.fEntityPreferences.add(Owl.getPreferenceService().getEntityScope(entity));
        }
        this.loadInitialSettings();
    }

    private void loadInitialSettings() {
        IPreferenceScope globalScope = Owl.getPreferenceService().getGlobalScope();
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        IPreferenceScope firstScope = this.fEntityPreferences.get(0);
        this.fPrefSelectedFilter = ModelUtils.loadIntegerValueWithFallback(firstScope, DefaultPreferences.BM_NEWS_FILTERING, globalScope, DefaultPreferences.FV_FILTER_TYPE);
        this.fPrefSelectedGroup = ModelUtils.loadIntegerValueWithFallback(firstScope, DefaultPreferences.BM_NEWS_GROUPING, globalScope, DefaultPreferences.FV_GROUP_TYPE);
        this.fPrefOpenSiteForNews = firstScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS);
        this.fPrefOpenSiteForEmptyNews = firstScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS);
        this.fPrefUseLinkTransformer = firstScope.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER);
        this.fPrefLinkTransformerId = firstScope.getString(DefaultPreferences.BM_TRANSFORMER_ID);
        this.fPrefLoadImagesForNews = firstScope.getBoolean(DefaultPreferences.ENABLE_IMAGES);
        this.fPrefLoadMediaForNews = firstScope.getBoolean(DefaultPreferences.ENABLE_MEDIA);
        this.fPrefSelectedLayout = firstScope.getInteger(DefaultPreferences.FV_LAYOUT);
        this.fPrefSelectedPageSize = firstScope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE);
        int i = 1;
        while (i < this.fEntityPreferences.size()) {
            IPreferenceScope otherScope = this.fEntityPreferences.get(i);
            if (ModelUtils.loadIntegerValueWithFallback(otherScope, DefaultPreferences.BM_NEWS_FILTERING, globalScope, DefaultPreferences.FV_FILTER_TYPE) != this.fPrefSelectedFilter) {
                this.fPrefSelectedFilter = ModelUtils.loadIntegerValueWithFallback(defaultScope, DefaultPreferences.BM_NEWS_FILTERING, defaultScope, DefaultPreferences.FV_FILTER_TYPE);
            }
            if (ModelUtils.loadIntegerValueWithFallback(otherScope, DefaultPreferences.BM_NEWS_GROUPING, globalScope, DefaultPreferences.FV_GROUP_TYPE) != this.fPrefSelectedGroup) {
                this.fPrefSelectedGroup = ModelUtils.loadIntegerValueWithFallback(defaultScope, DefaultPreferences.BM_NEWS_GROUPING, defaultScope, DefaultPreferences.FV_GROUP_TYPE);
            }
            if (otherScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS) != this.fPrefOpenSiteForNews) {
                this.fPrefOpenSiteForNews = defaultScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS);
            }
            if (otherScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS) != this.fPrefOpenSiteForEmptyNews) {
                this.fPrefOpenSiteForEmptyNews = defaultScope.getBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS);
            }
            if (otherScope.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER) != this.fPrefUseLinkTransformer) {
                this.fPrefUseLinkTransformer = defaultScope.getBoolean(DefaultPreferences.BM_USE_TRANSFORMER);
            }
            if (this.fPrefLinkTransformerId != null && !this.fPrefLinkTransformerId.equals(otherScope.getString(DefaultPreferences.BM_TRANSFORMER_ID))) {
                this.fPrefLinkTransformerId = defaultScope.getString(DefaultPreferences.BM_TRANSFORMER_ID);
            }
            if (otherScope.getBoolean(DefaultPreferences.ENABLE_IMAGES) != this.fPrefLoadImagesForNews) {
                this.fPrefLoadImagesForNews = defaultScope.getBoolean(DefaultPreferences.ENABLE_IMAGES);
            }
            if (otherScope.getBoolean(DefaultPreferences.ENABLE_MEDIA) != this.fPrefLoadMediaForNews) {
                this.fPrefLoadMediaForNews = defaultScope.getBoolean(DefaultPreferences.ENABLE_MEDIA);
            }
            if (otherScope.getInteger(DefaultPreferences.FV_LAYOUT) != this.fPrefSelectedLayout) {
                this.fPrefSelectedLayout = defaultScope.getInteger(DefaultPreferences.FV_LAYOUT);
            }
            if (otherScope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE) != this.fPrefSelectedPageSize) {
                this.fPrefSelectedPageSize = defaultScope.getInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE);
            }
            ++i;
        }
    }

    @Override
    public Control createContents(Composite parent) {
        NewsGrouping.Type[] groups;
        NewsFilter.Type[] filters;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        Composite topContainer = new Composite(container, 0);
        topContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 5, 15, false));
        topContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        Label layoutLabel = new Label(topContainer, 0);
        layoutLabel.setText(Messages.DisplayPropertyPage_LAYOUT);
        Composite layoutContainer = new Composite(topContainer, 0);
        layoutContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        layoutContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 5, false));
        this.fLayoutCombo = new Combo(layoutContainer, 2056);
        this.fLayoutCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        Enum[] enumArray = OwlUI.Layout.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OwlUI.Layout layout = enumArray[n2];
            this.fLayoutCombo.add(layout.getName());
            ++n2;
        }
        this.fLayoutCombo.select(this.fPrefSelectedLayout);
        this.fLayoutCombo.setVisibleItemCount(this.fLayoutCombo.getItemCount());
        this.fLayoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplayPropertyPage.this.updateDisplayButtons();
            }
        });
        this.fPageSizeCombo = new Combo(layoutContainer, 2056);
        this.fPageSizeCombo.setLayoutData((Object)new GridData(4, 1, false, false));
        enumArray = OwlUI.PageSize.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum pageSize = enumArray[n2];
            this.fPageSizeCombo.add(((OwlUI.PageSize)pageSize).getName());
            ++n2;
        }
        this.fPageSizeCombo.select(OwlUI.PageSize.from(this.fPrefSelectedPageSize).ordinal());
        this.fPageSizeCombo.setVisibleItemCount(this.fPageSizeCombo.getItemCount());
        Label filterLabel = new Label(topContainer, 0);
        filterLabel.setText(Messages.DisplayPropertyPage_FILTER);
        this.fFilterCombo = new Combo(topContainer, 2056);
        this.fFilterCombo.setLayoutData((Object)new GridData(4, 1, false, false));
        NewsFilter.Type[] typeArray = filters = NewsFilter.Type.values();
        int n3 = filters.length;
        int n4 = 0;
        while (n4 < n3) {
            NewsFilter.Type filter = typeArray[n4];
            this.fFilterCombo.add(filter.getName());
            ++n4;
        }
        this.fFilterCombo.select(this.fPrefSelectedFilter);
        this.fFilterCombo.setVisibleItemCount(this.fFilterCombo.getItemCount());
        Label groupLabel = new Label(topContainer, 0);
        groupLabel.setText(Messages.DisplayPropertyPage_GROUP);
        this.fGroupCombo = new Combo(topContainer, 2056);
        this.fGroupCombo.setLayoutData((Object)new GridData(4, 1, false, false));
        NewsGrouping.Type[] typeArray2 = groups = NewsGrouping.Type.values();
        int n5 = groups.length;
        int n6 = 0;
        while (n6 < n5) {
            NewsGrouping.Type group = typeArray2[n6];
            this.fGroupCombo.add(group.getName());
            ++n6;
        }
        this.fGroupCombo.select(this.fPrefSelectedGroup);
        this.fGroupCombo.setVisibleItemCount(this.fGroupCombo.getItemCount());
        Composite bottomContainer = new Composite(container, 0);
        bottomContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 10));
        bottomContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fDisplayContentsOfNewsRadio = new Button(bottomContainer, 16);
        this.fDisplayContentsOfNewsRadio.setText(Messages.DisplayPropertyPage_DISPLAY_NEWS_CONTENT);
        this.fDisplayContentsOfNewsRadio.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fDisplayContentsOfNewsRadio.setSelection(!this.fPrefOpenSiteForNews);
        Composite bottomSubContainer = new Composite(bottomContainer, 0);
        bottomSubContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 5));
        bottomSubContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        ((GridLayout)bottomSubContainer.getLayout()).marginLeft = 15;
        this.fLoadImagesForNewsCheck = new Button(bottomSubContainer, 32);
        this.fLoadImagesForNewsCheck.setText(Messages.DisplayPropertyPage_LOAD_IMAGES);
        this.fLoadImagesForNewsCheck.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLoadImagesForNewsCheck.setSelection(this.fPrefLoadImagesForNews);
        this.fLoadMediaForNewsCheck = new Button(bottomSubContainer, 32);
        this.fLoadMediaForNewsCheck.setText(Messages.DisplayPropertyPage_LOAD_MEDIA);
        this.fLoadMediaForNewsCheck.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fLoadMediaForNewsCheck.setSelection(this.fPrefLoadMediaForNews);
        this.fOpenLinkOfNewsRadio = new Button(bottomContainer, 16);
        this.fOpenLinkOfNewsRadio.setText(Messages.DisplayPropertyPage_OPEN_NEWS_LINK);
        this.fOpenLinkOfNewsRadio.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fOpenLinkOfNewsRadio.setSelection(this.fPrefOpenSiteForNews);
        this.fOpenLinkOfNewsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplayPropertyPage.this.updateDisplayButtons();
            }
        });
        bottomSubContainer = new Composite(bottomContainer, 0);
        bottomSubContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 5));
        bottomSubContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        ((GridLayout)bottomSubContainer.getLayout()).marginLeft = 15;
        this.fOpenSiteForEmptyNewsCheck = new Button(bottomSubContainer, 32);
        this.fOpenSiteForEmptyNewsCheck.setText(Messages.DisplayPropertyPage_ONLY_EMPTY_CONTENT);
        this.fOpenSiteForEmptyNewsCheck.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fOpenSiteForEmptyNewsCheck.setSelection(this.fPrefOpenSiteForEmptyNews);
        this.fOpenSiteForEmptyNewsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplayPropertyPage.this.updateDisplayButtons();
            }
        });
        this.fUseTransformerCheck = new Button(bottomSubContainer, 32);
        this.fUseTransformerCheck.setText(Messages.DisplayPropertyPage_USE_LINK_TRANSFORMER);
        this.fUseTransformerCheck.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        this.fUseTransformerCheck.setSelection(this.fPrefUseLinkTransformer);
        this.fUseTransformerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplayPropertyPage.this.updateDisplayButtons();
            }
        });
        Combo linkTransformerCombo = new Combo(bottomSubContainer, 2056);
        linkTransformerCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        this.fLinkTransformerViewer = new ComboViewer(linkTransformerCombo);
        this.fLinkTransformerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fLinkTransformerViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((LinkTransformer)element).getName();
            }
        });
        List<LinkTransformer> linkTransformers = Controller.getDefault().getLinkTransformers();
        this.fLinkTransformerViewer.setInput(linkTransformers);
        LinkTransformer selectedTransformer = Controller.getDefault().getLinkTransformer(this.fPrefLinkTransformerId);
        if (selectedTransformer == null) {
            selectedTransformer = linkTransformers.get(0);
        }
        this.fLinkTransformerViewer.setSelection((ISelection)new StructuredSelection((Object)selectedTransformer));
        this.updateDisplayButtons(false);
        return container;
    }

    private void updateDisplayButtons() {
        this.updateDisplayButtons(true);
    }

    private void updateDisplayButtons(boolean layout) {
        boolean isListLayout;
        boolean isNewspaperLayout = this.fLayoutCombo.getSelectionIndex() == OwlUI.Layout.NEWSPAPER.ordinal() || this.fLayoutCombo.getSelectionIndex() == OwlUI.Layout.HEADLINES.ordinal();
        boolean bl = isListLayout = this.fLayoutCombo.getSelectionIndex() == OwlUI.Layout.LIST.ordinal();
        if (isNewspaperLayout && !this.fDisplayContentsOfNewsRadio.getSelection()) {
            this.fDisplayContentsOfNewsRadio.setSelection(true);
            this.fOpenLinkOfNewsRadio.setSelection(false);
        }
        this.fDisplayContentsOfNewsRadio.setEnabled(!isListLayout);
        this.fLoadImagesForNewsCheck.setEnabled(!isListLayout && (this.fDisplayContentsOfNewsRadio.getSelection() || this.fOpenSiteForEmptyNewsCheck.getSelection()));
        this.fLoadMediaForNewsCheck.setEnabled(!isListLayout && (this.fDisplayContentsOfNewsRadio.getSelection() || this.fOpenSiteForEmptyNewsCheck.getSelection()));
        this.fOpenLinkOfNewsRadio.setEnabled(!isListLayout && !isNewspaperLayout);
        this.fOpenSiteForEmptyNewsCheck.setEnabled(!isListLayout && !isNewspaperLayout && this.fOpenLinkOfNewsRadio.getSelection());
        this.fUseTransformerCheck.setEnabled(!isListLayout && !isNewspaperLayout && this.fOpenLinkOfNewsRadio.getSelection());
        this.fLinkTransformerViewer.getCombo().setEnabled(!isListLayout && !isNewspaperLayout && this.fOpenLinkOfNewsRadio.getSelection() && this.fUseTransformerCheck.getSelection());
        GridData data = (GridData)this.fLayoutCombo.getLayoutData();
        data.horizontalSpan = isNewspaperLayout ? 1 : 2;
        data = (GridData)this.fPageSizeCombo.getLayoutData();
        boolean bl2 = data.exclude = !isNewspaperLayout;
        if (layout) {
            this.fPageSizeCombo.getParent().getParent().layout(true, true);
        }
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        this.fSettingsChanged = false;
        for (IPreferenceScope scope : this.fEntityPreferences) {
            if (!this.updatePreferences(scope)) continue;
            IEntity entityToSave = this.fEntities.get(this.fEntityPreferences.indexOf(scope));
            entitiesToSave.add(entityToSave);
            this.fSettingsChanged = true;
        }
        for (IEntity entity : this.fEntities) {
            if (!this.fSettingsChanged || !(entity instanceof IFolder)) continue;
            this.updateChildPreferences((IFolder)entity);
        }
        return true;
    }

    private void updateChildPreferences(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)mark);
            this.updatePreferences(scope);
        }
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)childFolder);
            this.updatePreferences(scope);
            this.updateChildPreferences(childFolder);
        }
    }

    private boolean updatePreferences(IPreferenceScope scope) {
        LinkTransformer transformer;
        IStructuredSelection selection;
        boolean changed = false;
        int iVal = this.fFilterCombo.getSelectionIndex();
        if (this.fPrefSelectedFilter != iVal) {
            scope.putInteger(DefaultPreferences.BM_NEWS_FILTERING, iVal);
            changed = true;
        }
        if (this.fPrefSelectedGroup != (iVal = this.fGroupCombo.getSelectionIndex())) {
            scope.putInteger(DefaultPreferences.BM_NEWS_GROUPING, iVal);
            changed = true;
        }
        if (this.fPrefSelectedLayout != (iVal = this.fLayoutCombo.getSelectionIndex())) {
            scope.putInteger(DefaultPreferences.FV_LAYOUT, iVal);
            changed = true;
        }
        iVal = this.fPageSizeCombo.getSelectionIndex();
        OwlUI.PageSize size = OwlUI.PageSize.values()[iVal];
        if (this.fPrefSelectedPageSize != size.getPageSize()) {
            scope.putInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE, size.getPageSize());
            changed = true;
        }
        boolean otherDisplayChanges = false;
        if (this.fOpenLinkOfNewsRadio.getSelection() != this.fPrefOpenSiteForNews) {
            otherDisplayChanges = true;
        } else if (this.fOpenSiteForEmptyNewsCheck.getSelection() != this.fPrefOpenSiteForEmptyNews) {
            otherDisplayChanges = true;
        } else if (this.fLoadImagesForNewsCheck.getSelection() != this.fPrefLoadImagesForNews) {
            otherDisplayChanges = true;
        } else if (this.fLoadMediaForNewsCheck.getSelection() != this.fPrefLoadMediaForNews) {
            otherDisplayChanges = true;
        } else if (this.fUseTransformerCheck.getSelection() != this.fPrefUseLinkTransformer) {
            otherDisplayChanges = true;
        } else {
            selection = (IStructuredSelection)this.fLinkTransformerViewer.getSelection();
            if (!selection.isEmpty() && !(transformer = (LinkTransformer)selection.getFirstElement()).getId().equals(this.fPrefLinkTransformerId)) {
                otherDisplayChanges = true;
            }
        }
        if (otherDisplayChanges) {
            changed = true;
            scope.putBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_NEWS, this.fOpenLinkOfNewsRadio.getSelection());
            scope.putBoolean(DefaultPreferences.BM_OPEN_SITE_FOR_EMPTY_NEWS, this.fOpenSiteForEmptyNewsCheck.getSelection());
            scope.putBoolean(DefaultPreferences.ENABLE_IMAGES, this.fLoadImagesForNewsCheck.getSelection());
            scope.putBoolean(DefaultPreferences.ENABLE_MEDIA, this.fLoadMediaForNewsCheck.getSelection());
            scope.putBoolean(DefaultPreferences.BM_USE_TRANSFORMER, this.fUseTransformerCheck.getSelection());
            selection = (IStructuredSelection)this.fLinkTransformerViewer.getSelection();
            if (!selection.isEmpty()) {
                transformer = (LinkTransformer)selection.getFirstElement();
                scope.putString(DefaultPreferences.BM_TRANSFORMER_ID, transformer.getId());
            }
        }
        return changed;
    }

    @Override
    public void finish() {
        if (this.fSettingsChanged) {
            EditorUtils.updateLayout();
            EditorUtils.updateFilterAndGrouping();
        }
    }
}

