/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.LayoutUtils;

public class NewNewsBinAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private Shell fShell;
    private IFolder fParent;
    private IMark fPosition;
    private INewsBin fNewsbin;

    public NewNewsBinAction() {
        this(null, null, null);
    }

    public NewNewsBinAction(Shell shell, IFolder parent, IMark position) {
        this.fShell = shell;
        this.fParent = parent;
        this.fPosition = position;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        this.internalRun();
    }

    private void internalRun() throws PersistenceException {
        IFolder parent = OwlUI.getSelectedParent(this.fParent);
        NewNewsBinDialog dialog = new NewNewsBinDialog(this.fShell, parent);
        if (dialog.open() == 0) {
            String title = dialog.fName;
            parent = dialog.getFolder();
            this.fNewsbin = Owl.getModelFactory().createNewsBin(null, parent, title, (IFolderChild)this.fPosition, this.fPosition != null ? Boolean.valueOf(true) : null);
            Map properties = parent.getProperties();
            for (Map.Entry property : properties.entrySet()) {
                this.fNewsbin.setProperty((String)property.getKey(), (Serializable)property.getValue());
            }
            DynamicDAO.save((IPersistable)parent);
        }
    }

    public INewsBin getNewsbin() {
        return this.fNewsbin;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structSel;
        this.fParent = null;
        this.fPosition = null;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty()) {
            Object firstElement = structSel.getFirstElement();
            if (firstElement instanceof IFolder) {
                this.fParent = (IFolder)firstElement;
            } else if (firstElement instanceof IMark) {
                this.fParent = ((IMark)firstElement).getParent();
                this.fPosition = (IMark)firstElement;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fShell = targetPart.getSite().getShell();
    }

    private static class NewNewsBinDialog
    extends TitleAreaDialog {
        private Text fNameInput;
        private ResourceManager fResources;
        private String fName;
        private IFolder fFolder;
        private FolderChooser fFolderChooser;

        NewNewsBinDialog(Shell shell, IFolder folder) {
            super(shell);
            this.fFolder = folder;
            this.fResources = new LocalResourceManager(JFaceResources.getResources());
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(false);
        }

        protected void okPressed() {
            this.fName = this.fNameInput.getText();
            super.okPressed();
        }

        public boolean close() {
            boolean res = super.close();
            this.fResources.dispose();
            return res;
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(Messages.NewNewsBinAction_NEW_NEWSBIN);
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
            this.setTitle(Messages.NewNewsBinAction_NEWSBIN);
            this.setTitleImage(OwlUI.getImage(this.fResources, "icons/wizban/newsbin_wiz.gif"));
            this.setMessage(Messages.NewNewsBinAction_NEW_NEWSBIN_MSG);
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5));
            container.setLayoutData((Object)new GridData(4, 1, true, false));
            Label l1 = new Label(container, 0);
            l1.setText(Messages.NewNewsBinAction_NAME);
            this.fNameInput = new Text(container, 2052);
            this.fNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fNameInput.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewNewsBinDialog.this.validateInput();
                }
            });
            Label l3 = new Label(container, 0);
            l3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            l3.setText(Messages.NewNewsBinAction_LOCATION);
            this.fFolderChooser = new FolderChooser(container, this.fFolder, 2048, true);
            this.fFolderChooser.setLayoutData(new GridData(4, 1, true, false));
            this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
            this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
            NewNewsBinDialog.applyDialogFont((Control)container);
            return container;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(300), -1);
            this.getShell().setSize(bestSize.x, bestSize.y);
            LayoutUtils.positionShell(this.getShell());
        }

        private void validateInput() {
            boolean valid = this.fNameInput.getText().length() > 0;
            Button button = this.getButton(0);
            button.setEnabled(valid);
            this.setMessage(Messages.NewNewsBinAction_NEW_NEWSBIN_MSG);
        }

        IFolder getFolder() {
            return this.fFolderChooser.getFolder();
        }
    }
}

