/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AnchorDialog;
import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.ImageDialog;
import com.lightdev.app.shtm.ImagePreview;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

class LinkDialog
extends DialogShell
implements ActionListener {
    private Hashtable linkTypes;
    private Hashtable linkTypeNames;
    private String addressCache = null;
    private final Document doc;
    private final SHTMLEditorPane editorPane;
    private final JComboBox linkStyle;
    private final JComboBox linkType;
    private final JTextField linkAddress;
    private final JButton browseAddress;
    private final JTextField linkAnchor;
    private final JButton browseAnchor;
    private final JTextField linkText;
    private final JRadioButton showAsText;
    private final JRadioButton showAsImage;
    private String linkImageFileName;
    private final ImagePreview linkImage;
    private final JButton setImage;
    private final JTextField linkImgWidth;
    private final JTextField linkImgHeight;
    private final JPanel linkTextPanel;
    private final JPanel linkImagePanel;
    private final String LINK_TYPE_KEY = "linkType";
    private final String LINK_TYPE_NAME_KEY = "linkTypeName";
    private final String LINK_TYPE_RELATIVE_KEY = Util.getResourceString("linkType1");
    private final String LINK_TYPE_NEWS_KEY = Util.getResourceString("linkType7");
    private final String LINK_TYPE_MAILTO_KEY = Util.getResourceString("linkType8");
    private final String LINK_TYPE_RELATIVE = Util.getResourceString("linkTypeName1");
    private final String LINK_TYPE_LOCAL = Util.getResourceString("linkTypeName2");
    private final String LINK_TYPE_NEWS = Util.getResourceString("linkTypeName7");
    private final String LINK_TYPE_MAILTO = Util.getResourceString("linkTypeName8");
    private boolean ignoreActions = false;
    private final File imgDir;
    private String imgFile = null;
    private static final String helpTopicId = "item164";
    private static boolean simpleLinkDialog = Util.preferenceIsTrue("simpleLinkDialog");

    public LinkDialog(Frame parent, String title, SHTMLEditorPane editorPane, File imgDir) {
        super(parent, title, helpTopicId);
        this.editorPane = editorPane;
        this.doc = editorPane.getSHTMLDocument();
        this.imgDir = imgDir;
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(g);
        JLabel lb = new JLabel(Util.getResourceString("linkStyleLabel"));
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, lb, g, c, 0, 0, 13);
        }
        Vector styleNames = Util.getStyleNamesForTag(((SHTMLDocument)this.doc).getStyleSheet(), HTML.Tag.A.toString());
        String standardStyleName = Util.getResourceString("standardStyleName");
        styleNames.insertElementAt(standardStyleName, 0);
        this.linkStyle = new JComboBox(styleNames);
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, this.linkStyle, g, c, 1, 0, 17);
        }
        lb = new JLabel(Util.getResourceString("linkTypeLabel"));
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, lb, g, c, 0, 1, 13);
        }
        this.buildLinkTypes();
        this.linkType = new JComboBox<Object>(this.linkTypeNames.values().toArray());
        this.linkType.addActionListener(this);
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, this.linkType, g, c, 1, 1, 17);
        }
        lb = new JLabel(Util.getResourceString("linkAddressLabel"));
        Util.addGridBagComponent(p, lb, g, c, 0, 2, 13);
        this.linkAddress = new JTextField();
        this.linkAddress.setPreferredSize(new Dimension(300, 20));
        this.linkAddress.setMaximumSize(new Dimension(500, 20));
        this.linkAddress.addActionListener(this);
        Util.addGridBagComponent(p, this.linkAddress, g, c, 1, 2, 17, 2, 1, 2, 1.0, 0.0);
        this.browseAddress = new JButton(Util.getResourceString("linkBrowseLabel"));
        this.browseAddress.addActionListener(this);
        Util.addGridBagComponent(p, this.browseAddress, g, c, 3, 2, 17);
        lb = new JLabel(Util.getResourceString("linkAnchorLabel"));
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, lb, g, c, 0, 3, 13);
        }
        this.linkAnchor = new JTextField();
        this.linkAnchor.setPreferredSize(new Dimension(150, 20));
        this.linkAnchor.setMaximumSize(new Dimension(500, 20));
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, this.linkAnchor, g, c, 1, 3, 17, 1, 1, 2, 1.0, 0.0);
        }
        this.browseAnchor = new JButton(Util.getResourceString("linkBrowseLabel"));
        this.browseAnchor.addActionListener(this);
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, this.browseAnchor, g, c, 2, 3, 17);
        }
        lb = new JLabel(Util.getResourceString("linkDisplayLabel"));
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, lb, g, c, 0, 4, 13);
        }
        this.showAsText = new JRadioButton(Util.getResourceString("showAsTextLabel"));
        this.showAsText.addActionListener(this);
        this.showAsImage = new JRadioButton(Util.getResourceString("showAsImageLabel"));
        this.showAsImage.addActionListener(this);
        JPanel helpPanel = new JPanel();
        helpPanel.add(this.showAsText);
        helpPanel.add(this.showAsImage);
        if (!simpleLinkDialog) {
            Util.addGridBagComponent(p, helpPanel, g, c, 1, 4, 17);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.showAsText);
        bg.add(this.showAsImage);
        this.linkTextPanel = new JPanel(new BorderLayout());
        this.linkTextPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("linkTextLabel")));
        this.linkText = new JTextField();
        this.linkText.setPreferredSize(new Dimension(400, 20));
        this.linkText.setMaximumSize(new Dimension(500, 20));
        if (!simpleLinkDialog) {
            this.linkTextPanel.add((Component)this.linkText, "Center");
            Util.addGridBagComponent(p, this.linkTextPanel, g, c, 1, 5, 17, 2, 1, 2, 1.0, 0.0);
        } else {
            lb = new JLabel(Util.getResourceString("linkTextLabel"));
            Util.addGridBagComponent(p, lb, g, c, 0, 5, 13);
            Util.addGridBagComponent(p, this.linkText, g, c, 1, 5, 17, 2, 1, 2, 1.0, 0.0);
        }
        this.linkImagePanel = new JPanel(new BorderLayout(5, 5));
        this.linkImagePanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("linkImageLabel")));
        this.linkImage = new ImagePreview();
        this.linkImage.setPreferredSize(new Dimension(70, 70));
        this.linkImagePanel.add((Component)new JScrollPane(this.linkImage), "Center");
        helpPanel = new JPanel(g);
        lb = new JLabel(Util.getResourceString("imgWidthLabel"));
        Util.addGridBagComponent(helpPanel, lb, g, c, 0, 0, 13);
        this.linkImgWidth = new JTextField();
        this.linkImgWidth.setPreferredSize(new Dimension(50, 20));
        this.linkImgWidth.setMinimumSize(new Dimension(50, 20));
        this.linkImgWidth.setEditable(false);
        Util.addGridBagComponent(helpPanel, this.linkImgWidth, g, c, 1, 0, 17);
        lb = new JLabel(Util.getResourceString("imgHeightLabel"));
        Util.addGridBagComponent(helpPanel, lb, g, c, 0, 1, 13);
        this.linkImgHeight = new JTextField();
        this.linkImgHeight.setPreferredSize(new Dimension(50, 20));
        this.linkImgHeight.setMinimumSize(new Dimension(50, 20));
        this.linkImgHeight.setEditable(false);
        Util.addGridBagComponent(helpPanel, this.linkImgHeight, g, c, 1, 1, 17);
        this.setImage = new JButton(Util.getResourceString("setImageLabel"));
        this.setImage.addActionListener(this);
        Util.addGridBagComponent(helpPanel, this.setImage, g, c, 1, 2, 17);
        JPanel helpPanel2 = new JPanel(new BorderLayout());
        helpPanel2.add((Component)helpPanel, "North");
        this.linkImagePanel.add((Component)helpPanel2, "East");
        Util.addGridBagComponent(p, this.linkImagePanel, g, c, 1, 5, 17, 2, 1, 1, 1.0, 1.0);
        Container contentPane = super.getContentPane();
        contentPane.add((Component)p, "Center");
        this.linkAddress.addKeyListener(this.getCompletionKeyListener());
        this.linkText.addKeyListener(this.getCompletionKeyListener());
        this.linkAnchor.addKeyListener(this.getCompletionKeyListener());
        this.pack();
        if (!this.setExistingLink(editorPane.getSelectionStart(), editorPane.getSelectionEnd())) {
            this.setLinkText(editorPane.getSelectionStart(), editorPane.getSelectionEnd());
        }
    }

    private void setLinkText(int start, int end) {
        try {
            this.linkText.setText(this.doc.getText(start, end - start));
            this.showAsText.setSelected(true);
            this.linkTextPanel.setVisible(true);
            this.linkImagePanel.setVisible(false);
        }
        catch (BadLocationException ble) {
            Util.errMsg(this, ble.getLocalizedMessage(), ble);
        }
    }

    private boolean setExistingLink(int selectionStart, int selectionEnd) {
        boolean foundLink;
        this.setIgnoreActions(true);
        Element linkElement = this.editorPane.getCurrentLinkElement();
        boolean bl = foundLink = linkElement != null;
        if (foundLink) {
            AttributeSet elemAttrs = linkElement.getAttributes();
            Object linkAttr = elemAttrs.getAttribute(HTML.Tag.A);
            Object href = ((AttributeSet)linkAttr).getAttribute(HTML.Attribute.HREF);
            if (href != null) {
                try {
                    this.setDialogFromUrl(new URL(href.toString()));
                }
                catch (Exception ex) {
                    this.setDialogFromRelative(href.toString());
                }
                Object img = elemAttrs.getAttribute(HTML.Attribute.SRC);
                if (img != null) {
                    this.setLinkImage(img, elemAttrs);
                } else {
                    this.setLinkText(linkElement.getStartOffset(), linkElement.getEndOffset());
                }
            }
        } else {
            this.linkType.setSelectedItem(this.LINK_TYPE_LOCAL);
            this.setLinkText(selectionStart, selectionEnd);
        }
        this.setIgnoreActions(false);
        return foundLink;
    }

    public void setLinkImage(Object imgAttr, AttributeSet attrSet) {
        Object height;
        Object width;
        String wStr = null;
        String hStr = null;
        if (imgAttr != null) {
            this.imgFile = Util.resolveRelativePath(imgAttr.toString(), ((SHTMLDocument)this.doc).getBase().getPath()).replace('/', File.separatorChar);
            while (this.imgFile.startsWith(File.separator)) {
                this.imgFile = this.imgFile.substring(1);
            }
        }
        if ((width = attrSet.getAttribute(HTML.Attribute.WIDTH)) != null) {
            wStr = width.toString();
        }
        if ((height = attrSet.getAttribute(HTML.Attribute.HEIGHT)) != null) {
            hStr = height.toString();
        }
        this.setImageSpecs(wStr, hStr);
        this.showAsImage.setSelected(true);
        this.linkTextPanel.setVisible(false);
        this.linkImagePanel.setVisible(true);
    }

    public String getLinkText() {
        return this.linkText.getText();
    }

    public String getStyleName() {
        return this.linkStyle.getSelectedItem().toString();
    }

    public void setIgnoreActions(boolean ignore) {
        this.ignoreActions = ignore;
    }

    private void setDialogFromUrl(URL url) {
        if (url == null) {
            return;
        }
        if (simpleLinkDialog) {
            this.setLinkAddress(url.toString());
            return;
        }
        String protocol = url.getProtocol();
        String protName = protocol != null ? (String)this.linkTypeNames.get(protocol) : (String)this.linkTypeNames.get(this.LINK_TYPE_RELATIVE_KEY);
        if (protName != null) {
            this.linkType.setSelectedItem(protName);
        }
        this.setLinkAddress(this.getPathFromUrl(url, protocol));
        this.linkAnchor.setText(url.getRef());
    }

    private String getPathFromUrl(URL url, String protocol) {
        String path = "";
        String urlStr = url.toString();
        int pos = urlStr.indexOf(protocol);
        if (pos > -1) {
            path = urlStr.substring(protocol.length());
            while (path.startsWith("/") || path.startsWith(":")) {
                path = path.substring(1);
            }
        }
        if ((pos = path.indexOf("#")) > -1) {
            path = path.substring(0, pos);
        }
        return path;
    }

    private void setDialogFromRelative(String hrefStr) {
        this.linkType.setSelectedItem(this.LINK_TYPE_RELATIVE);
        int pos = hrefStr.indexOf("#");
        if (pos > -1) {
            this.linkAnchor.setText(hrefStr.substring(pos + 1));
            hrefStr = hrefStr.substring(0, pos);
        }
        this.setLinkAddress(hrefStr);
    }

    private void buildLinkTypes() {
        this.linkTypes = new Hashtable();
        this.linkTypeNames = new Hashtable();
        for (int i = 1; i < 9; ++i) {
            String type = Util.getResourceString("linkType" + Integer.toString(i));
            String name = Util.getResourceString("linkTypeName" + Integer.toString(i));
            this.linkTypes.put(name, type);
            this.linkTypeNames.put(type, name);
        }
    }

    private boolean linkAddressHasProtocol() {
        return this.linkAddress.getText().indexOf(58) >= 0;
    }

    private String getProtocol() {
        String prot = null;
        try {
            String protName = this.linkType.getSelectedItem().toString();
            if (!protName.equalsIgnoreCase(this.LINK_TYPE_RELATIVE)) {
                prot = this.transformProtocol(this.linkTypes.get(protName).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prot;
    }

    private String transformProtocol(String protName) {
        StringBuffer prot = new StringBuffer(protName);
        if (protName.equalsIgnoreCase(this.LINK_TYPE_MAILTO_KEY) || protName.equalsIgnoreCase(this.LINK_TYPE_NEWS_KEY)) {
            prot.append(":");
        } else if (!protName.equalsIgnoreCase(this.LINK_TYPE_RELATIVE_KEY)) {
            prot.append(":/");
        }
        return prot.toString();
    }

    private File chooseFile() {
        File file = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setSelectedFile(new File(((SHTMLDocument)this.doc).getBase().getFile()));
        if (chooser.showOpenDialog(this) == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    private void setLinkAddress(String address) {
        this.addressCache = this.getLinkAddress();
        this.linkAddress.setText(address);
    }

    public AttributeSet getLinkAttribute() {
        SimpleAttributeSet aSet = new SimpleAttributeSet();
        aSet.addAttribute(HTML.Attribute.HREF, this.getHref());
        SimpleAttributeSet set = new SimpleAttributeSet();
        if (this.showAsImage.isSelected()) {
            SimpleAttributeSet imgSet = new SimpleAttributeSet();
            imgSet.addAttribute(HTML.Attribute.SRC, this.imgFile);
            set.addAttribute(HTML.Tag.IMG, imgSet);
        }
        set.addAttribute(HTML.Tag.A, aSet);
        return set;
    }

    public String getLinkImage() {
        if (this.showAsImage.isSelected()) {
            return this.imgFile;
        }
        return null;
    }

    public Dimension getLinkImageSize() {
        if (this.showAsImage.isSelected()) {
            try {
                return new Dimension(Integer.parseInt(this.linkImgWidth.getText()), Integer.parseInt(this.linkImgHeight.getText()));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getLinkAddress() {
        String link = this.linkAddress.getText();
        String prot = this.getProtocol();
        if (!(prot == null || this.linkAddressHasProtocol() || prot.equalsIgnoreCase(this.transformProtocol(this.LINK_TYPE_RELATIVE_KEY)) || prot.equalsIgnoreCase(this.transformProtocol(this.LINK_TYPE_MAILTO_KEY)) || link.startsWith("/"))) {
            link = "/" + link;
        }
        return link;
    }

    public String getHref() {
        StringBuffer href = new StringBuffer();
        String protocol = this.getProtocol();
        String linkAddressText = this.linkAddress.getText();
        String linkAnchorText = this.linkAnchor.getText();
        if ((linkAddressText == null || linkAddressText.length() < 1) && linkAnchorText != null && linkAnchorText.length() > 0) {
            href.append("#");
            href.append(linkAnchorText);
        } else {
            if (protocol != null && !this.linkAddressHasProtocol()) {
                href.append(protocol);
            }
            href.append(this.getLinkAddress());
            String anchor = this.linkAnchor.getText();
            if (anchor.length() > 0) {
                href.append("#");
                href.append(anchor);
            }
        }
        return href.toString();
    }

    private File getLinkedFile() {
        File file = null;
        try {
            String prot = this.linkType.getSelectedItem().toString();
            if (prot.equalsIgnoreCase(this.LINK_TYPE_LOCAL)) {
                file = new File(this.getLinkAddress().replace('/', File.separatorChar));
            } else if (prot.equalsIgnoreCase(this.LINK_TYPE_RELATIVE)) {
                new File(((SHTMLDocument)this.doc).getBase().getPath());
                String toStr = this.getLinkAddress();
                new File(toStr);
                file = new File(Util.resolveRelativePath(this.getLinkAddress(), ((SHTMLDocument)this.doc).getBase().getPath()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.ignoreActions) {
            Object source = e.getSource();
            if (source.equals(this.showAsText)) {
                this.linkTextPanel.setVisible(true);
                this.linkImagePanel.setVisible(false);
            } else if (source.equals(this.showAsImage)) {
                this.linkTextPanel.setVisible(false);
                this.linkImagePanel.setVisible(true);
            } else if (source.equals(this.browseAddress)) {
                File file = this.chooseFile();
                if (file != null) {
                    if (simpleLinkDialog) {
                        try {
                            this.setLinkAddress(file.toURI().toURL().toString());
                        }
                        catch (Exception ex) {}
                    } else {
                        this.setLinkAddress(file.getPath().replace(File.separatorChar, '/'));
                    }
                }
            } else if (source.equals(this.linkType)) {
                this.handleLinkTypeAction();
            } else if (source.equals(this.browseAnchor)) {
                this.handleBrowseAnchorAction();
            } else if (source.equals(this.setImage)) {
                this.handleLinkImageAction();
            } else {
                super.actionPerformed(e);
            }
        }
    }

    private void handleLinkImageAction() {
        ImageDialog dlg = new ImageDialog((Dialog)this, Util.getResourceString("imageDialogTitle"), this.imgDir);
        if (this.imgFile != null) {
            dlg.setImage(this.imgFile, this.linkImgWidth.getText(), this.linkImgHeight.getText());
        }
        Util.center(this, dlg);
        dlg.setModal(true);
        dlg.setVisible(true);
        if (dlg.getResult() == DialogShell.RESULT_OK) {
            this.imgFile = Util.resolveRelativePath(dlg.getImageSrc(), ((SHTMLDocument)this.doc).getBase().getPath()).replace('/', File.separatorChar);
            while (this.imgFile.startsWith(File.separator)) {
                this.imgFile = this.imgFile.substring(1);
            }
            this.setImageSpecs(dlg.getImgWidth().toString(), dlg.getImgHeight().toString());
        }
    }

    private void setImageSpecs(String width, String height) {
        ImageIcon icon = new ImageIcon(this.imgFile);
        this.linkImage.setImage(icon);
        this.linkImage.setScale(100);
        if (width != null) {
            this.linkImgWidth.setText(width);
            this.linkImage.setPreviewWidth(Integer.parseInt(width));
        }
        if (height != null) {
            this.linkImgHeight.setText(height);
            this.linkImage.setPreviewHeight(Integer.parseInt(height));
        }
    }

    private void handleLinkTypeAction() {
        String type = this.linkType.getSelectedItem().toString();
        this.browseAddress.setEnabled(type.equalsIgnoreCase(this.LINK_TYPE_LOCAL));
        this.browseAnchor.setEnabled(type.equalsIgnoreCase(this.LINK_TYPE_LOCAL) || type.equalsIgnoreCase(this.LINK_TYPE_RELATIVE));
        if (type.equalsIgnoreCase(this.LINK_TYPE_RELATIVE)) {
            try {
                File from = new File(((SHTMLDocument)this.doc).getBase().getPath());
                String toStr = this.getLinkAddress();
                File to = new File(toStr);
                this.setLinkAddress(Util.getRelativePath(from, to));
            }
            catch (Exception ex) {
                Util.errMsg(this, null, ex);
            }
        } else if (type.equalsIgnoreCase(this.LINK_TYPE_LOCAL)) {
            try {
                String absPath = ((SHTMLDocument)this.doc).getBase().getFile().substring(1);
                String relPath = this.getLinkAddress();
                this.setLinkAddress("/" + Util.resolveRelativePath(relPath, absPath));
            }
            catch (Exception ex) {
                Util.errMsg(this, ex.getMessage(), ex);
            }
        }
    }

    private void handleBrowseAnchorAction() {
        try {
            File file = this.getLinkedFile();
            String linkAddrText = this.linkAddress.getText();
            AnchorDialog anchorDialog = linkAddrText == null || linkAddrText.length() < 1 ? new AnchorDialog((Dialog)this, Util.getResourceString("anchorDialogTitle"), this.doc) : new AnchorDialog((Dialog)this, Util.getResourceString("anchorDialogTitle"), file.toURI().toURL());
            Util.center(this, anchorDialog);
            anchorDialog.setModal(true);
            anchorDialog.setVisible(true);
            if (anchorDialog.getResult() == DialogShell.RESULT_OK) {
                this.linkAnchor.setText(anchorDialog.getAnchor());
            }
        }
        catch (MalformedURLException ex) {
            Util.errMsg(this, ex.getMessage(), ex);
        }
    }
}

