/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.action.WebAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Downloader
extends WebAction {
    private static final Logger log = Logger.getLogger(Downloader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest() throws SQLException, IOException, BadRequestException {
        Request req = this.getRequest();
        Response res = this.getResponse();
        Locale locale = this.getLocale();
        Properties p = this.getProperties();
        if (p.get("www.disableDownloads").equals("yes")) {
            throw new BadRequestException(locale.getString("www.error.downloadsDisabled"), 403);
        }
        Database db = this.getDatabase();
        String[] args = req.getPlayParams(false);
        Vector<Track> tracks = Track.getTracksFromPlayArgs(db, args);
        res.addHeader("Content-length", Long.toString(this.getContentLength(tracks)));
        res.addHeader("Content-type", "application/zip");
        res.addHeader("Content-Disposition", "inline; filename=\"sockso-download.zip\"");
        res.sendHeaders();
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(res.getOutputStream());
            for (Track track : tracks) {
                this.addTrackToZip(zip, track);
            }
        }
        finally {
            zip.close();
        }
    }

    private long getContentLength(Vector<Track> tracks) {
        long total = 0L;
        for (Track track : tracks) {
            total += new File(track.getPath()).length();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrackToZip(ZipOutputStream zip, Track track) throws IOException {
        byte[] buf = new byte[4096];
        FileInputStream is = null;
        try {
            int retval;
            String name = this.getTrackZipPath(track);
            is = new FileInputStream(track.getPath());
            zip.putNextEntry(new ZipEntry(name));
            do {
                if ((retval = is.read(buf, 0, 4096)) == -1) continue;
                zip.write(buf, 0, retval);
            } while (retval != -1);
            zip.closeEntry();
        }
        catch (Throwable throwable) {
            Utils.close(is);
            throw throwable;
        }
        Utils.close(is);
    }

    protected String getTrackZipPath(Track track) {
        int number = track.getNumber();
        return track.getArtist().getName() + "/" + track.getAlbum().getName() + "/" + (number == 0 ? "" : this.padTens(number) + " - ") + track.getName() + "." + Utils.getExt(track.getPath());
    }

    private String padTens(int number) {
        String strNum = Integer.toString(number);
        return number < 10 ? "0" + strNum : strNum;
    }
}

