/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.auth.DBAuthenticator;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.Downloader;
import com.pugh.sockso.web.action.Feeder;
import com.pugh.sockso.web.action.FileServer;
import com.pugh.sockso.web.action.Homer;
import com.pugh.sockso.web.action.Jsoner;
import com.pugh.sockso.web.action.Nater;
import com.pugh.sockso.web.action.Player;
import com.pugh.sockso.web.action.Sharer;
import com.pugh.sockso.web.action.Streamer;
import com.pugh.sockso.web.action.Uploader;
import com.pugh.sockso.web.action.Userer;
import com.pugh.sockso.web.action.WebAction;
import com.pugh.sockso.web.action.browse.Albumer;
import com.pugh.sockso.web.action.browse.Artister;
import com.pugh.sockso.web.action.browse.ByLetterer;
import com.pugh.sockso.web.action.browse.Folderer;
import com.pugh.sockso.web.action.browse.Latester;
import com.pugh.sockso.web.action.browse.Playlister;
import com.pugh.sockso.web.action.browse.Playlistser;
import com.pugh.sockso.web.action.browse.Popularer;
import com.pugh.sockso.web.action.playlist.M3uer;
import com.pugh.sockso.web.action.playlist.Plser;
import com.pugh.sockso.web.action.playlist.Xspfer;

public class Dispatcher {
    private final String protocol;
    private final int port;
    private final Properties p;
    private final Resources r;
    private final CollectionManager cm;
    private final Database db;

    public Dispatcher(String protocol, int port, Properties p, Resources r, CollectionManager cm, Database db) {
        this.protocol = protocol;
        this.port = port;
        this.p = p;
        this.r = r;
        this.cm = cm;
        this.db = db;
    }

    public WebAction getAction(Request req) {
        String command = req.getUrlParam(0);
        String host = this.getHost();
        WebAction action = null;
        if (command.equals("file")) {
            action = new FileServer(this.r);
        } else if (command.equals("browse")) {
            action = this.getBrowseAction(req);
        } else if (command.equals("")) {
            action = new Homer();
        } else if (command.equals("xspf")) {
            action = new Xspfer(this.protocol);
        } else if (command.equals("m3u")) {
            action = new M3uer(this.protocol);
        } else if (command.equals("pls")) {
            action = new Plser(this.protocol);
        } else if (command.equals("stream")) {
            action = new Streamer();
        } else if (command.equals("json")) {
            action = new Jsoner(this.cm);
        } else if (command.equals("user")) {
            Userer u = new Userer();
            u.addAuthenticator(new DBAuthenticator(this.db));
            action = u;
        } else if (command.equals("player")) {
            action = new Player();
        } else if (command.equals("download")) {
            action = new Downloader();
        } else if (command.equals("upload")) {
            action = new Uploader(this.cm);
        } else if (command.equals("share")) {
            action = new Sharer(host);
        } else if (command.equals("rss")) {
            action = new Feeder(host);
        } else if (command.equals("nat")) {
            action = new Nater();
        }
        if (action != null) {
            action.setDatabase(this.db);
            action.setProperties(this.p);
        }
        return action;
    }

    protected WebAction getBrowseAction(Request req) {
        String command = req.getUrlParam(1);
        if (command.equals("folders")) {
            return new Folderer();
        }
        if (command.equals("popular")) {
            return new Popularer();
        }
        if (command.equals("latest")) {
            return new Latester();
        }
        if (command.equals("letter")) {
            return new ByLetterer();
        }
        if (command.equals("artist")) {
            return new Artister();
        }
        if (command.equals("album")) {
            return new Albumer();
        }
        if (command.equals("playlists")) {
            return new Playlistser();
        }
        if (command.equals("playlist")) {
            return new Playlister();
        }
        return null;
    }

    public String getHost() {
        return this.p.get("server.host") + ":" + this.port;
    }
}

