/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.dialogs;

import freemind.main.FreeMindMain;
import freemind.modes.IconInformation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class IconSelectionPopupDialog
extends JDialog
implements KeyListener,
MouseListener {
    private Vector icons;
    private int result;
    private JPanel iconPanel = new JPanel();
    private JLabel[] iconLabels;
    private JLabel descriptionLabel;
    private int numOfIcons;
    private int xDimension;
    private int yDimension;
    private Position selected = new Position(0, 0);
    private static Position lastPosition = new Position(0, 0);
    private FreeMindMain freeMindMain;
    private int mModifiers;

    public IconSelectionPopupDialog(JFrame caller, Vector icons, FreeMindMain freeMindMain) {
        super((Frame)caller, freeMindMain.getResourceString("select_icon"));
        this.getContentPane().setLayout(new BorderLayout());
        this.freeMindMain = freeMindMain;
        this.icons = icons;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                IconSelectionPopupDialog.this.close();
            }
        });
        this.numOfIcons = icons.size();
        this.xDimension = new Double(Math.ceil(Math.sqrt(this.numOfIcons))).intValue();
        this.yDimension = this.numOfIcons <= this.xDimension * (this.xDimension - 1) ? this.xDimension - 1 : this.xDimension;
        GridLayout gridlayout = new GridLayout(0, this.xDimension);
        gridlayout.setHgap(3);
        gridlayout.setVgap(3);
        this.iconPanel.setLayout(gridlayout);
        this.iconLabels = new JLabel[this.numOfIcons];
        for (int i = 0; i < this.numOfIcons; ++i) {
            IconInformation icon = (IconInformation)icons.get(i);
            this.iconLabels[i] = new JLabel(icon.getIcon());
            this.iconPanel.add(this.iconLabels[i]);
            this.iconLabels[i].setBorder(BorderFactory.createBevelBorder(0));
            this.iconLabels[i].addMouseListener(this);
        }
        int perIconSize = 27;
        this.iconPanel.setPreferredSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.iconPanel.setMinimumSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.iconPanel.setMaximumSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.iconPanel.setSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.getContentPane().add((Component)this.iconPanel, "Center");
        this.descriptionLabel = new JLabel(" ");
        this.getContentPane().add((Component)this.descriptionLabel, "South");
        this.setSelectedPosition(lastPosition);
        this.select(this.getSelectedPosition());
        this.addKeyListener(this);
        this.pack();
    }

    private boolean canSelect(Position position) {
        return position.getX() >= 0 && position.getX() < this.xDimension && position.getY() >= 0 && position.getY() < this.yDimension && this.calculateIndex(position) < this.numOfIcons;
    }

    private int calculateIndex(Position position) {
        return position.getY() * this.xDimension + position.getX();
    }

    private Position getPosition(JLabel caller) {
        int index = 0;
        for (index = 0; index < this.iconLabels.length && caller != this.iconLabels[index]; ++index) {
        }
        return this.getPositionFromIndex(index);
    }

    private Position getPositionFromIndex(int index) {
        return new Position(index % this.xDimension, index / this.xDimension);
    }

    private void setSelectedPosition(Position position) {
        this.selected = position;
        lastPosition = position;
    }

    private Position getSelectedPosition() {
        return this.selected;
    }

    private void select(Position position) {
        this.unhighlight(this.getSelectedPosition());
        this.setSelectedPosition(position);
        this.highlight(position);
        int index = this.calculateIndex(position);
        IconInformation iconInformation = (IconInformation)this.icons.get(index);
        String keyStroke = this.freeMindMain.getAdjustableProperty(iconInformation.getKeystrokeResourceName());
        if (keyStroke != null) {
            this.descriptionLabel.setText(iconInformation.getDescription() + ", " + keyStroke);
        } else {
            this.descriptionLabel.setText(iconInformation.getDescription());
        }
    }

    private void unhighlight(Position position) {
        this.iconLabels[this.calculateIndex(position)].setBorder(BorderFactory.createBevelBorder(0));
    }

    private void highlight(Position position) {
        this.iconLabels[this.calculateIndex(position)].setBorder(BorderFactory.createBevelBorder(1));
    }

    private void cursorLeft() {
        Position newPosition = new Position(this.getSelectedPosition().getX() - 1, this.getSelectedPosition().getY());
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorRight() {
        Position newPosition = new Position(this.getSelectedPosition().getX() + 1, this.getSelectedPosition().getY());
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorUp() {
        Position newPosition = new Position(this.getSelectedPosition().getX(), this.getSelectedPosition().getY() - 1);
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorDown() {
        Position newPosition = new Position(this.getSelectedPosition().getX(), this.getSelectedPosition().getY() + 1);
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void addIcon(int pModifiers) {
        this.result = this.calculateIndex(this.getSelectedPosition());
        this.mModifiers = pModifiers;
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public int getModifiers() {
        int m = this.mModifiers;
        if ((this.mModifiers & 0x41) != 0) {
            m |= 1;
        }
        if ((this.mModifiers & 0x82) != 0) {
            m |= 2;
        }
        if ((this.mModifiers & 0x208) != 0) {
            m |= 8;
        }
        return m;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: 
            case 227: {
                this.cursorRight();
                return;
            }
            case 37: 
            case 226: {
                this.cursorLeft();
                return;
            }
            case 40: 
            case 225: {
                this.cursorDown();
                return;
            }
            case 38: 
            case 224: {
                this.cursorUp();
                return;
            }
            case 27: {
                keyEvent.consume();
                this.close();
                return;
            }
            case 10: 
            case 32: {
                keyEvent.consume();
                this.addIcon(keyEvent.getModifiers());
                return;
            }
        }
        int index = this.findIndexByKeyEvent(keyEvent);
        if (index != -1) {
            this.result = index;
            lastPosition = this.getPositionFromIndex(index);
            this.mModifiers = keyEvent.getModifiers();
            keyEvent.consume();
            this.dispose();
        }
    }

    private KeyStroke getKeyStrokeForEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() != '\u0000') {
            return KeyStroke.getKeyStroke(keyEvent.getKeyChar());
        }
        return KeyStroke.getKeyStroke(keyEvent.getKeyCode(), 0);
    }

    private int findIndexByKeyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this.icons.size(); ++i) {
            IconInformation info = (IconInformation)this.icons.get(i);
            KeyStroke iconKeyStroke = info.getKeyStroke();
            if (iconKeyStroke == null || (keyEvent.getKeyCode() != iconKeyStroke.getKeyCode() || keyEvent.getKeyCode() == 0 || (iconKeyStroke.getModifiers() & 1) != (keyEvent.getModifiers() & 1)) && keyEvent.getKeyChar() != iconKeyStroke.getKeyChar() || keyEvent.getKeyChar() == '\u0000' || keyEvent.getKeyChar() == '\uffff') continue;
            return i;
        }
        return -1;
    }

    private void close() {
        this.result = -1;
        this.mModifiers = 0;
        this.dispose();
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.addIcon(mouseEvent.getModifiers());
    }

    public void mouseEntered(MouseEvent arg0) {
        this.select(this.getPosition((JLabel)arg0.getSource()));
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    static class Position {
        private int x;
        private int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.getX() + "," + this.getY() + ")";
        }
    }
}

