/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class ImportExplorerFavoritesAction
extends AbstractAction {
    private final MindMapController controller;

    public ImportExplorerFavoritesAction(MindMapController controller) {
        super(controller.getText("import_explorer_favorites"));
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(this.controller.getText("select_favorites_folder"));
        int returnVal = chooser.showOpenDialog(this.controller.getFrame().getContentPane());
        if (returnVal == 0) {
            File folder = chooser.getSelectedFile();
            this.controller.getFrame().out("Importing Favorites ...");
            this.importExplorerFavorites(folder, this.controller.getSelected(), true);
            this.controller.getFrame().out("Favorites imported.");
        }
    }

    public boolean importExplorerFavorites(File folder, MindMapNode target, boolean redisplay) {
        boolean favoritesFound = false;
        if (folder.isDirectory()) {
            int i;
            File[] list = folder.listFiles();
            for (i = 0; i < list.length; ++i) {
                if (!list[i].isDirectory()) continue;
                String nodeContent = list[i].getName();
                MindMapNode node = this.addNode(target, nodeContent);
                boolean favoritesFoundInSubfolder = this.importExplorerFavorites(list[i], node, false);
                if (favoritesFoundInSubfolder) {
                    favoritesFound = true;
                    continue;
                }
                this.controller.deleteNode(node);
            }
            block3: for (i = 0; i < list.length; ++i) {
                if (list[i].isDirectory() || !Tools.getExtension(list[i]).equals("url")) continue;
                favoritesFound = true;
                try {
                    MindMapNode node = this.addNode(target, Tools.removeExtension(list[i].getName()));
                    BufferedReader in = new BufferedReader(new FileReader(list[i]));
                    while (in.ready()) {
                        String line = in.readLine();
                        if (!line.startsWith("URL=")) continue;
                        node.setLink(line.substring(4));
                        continue block3;
                    }
                    continue;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
            }
        }
        if (redisplay) {
            this.controller.nodeChanged(target);
        }
        return favoritesFound;
    }

    private MindMapNode addNode(MindMapNode target, String nodeContent) {
        MindMapNode node = this.controller.addNewNode(target, target.getChildCount(), target.isNewChildLeft());
        this.controller.setNodeText(node, nodeContent);
        return node;
    }
}

