/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom.traversal;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.dom.traversal.NodeFilterImpl;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeFilter;
import org.mozilla.interfaces.nsIDOMNodeIterator;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMNodeIterator getInstance() {
        return this.getInstanceAsnsIDOMNodeIterator();
    }

    protected NodeIteratorImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public NodeIteratorImpl(nsIDOMNodeIterator mozInst) {
        this((nsISupports)mozInst);
    }

    public static NodeIteratorImpl getDOMInstance(nsIDOMNodeIterator mozInst) {
        NodeIteratorImpl node = (NodeIteratorImpl)instances.get(mozInst);
        return node == null ? new NodeIteratorImpl(mozInst) : node;
    }

    public nsIDOMNodeIterator getInstanceAsnsIDOMNodeIterator() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMNodeIterator)this.moz.queryInterface("{354b5f02-1dd2-11b2-b053-b8c2997022a0}");
    }

    public NodeFilter getFilter() {
        Callable<NodeFilter> c = new Callable<NodeFilter>(){

            @Override
            public NodeFilter call() {
                nsIDOMNodeFilter result = NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().getFilter();
                return new NodeFilterImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node nextNode() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().nextNode();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getRoot() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().getRoot();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node previousNode() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().previousNode();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void detach() {
        Runnable r = new Runnable(){

            public void run() {
                NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().detach();
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public boolean getExpandEntityReferences() {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().getExpandEntityReferences();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public int getWhatToShow() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                long result = NodeIteratorImpl.this.getInstanceAsnsIDOMNodeIterator().getWhatToShow();
                return (int)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

