/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BEncoder {
    public static final byte I;
    public static final byte R;
    public static final byte D;
    public static final byte L;
    public static final byte E;
    public static final byte TRUE;
    public static final byte FALSE;
    public static final byte COLON;
    private static final String ASCII = "ISO-8859-1";
    private final boolean fail;
    private final boolean bool;
    private final String encoding;
    private final OutputStream output;

    private BEncoder(OutputStream output, boolean fail, boolean bool, String encoding) {
        this.fail = fail;
        this.encoding = encoding;
        this.output = output;
        this.bool = bool;
    }

    public static BEncoder getEncoder(OutputStream out) {
        return new BEncoder(out, false, true, ASCII);
    }

    public static BEncoder getEncoder(OutputStream out, boolean fail, boolean bool, String encoding) {
        return new BEncoder(out, fail, bool, encoding);
    }

    public void encodeByteArray(byte[] b) throws IOException {
        String length = String.valueOf(b.length);
        this.output.write(length.getBytes(ASCII));
        this.output.write(COLON);
        this.output.write(b);
    }

    public void encodeInt(Number n) throws IOException {
        String numerals = String.valueOf(n.longValue());
        this.output.write(I);
        this.output.write(numerals.getBytes(ASCII));
        this.output.write(E);
    }

    public void encodeRational(Number n) throws IOException {
        String numerals = String.valueOf(Double.doubleToLongBits(n.doubleValue()));
        this.output.write(R);
        this.output.write(numerals.getBytes(ASCII));
        this.output.write(E);
    }

    public void encodeList(Iterable<?> iterable) throws IOException {
        this.output.write(L);
        for (Object next : iterable) {
            this.encode(next);
        }
        this.output.write(E);
    }

    public void encodeDict(Map<?, ?> map) throws IOException {
        TreeMap sorted = new TreeMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sorted.put(entry.getKey().toString(), entry.getValue());
        }
        this.output.write(D);
        for (Map.Entry<Object, Object> entry : sorted.entrySet()) {
            if (BEncoder.isValidType(entry.getKey()) && BEncoder.isValidType(entry.getValue())) {
                this.encodeByteArray(((String)entry.getKey()).getBytes(this.encoding));
                this.encode(entry.getValue());
                continue;
            }
            if (!this.fail) continue;
            throw new IllegalArgumentException();
        }
        this.output.write(E);
    }

    private void encode(Object object) throws IOException {
        if (object instanceof Map) {
            this.encodeDict((Map)object);
        } else if (object instanceof Iterable) {
            this.encodeList((Iterable)object);
        } else if (object instanceof Number) {
            if (object instanceof Double || object instanceof Float) {
                this.encodeRational((Number)object);
            } else {
                this.encodeInt((Number)object);
            }
        } else if (object instanceof String) {
            this.encodeByteArray(((String)object).getBytes(this.encoding));
        } else if (object instanceof byte[]) {
            this.encodeByteArray((byte[])object);
        } else if (object instanceof Boolean) {
            this.encodeBoolean((Boolean)object);
        } else if (this.fail) {
            throw new IllegalArgumentException();
        }
    }

    public void encodeBoolean(boolean value) throws IOException {
        if (this.bool) {
            this.output.write(value ? TRUE : FALSE);
        } else {
            this.encodeInt(value ? 1 : 0);
        }
    }

    private static boolean isValidType(Object o) {
        return o instanceof Map || o instanceof List || o instanceof Number || o instanceof String || o instanceof byte[] || o instanceof Boolean;
    }

    static {
        byte i = 0;
        byte d = 0;
        byte l = 0;
        byte e = 0;
        byte colon = 0;
        byte t = 0;
        byte f = 0;
        byte r = 0;
        try {
            i = "i".getBytes(ASCII)[0];
            d = "d".getBytes(ASCII)[0];
            l = "l".getBytes(ASCII)[0];
            e = "e".getBytes(ASCII)[0];
            colon = ":".getBytes(ASCII)[0];
            t = "t".getBytes(ASCII)[0];
            f = "f".getBytes(ASCII)[0];
            r = "r".getBytes(ASCII)[0];
        }
        catch (UnsupportedEncodingException impossible) {
            // empty catch block
        }
        COLON = colon;
        I = i;
        D = d;
        L = l;
        E = e;
        TRUE = t;
        FALSE = f;
        R = r;
    }
}

