/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.MagnetLinkFactory;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.action.BitziLookupAction;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.properties.FileInfoUtils;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.CopyMagnetLinkToClipboardAction;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

class FileInfoOverviewPanel
implements FileInfoPanel {
    @Resource
    private Color foreground;
    @Resource
    private Font smallFont;
    @Resource
    private Font headerFont;
    @Resource
    private Font headerFont2;
    private final FileInfoDialog.FileInfoType type;
    private PropertiableFile propertiableFile;
    private final MagnetLinkFactory magnetLinkFactory;
    private final CategoryIconManager categoryIconManager;
    private final LibraryManager libraryManager;
    private final RenameAction renameAction;
    private final JXPanel component;
    private JButton renameButton;
    private JTextField nameLabel;
    private JTextField renameTextField;

    public FileInfoOverviewPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile, Provider<IconManager> iconManager, MagnetLinkFactory magnetLinkFactory, CategoryIconManager categoryIconManager, LibraryManager libraryManager, BarPainterFactory barPainterFactory) {
        this.type = type;
        this.propertiableFile = propertiableFile;
        this.magnetLinkFactory = magnetLinkFactory;
        this.categoryIconManager = categoryIconManager;
        this.libraryManager = libraryManager;
        this.renameAction = new RenameAction();
        GuiUtils.assignResources(this);
        this.component = new JXPanel(new MigLayout("fill, gap 0, insets 10 10 16 14"));
        this.component.setBackgroundPainter(barPainterFactory.createPopUpBarPainter());
        this.init();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void save() {
        if (this.renameTextField != null && this.renameTextField.isVisible()) {
            this.saveFileName();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
        this.propertiableFile = file;
        this.nameLabel.setText(this.propertiableFile.getFileName());
    }

    public void enableRename() {
        this.renameAction.actionPerformed(null);
    }

    private void init() {
        this.component.setOpaque(false);
        this.addOverviewCategory();
        HyperlinkButton copyToClipboard = null;
        if (this.type == FileInfoDialog.FileInfoType.LOCAL_FILE) {
            if (this.propertiableFile instanceof LocalFileItem && ((LocalFileItem)this.propertiableFile).isShareable()) {
                copyToClipboard = new HyperlinkButton();
                copyToClipboard.setFont(this.smallFont);
                copyToClipboard.setAction(new AbstractAction(I18n.tr("Copy Magnet Link")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StringSelection sel = new StringSelection(FileInfoOverviewPanel.this.magnetLinkFactory.createMagnetLink((LocalFileItem)FileInfoOverviewPanel.this.propertiableFile));
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
                    }
                });
            }
        } else if (this.type == FileInfoDialog.FileInfoType.REMOTE_FILE && this.propertiableFile instanceof VisualSearchResult) {
            copyToClipboard = new HyperlinkButton();
            copyToClipboard.setFont(this.smallFont);
            copyToClipboard.setAction(new CopyMagnetLinkToClipboardAction((VisualSearchResult)this.propertiableFile));
        }
        HyperlinkButton moreFileInfo = new HyperlinkButton(new BitziLookupAction(this.propertiableFile));
        moreFileInfo.setFont(this.smallFont);
        if (this.type == FileInfoDialog.FileInfoType.LOCAL_FILE && this.propertiableFile instanceof LocalFileItem) {
            this.renameButton = new HyperlinkButton(this.renameAction);
            this.renameButton.setFont(this.smallFont);
            this.component.add((Component)this.renameButton, "cell 1 1, alignx right");
        }
        this.component.add((Component)moreFileInfo, "cell 1 2, alignx right");
        if (copyToClipboard != null) {
            this.component.add((Component)copyToClipboard, "cell 1 3, alignx right");
        }
    }

    private void addOverviewCategory() {
        Icon icon = this.getIcon(this.propertiableFile);
        JPanel iconDock = new JPanel();
        iconDock.setOpaque(false);
        iconDock.add(new JLabel(icon));
        String title = this.propertiableFile.getPropertyString(FilePropertyKey.TITLE);
        this.component.add((Component)iconDock, "split, aligny top, growy, gapafter 0");
        this.nameLabel = title != null ? this.createLabelField(title) : this.createLabelField(this.propertiableFile.getFileName());
        this.nameLabel.setFont(this.headerFont);
        this.nameLabel.setPreferredSize(new Dimension(440, 26));
        this.component.add((Component)this.nameLabel, "growx, span, wrap");
        if (title != null) {
            JTextField fileNameField = this.createLabelField(this.propertiableFile.getFileName());
            fileNameField.setFont(this.headerFont2);
            this.component.add((Component)fileNameField, "gapbefore 4, growx, wrap");
        }
        String info = "";
        if (!"".equals(FileInfoUtils.getFileSize(this.propertiableFile))) {
            info = FileInfoUtils.getFileSize(this.propertiableFile) + " (" + FileInfoUtils.getFileSizeBytes(this.propertiableFile) + ")";
        }
        switch (this.propertiableFile.getCategory()) {
            case AUDIO: {
                String time = FileInfoUtils.getLength(this.propertiableFile);
                String bitrate = this.propertiableFile.getPropertyString(FilePropertyKey.BITRATE);
                if (time != null) {
                    if (!"".equals(info)) {
                        info = info + ", ";
                    }
                    info = info + time;
                }
                if (bitrate == null) break;
                String quality = FileInfoUtils.getQuality(this.propertiableFile);
                if (!"".equals(info)) {
                    info = info + ", ";
                }
                info = quality != null ? info + bitrate + " kbps (" + quality + ")" : info + bitrate + " kbps";
            }
        }
        if (!"".equals(info)) {
            this.component.add((Component)this.createLabelField(info), "gapbefore 4, growx, wrap");
        }
    }

    private JTextField createLabelField(String text) {
        JTextField field = new JTextField(text);
        TextFieldClipboardControl.install(field);
        field.setCaretPosition(0);
        field.setEditable(false);
        field.setOpaque(false);
        field.setFont(this.smallFont);
        field.setForeground(this.foreground);
        field.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        return field;
    }

    private Icon getIcon(PropertiableFile propertiableFile) {
        switch (this.type) {
            case LOCAL_FILE: {
                return this.categoryIconManager.getIcon(propertiableFile);
            }
        }
        return this.categoryIconManager.getIcon(propertiableFile);
    }

    private void createRenameTextField() {
        this.renameTextField = new JTextField();
        this.renameTextField.setFont(this.headerFont);
        this.renameTextField.setForeground(this.foreground);
        this.renameTextField.setVisible(false);
        TextFieldClipboardControl.install(this.renameTextField);
        this.renameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    FileInfoOverviewPanel.this.enableRenameMode(false);
                }
            }
        });
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FileInfoOverviewPanel.this.enableRenameMode(false);
            }
        });
        this.component.add((Component)this.renameTextField, "hidemode 3, pos " + (this.nameLabel.getLocation().x - 3) + " " + (this.nameLabel.getLocation().y - 3));
        this.component.revalidate();
    }

    private void enableRenameMode(boolean enable) {
        if (enable) {
            this.setRenameText();
            this.setRenameEnabled(true);
            this.renameTextField.requestFocusInWindow();
            this.renameTextField.selectAll();
        } else {
            this.saveFileName();
            this.setRenameEnabled(false);
            this.component.repaint();
        }
    }

    private void setRenameText() {
        if (this.propertiableFile instanceof LocalFileItem) {
            int maxFileLength = this.getMaxFileSize(((LocalFileItem)this.propertiableFile).getFile());
            this.renameTextField.setDocument(new FileNameDocument(maxFileLength));
        }
        String fileName = FileUtils.getFilenameNoExtension(this.nameLabel.getText());
        this.renameTextField.setText(fileName);
        ResizeUtils.forceWidth(this.renameTextField, this.nameLabel.getWidth());
    }

    private void setRenameEnabled(boolean isRenaming) {
        this.renameTextField.setVisible(isRenaming);
        this.nameLabel.setVisible(!isRenaming);
        this.renameButton.setEnabled(!isRenaming);
    }

    private void saveFileName() {
        String newFileName = this.renameTextField.getText().trim();
        LocalFileItem oldFileItem = (LocalFileItem)this.propertiableFile;
        if (!this.isValidFileName(newFileName)) {
            this.renameTextField.setText(oldFileItem.getName());
            return;
        }
        if (newFileName.equals(oldFileItem.getName())) {
            return;
        }
        File oldFile = oldFileItem.getFile();
        newFileName = newFileName + "." + FileUtils.getFileExtension(oldFile);
        File newFile = new File(oldFile.getParentFile(), newFileName);
        if (FileUtils.forceRename(oldFile, newFile)) {
            this.updateFileNameInLibrary(oldFile, newFile);
        } else {
            newFile.delete();
            this.renameTextField.setText(oldFileItem.getName());
        }
    }

    private void updateFileNameInLibrary(File oldFile, File newFile) {
        this.libraryManager.getLibraryManagedList().fileRenamed(oldFile, newFile);
    }

    private boolean isValidFileName(String fileName) {
        return fileName != null && fileName.length() > 0 && CommonUtils.santizeString(fileName).equals(fileName);
    }

    private int getMaxFileSize(File file) {
        String fileName = FileUtils.getFilenameNoExtension(file.getName());
        return OSUtils.getMaxPathLength() - file.getAbsolutePath().length() + fileName.length();
    }

    private class FileNameDocument
    extends PlainDocument {
        private int maxLength = Integer.MAX_VALUE;

        public FileNameDocument(int length) {
            this.maxLength = length;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            String santize = CommonUtils.santizeString(str);
            if (santize.equals(str) && this.getLength() + str.length() <= this.maxLength) {
                super.insertString(offset, str, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private class RenameAction
    extends AbstractAction {
        public RenameAction() {
            super(I18n.tr("Rename File"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileInfoOverviewPanel.this.renameTextField == null) {
                FileInfoOverviewPanel.this.createRenameTextField();
            }
            FileInfoOverviewPanel.this.enableRenameMode(true);
        }
    }
}

