/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.home;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXPanel;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.concurrent.FutureEvent;
import org.limewire.core.api.Application;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.browser.Browser;
import org.limewire.ui.swing.browser.BrowserUtils;
import org.limewire.ui.swing.browser.UriAction;
import org.limewire.ui.swing.components.HTMLPane;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.SwingUtils;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.MozillaPanel;

@LazySingleton
public class HomePanel
extends JXPanel {
    private static final String DEFAULT_URL = "http://client-data.limewire.com/client_startup/home/";
    private final Application application;
    private final Browser browser;
    private final HTMLPane fallbackBrowser;
    private final GnutellaConnectionManager gnutellaConnectionManager;
    private boolean loadedOnce = false;
    private int retryCount = 0;
    private boolean firstRequest = true;
    private long initialLoadTime = -1L;
    private boolean isProLoadState = false;

    @Inject
    public HomePanel(Application application, final Navigator navigator, GnutellaConnectionManager gnutellaConnectionManager) {
        this.application = application;
        this.gnutellaConnectionManager = gnutellaConnectionManager;
        this.setPreferredSize(new Dimension(500, 500));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        if (MozillaInitialization.isInitialized()) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    HomePanel.this.browser.load("about:blank");
                }
            });
            BrowserUtils.addTargetedUrlAction("_lwHome", new UriAction(){

                @Override
                public boolean uriClicked(final UriAction.TargetedUri targetedUrl) {
                    SwingUtils.invokeNowOrLater(new Runnable(){

                        @Override
                        public void run() {
                            navigator.getNavItem(NavCategory.LIMEWIRE, "Home").select();
                            HomePanel.this.load(targetedUrl.getUri());
                        }
                    });
                    return true;
                }
            });
            this.browser = new Browser(MozillaPanel.VisibilityMode.FORCED_HIDDEN, MozillaPanel.VisibilityMode.FORCED_HIDDEN, MozillaPanel.VisibilityMode.DEFAULT){

                @Override
                public void pageLoadStopped(final boolean failed) {
                    super.pageLoadStopped(failed);
                    SwingUtils.invokeNowOrLater(new Runnable(){

                        @Override
                        public void run() {
                            HomePanel.this.pageLoadFinished(!failed);
                        }
                    });
                }
            };
            this.fallbackBrowser = null;
            this.add((Component)this.browser, gbc);
        } else {
            this.browser = null;
            this.fallbackBrowser = new HTMLPane();
            this.fallbackBrowser.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        NativeLaunchUtils.openURL(e.getURL().toExternalForm());
                    }
                }
            });
            JScrollPane scroller = new JScrollPane(this.fallbackBrowser, 20, 30);
            scroller.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)scroller, gbc);
        }
    }

    @Inject
    void register(final ActivationManager activationManager) {
        this.isProLoadState = activationManager.isProActive();
        this.gnutellaConnectionManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("strength".equals(evt.getPropertyName())) {
                    HomePanel.this.reloadDefaultUrlIfPossibleAndNeeded();
                }
            }
        });
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            public void handleEvent(ActivationModuleEvent event) {
                HomePanel.this.handleProStateChange(activationManager.isProActive());
            }
        });
    }

    private void handleProStateChange(final boolean currentState) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HomePanel.this.isVisible() && currentState != HomePanel.this.isProLoadState) {
                    HomePanel.this.isProLoadState = currentState;
                    HomePanel.this.loadDefaultUrl();
                }
            }
        });
    }

    private boolean isRequestInProgress() {
        if (MozillaInitialization.isInitialized()) {
            return this.browser.isRequestInProgress();
        }
        return this.fallbackBrowser.isRequestInProgress();
    }

    private void pageLoadFinished(boolean success) {
        if (!success) {
            this.reloadDefaultUrlIfPossibleAndNeeded();
        }
    }

    private void reloadDefaultUrlIfPossibleAndNeeded() {
        if (this.isShowing() && this.firstRequest && !this.isRequestInProgress() && this.retryCount < 5 && this.loadedOnce && !this.isLastRequestSuccessful() && this.gnutellaConnectionManager.getConnectionStrength().isOnline()) {
            ++this.retryCount;
            long delay = System.currentTimeMillis() - this.initialLoadTime;
            this.load("http://client-data.limewire.com/client_startup/home/?rd=" + delay + "&rc=" + this.retryCount);
        }
    }

    private boolean isLastRequestSuccessful() {
        if (MozillaInitialization.isInitialized()) {
            return this.browser.isLastRequestSuccessful();
        }
        return this.fallbackBrowser.isLastRequestSuccessful();
    }

    public void loadDefaultUrl() {
        this.load(DEFAULT_URL);
    }

    public void load(String url) {
        this.loadedOnce = true;
        url = this.application.addClientInfoToUrl(url);
        if (this.firstRequest) {
            if (this.isLastRequestSuccessful()) {
                this.firstRequest = false;
            } else {
                url = url + "&firstRequest=true";
                if (this.initialLoadTime == -1L) {
                    this.initialLoadTime = System.currentTimeMillis();
                }
            }
        }
        if (MozillaInitialization.isInitialized()) {
            this.browser.load(url);
        } else {
            url = url + "&html32=true";
            URL bgImage = HomePanel.class.getResource("/org/limewire/ui/swing/mainframe/resources/icons/static_pages/body_bg.png");
            URL topImage = HomePanel.class.getResource("/org/limewire/ui/swing/mainframe/resources/icons/static_pages/header_logo.png");
            String offlinePage = "<html><head><style type=\"text/css\">* {margin: 0;  padding: 0;} body {background: #EAEAEA url(\"" + bgImage.toExternalForm() + "\") repeat-x left top; font-family: Arial, sans-serif;}table#layout tr td#header {  background: url(\"" + topImage.toExternalForm() + "\") no-repeat center top;}table#layout tr td h2 {  font-size: 16px;  margin: 0 0 8px 0;  color: #807E7E;}table#layout tr td p {  font-size: 11px;  color: #931F22;}</style></head><body><center>  <table id=\"layout\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"400\" style=\"margin: 46px 0 0 0\">    <tr valign=\"top\">      <td id=\"header\" height=\"127\" align=\"center\"></td>    </tr>    <tr valign=\"top\">      <td align=\"center\">        <h2>You are offline</h2>        <p>Please check your internet connection.</p>      </td>    </tr>  </table></center></body></html>";
            this.fallbackBrowser.setPageAsynchronous(url, offlinePage).addFutureListener(new EventListener<FutureEvent<HTMLPane.LoadResult>>(){

                @Override
                @SwingEDTEvent
                public void handleEvent(FutureEvent<HTMLPane.LoadResult> event) {
                    HomePanel.this.pageLoadFinished(event.getResult() == HTMLPane.LoadResult.SERVER_PAGE);
                }
            });
        }
    }

    public void loadBlank() {
        if (MozillaInitialization.isInitialized()) {
            this.browser.load("about:blank");
        }
    }
}

