/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import org.limewire.rudp.messages.FinMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

class FinMessageImpl
extends RUDPMessageImpl
implements FinMessage {
    private byte _reasonCode;

    FinMessageImpl(byte connectionID, long sequenceNumber, byte reasonCode) {
        super(connectionID, RUDPMessage.OpCode.OP_FIN, sequenceNumber, reasonCode);
        this._reasonCode = reasonCode;
    }

    FinMessageImpl(byte connectionId, long sequenceNumber, ByteBuffer data1, ByteBuffer data2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_FIN, connectionId, sequenceNumber, data1, data2);
        if (data1.remaining() < 1) {
            throw new MessageFormatException("Message not long enough, message length " + data1.remaining() + " < 1");
        }
        this._reasonCode = data1.get();
        data1.rewind();
    }

    public String toString() {
        return "FinMessage DestID:" + this.getConnectionID() + " reasonCode:" + this._reasonCode;
    }
}

