/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.util.BufferUtils;

public class IOStateMachine
implements ChannelReadObserver,
ChannelWriter,
InterestScatteringByteChannel {
    private static final Log LOG = LogFactory.getLog(IOStateMachine.class);
    private IOStateObserver observer;
    private List<IOState> states;
    private IOState currentState;
    private volatile InterestWritableByteChannel writeSink;
    private volatile InterestReadableByteChannel readSink;
    private ByteBuffer readBuffer;
    private volatile boolean shutdown;

    public IOStateMachine(IOStateObserver observer, List<IOState> states) {
        this(observer, states, 2048);
    }

    public IOStateMachine(IOStateObserver observer, List<IOState> states, int bufferSize) {
        this.observer = observer;
        this.states = states;
        this.readBuffer = NIODispatcher.instance().getBufferCache().getHeap(bufferSize);
        if (!states.isEmpty()) {
            this.currentState = states.remove(0);
        }
    }

    public void addState(final IOState newState) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding single state: " + newState);
                }
                IOStateMachine.this.states.add(newState);
                if (IOStateMachine.this.states.size() == 1) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final List<? extends IOState> newStates) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding multiple states: " + newStates);
                }
                IOStateMachine.this.states.addAll(newStates);
                if (IOStateMachine.this.states.size() == newStates.size()) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    public void addStates(final IOState ... newStates) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding multiple states...");
                }
                for (int i = 0; i < newStates.length; ++i) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" state[" + i + "]: " + newStates[i]);
                    }
                    IOStateMachine.this.states.add(newStates[i]);
                }
                if (IOStateMachine.this.states.size() == newStates.length) {
                    IOStateMachine.this.nextState(false, false);
                }
            }
        });
    }

    @Override
    public void handleRead() {
        if (this.currentState != null) {
            if (this.currentState.isWriting()) {
                LOG.warn("Got a read notification while writing.");
                this.processCurrentState(null, true);
                this.readSink.interestRead(false);
            } else {
                this.processCurrentState(this.currentState, true);
            }
        } else {
            LOG.warn("Got a read notification with no current state");
            this.processCurrentState(null, true);
            this.readSink.interestRead(false);
        }
    }

    @Override
    public boolean handleWrite() {
        if (this.currentState != null) {
            if (this.currentState.isReading()) {
                LOG.warn("Got a write notification while reading");
                this.writeSink.interestWrite(this, false);
                return false;
            }
            return this.processCurrentState(this.currentState, false);
        }
        LOG.warn("Got a write notification with no current state");
        this.writeSink.interestWrite(this, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCurrentState(IOState state, boolean reading) {
        block19: {
            if (!this.shutdown) {
                try {
                    if (reading) {
                        if (state == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Processing a read with no state");
                            }
                            int read = 0;
                            while (this.readBuffer.hasRemaining() && (read = this.readSink.read(this.readBuffer)) > 0) {
                            }
                            if (this.readBuffer.position() == 0 && read == -1) {
                                throw new ClosedChannelException();
                            }
                        } else if (!state.process(this.readSink, this.readBuffer)) {
                            this.nextState(true, false);
                        }
                        break block19;
                    }
                    if (!state.process(this.writeSink, null)) {
                        this.nextState(false, true);
                        break block19;
                    }
                    return true;
                }
                catch (IOException iox) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("IOX while processing state: " + state, iox);
                    }
                    IOStateMachine iOStateMachine = this;
                    synchronized (iOStateMachine) {
                        this.shutdown = true;
                    }
                    try {
                        this.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    NIODispatcher.instance().getBufferCache().release(this.readBuffer);
                    this.observer.handleIOException(iox);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring processing because machine is shutdown");
            }
        }
        return false;
    }

    private void nextState(boolean reading, boolean writing) {
        if (this.states.isEmpty()) {
            LOG.debug("No more states, processing finished.");
            this.readSink.interestRead(false);
            this.writeSink.interestWrite(this, false);
            this.observer.handleStatesFinished();
        } else {
            this.currentState = this.states.remove(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incrementing state to: " + this.currentState);
            }
            if (this.currentState.isReading() && !reading) {
                this.writeSink.interestWrite(this, false);
                if (this.readSink != null) {
                    this.readSink.interestRead(true);
                }
            }
            if (this.currentState.isWriting() && !writing) {
                this.readSink.interestRead(false);
                if (this.writeSink != null) {
                    this.writeSink.interestWrite(this, true);
                }
            }
            if (this.currentState.isReading()) {
                this.processCurrentState(this.currentState, true);
            }
        }
    }

    @Override
    public InterestWritableByteChannel getWriteChannel() {
        return this.writeSink;
    }

    @Override
    public void setWriteChannel(InterestWritableByteChannel newChannel) {
        this.writeSink = newChannel;
        if (this.currentState != null) {
            this.writeSink.interestWrite(this, true);
        }
    }

    @Override
    public InterestReadableByteChannel getReadChannel() {
        return this.readSink;
    }

    @Override
    public void setReadChannel(InterestReadableByteChannel newChannel) {
        this.readSink = newChannel;
        if (this.currentState != null) {
            this.readSink.interestRead(true);
        }
    }

    @Override
    public boolean isOpen() {
        return this.readSink != null && this.readSink.isOpen() && this.writeSink != null && this.writeSink.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.readSink != null) {
            this.readSink.close();
        }
        if (this.writeSink != null) {
            this.writeSink.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        IOStateMachine iOStateMachine = this;
        synchronized (iOStateMachine) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (!this.isOpen()) {
            this.observer.shutdown();
        }
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                NIODispatcher.instance().getBufferCache().release(IOStateMachine.this.readBuffer);
            }
        });
    }

    @Override
    public void interestRead(boolean status) {
        if (this.currentState != null) {
            this.readSink.interestRead(status);
        }
    }

    @Override
    public int read(ByteBuffer toBuffer) throws ClosedChannelException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        return BufferUtils.transfer(this.readBuffer, toBuffer);
    }

    @Override
    public long read(ByteBuffer[] toBuffer) throws ClosedChannelException {
        return this.read(toBuffer, 0, toBuffer.length);
    }

    @Override
    public long read(ByteBuffer[] toBuffer, int offset, int num) throws ClosedChannelException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        return BufferUtils.transfer(this.readBuffer, toBuffer, 0, toBuffer.length, true);
    }

    @Override
    public void handleIOException(IOException iox) {
    }
}

