/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.limegroup.gnutella.library.SharedFileCollection;
import java.util.Collection;
import java.util.List;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.impl.library.CoreLocalFileItemFactory;
import org.limewire.core.impl.library.LocalFileListImpl;
import org.limewire.util.StringUtils;

class SharedFileListImpl
extends LocalFileListImpl
implements SharedFileList {
    private final SharedFileCollection coreCollection;
    private final EventList<String> friendList = GlazedListsFactory.threadSafeList(new BasicEventList());
    private final EventList<String> readOnlyFriendList = GlazedListsFactory.readOnlyList(this.friendList);

    public SharedFileListImpl(CoreLocalFileItemFactory coreLocalFileItemFactory, SharedFileCollection coreFileCollection) {
        super(new BasicEventList<LocalFileItem>(), coreLocalFileItemFactory);
        this.coreCollection = coreFileCollection;
        this.coreCollection.addListener(this.newEventListener());
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    @Override
    public int getId() {
        return this.coreCollection.getId();
    }

    @Override
    protected SharedFileCollection getCoreCollection() {
        return this.coreCollection;
    }

    @Override
    public void addFriend(String friendId) {
        this.coreCollection.addFriend(friendId);
    }

    @Override
    public EventList<String> getFriendIds() {
        return this.readOnlyFriendList;
    }

    @Override
    public String getCollectionName() {
        if (this.coreCollection.getId() == 0) {
            return "Public Shared";
        }
        return this.coreCollection.getName();
    }

    @Override
    public boolean isNameChangeAllowed() {
        return this.coreCollection.getId() != 0;
    }

    @Override
    public void removeFriend(String friendId) {
        this.coreCollection.removeFriend(friendId);
    }

    @Override
    public void setFriendList(List<String> friendIdList) {
        this.coreCollection.setFriendList(friendIdList);
    }

    @Override
    public void setCollectionName(String name) {
        this.coreCollection.setName(name);
    }

    boolean friendRemoved(String friendId) {
        return this.friendList.remove(friendId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void friendsSet(Collection<String> newFriendIds) {
        this.friendList.getReadWriteLock().writeLock().lock();
        try {
            this.friendList.clear();
            this.friendList.addAll(newFriendIds);
        }
        finally {
            this.friendList.getReadWriteLock().writeLock().unlock();
        }
    }

    void friendAdded(String friendId) {
        this.friendList.add(friendId);
    }

    @Override
    public boolean isPublic() {
        return this.coreCollection.isPublic();
    }
}

