/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.limegroup.gnutella.security.CertificateProvider;
import com.limegroup.gnutella.security.CertificateProviderImpl;
import com.limegroup.gnutella.security.CertificateVerifier;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import com.limegroup.gnutella.security.CertifiedMessageVerifierImpl;
import com.limegroup.gnutella.security.DefaultSignedMessageDataProvider;
import com.limegroup.gnutella.security.FileCertificateReader;
import com.limegroup.gnutella.security.HttpCertificateReader;
import com.limegroup.gnutella.simpp.Simpp;
import com.limegroup.gnutella.simpp.SimppDataProviderImpl;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppDataVerifierImpl;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.simpp.SimppManagerImpl;
import com.limegroup.gnutella.simpp.SimppSender;
import java.io.File;
import java.net.URI;
import org.limewire.inject.LazySingleton;
import org.limewire.util.CommonUtils;

public class LimeWireSimppModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(SimppManager.class).to(SimppManagerImpl.class);
        this.bind(DefaultSignedMessageDataProvider.class).annotatedWith(Simpp.class).to(SimppDataProviderImpl.class);
        this.bind(SimppSender.class);
        this.bind(SimppDataVerifier.class).to(SimppDataVerifierImpl.class);
    }

    @Provides
    @LazySingleton
    @Simpp
    CertificateProvider simppCertificateProvider(FileCertificateReader fileCertificateReader, HttpCertificateReader httpCertificateReader, CertificateVerifier certificateVerifier) {
        return new CertificateProviderImpl(fileCertificateReader, httpCertificateReader, certificateVerifier, new File(CommonUtils.getUserSettingsDir(), "simpp.cert"), URI.create("http://certs.limewire.com/simpp/simpp.cert"));
    }

    @Provides
    @Simpp
    CertifiedMessageVerifier simppMessageVerifier(@Simpp CertificateProvider certificateProvider, CertificateVerifier certificateVerifier) {
        return new CertifiedMessageVerifierImpl(certificateProvider, certificateVerifier);
    }
}

