/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.util.LimeWireUtils;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.core.settings.InstallSettings;
import org.limewire.io.GUID;
import org.limewire.util.StringUtils;

@Singleton
public class ApplicationServicesImpl
implements ApplicationServices {
    private final byte[] bittorrentGUID;
    private final byte[] limewireGUID;
    private final boolean newInstall;
    private final boolean newJavaVersion;

    @Inject
    ApplicationServicesImpl() {
        byte[] myguid = null;
        try {
            myguid = GUID.fromHexString(ApplicationSettings.CLIENT_ID.get());
        }
        catch (IllegalArgumentException iae) {
            myguid = GUID.makeGuid();
            ApplicationSettings.CLIENT_ID.set(new GUID(myguid).toHexString());
        }
        this.limewireGUID = myguid;
        byte[] mybtguid = new byte[20];
        mybtguid[0] = 45;
        mybtguid[1] = 76;
        mybtguid[2] = 87;
        System.arraycopy(StringUtils.toAsciiBytes("0002"), 0, mybtguid, 3, 4);
        mybtguid[7] = 45;
        System.arraycopy(this.limewireGUID, 0, mybtguid, 8, 12);
        this.bittorrentGUID = mybtguid;
        String lastRunVersion = ApplicationServicesImpl.getVersionNoProModifier(InstallSettings.LAST_VERSION_RUN.get());
        String limewireVersion = ApplicationServicesImpl.getVersionNoProModifier(LimeWireUtils.getLimeWireVersion());
        this.newInstall = lastRunVersion == null || !lastRunVersion.equals(limewireVersion);
        String lastJavaVersion = InstallSettings.LAST_JAVA_VERSION_RUN.get();
        String currentJavaVersion = System.getProperty("java.version");
        this.newJavaVersion = lastJavaVersion == null || !lastJavaVersion.equals(currentJavaVersion);
        InstallSettings.LAST_JAVA_VERSION_RUN.set(currentJavaVersion);
    }

    private static String getVersionNoProModifier(String fullVersion) {
        String fullVersionNoModifiers = null;
        if (fullVersion != null) {
            fullVersionNoModifiers = fullVersion.endsWith("Pro") ? fullVersion.substring(0, fullVersion.length() - 4) : fullVersion;
        }
        return fullVersionNoModifiers;
    }

    @Override
    public byte[] getMyBTGUID() {
        return this.bittorrentGUID;
    }

    @Override
    public byte[] getMyGUID() {
        return this.limewireGUID;
    }

    @Override
    public void setFullPower(boolean newValue) {
    }

    @Override
    public boolean isNewInstall() {
        return this.newInstall;
    }

    @Override
    public boolean isNewJavaVersion() {
        return this.newJavaVersion;
    }
}

