/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.templates.web.browse.TPopular;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TPopularImpl
extends AbstractTemplateImpl
implements TPopular.Intf {
    private final User user;
    private final Vector<Track> tracks;
    private final Vector<User> recentUsers;
    private final Properties properties;
    private final Locale locale;

    protected static TPopular.ImplData __jamon_setOptionalArguments(TPopular.ImplData p_implData) {
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getTracks__IsNotDefault()) {
            p_implData.setTracks(null);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        return p_implData;
    }

    public TPopularImpl(TemplateManager p_templateManager, TPopular.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TPopularImpl.__jamon_setOptionalArguments(p_implData));
        this.user = p_implData.getUser();
        this.tracks = p_implData.getTracks();
        this.recentUsers = p_implData.getRecentUsers();
        this.properties = p_implData.getProperties();
        this.locale = p_implData.getLocale();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_44 = new IHeader(this.getTemplateManager());
        __jamon__var_44.setProperties(this.properties);
        __jamon__var_44.setTitle("Most Popular Tracks");
        __jamon__var_44.setLocale(this.locale);
        __jamon__var_44.setUser(this.user);
        __jamon__var_44.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<h2>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.mostPopularTracks")), jamonWriter);
        jamonWriter.write("</h2>\n\n<ul class=\"musiclist\">\n");
        if (this.tracks.size() > 0) {
            jamonWriter.write("\n    ");
            for (Track track : this.tracks) {
                jamonWriter.write("\n        <li class=\"track\">\n            ");
                IMusicLinks __jamon__var_45 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_45.setProperties(this.properties);
                __jamon__var_45.setLocale(this.locale);
                __jamon__var_45.setId(track.getId());
                __jamon__var_45.setName(track.getName());
                __jamon__var_45.setType("tr");
                __jamon__var_45.renderNoFlush(jamonWriter);
                jamonWriter.write("\n            <span class=\"link\">\n                <a href=\"/browse/artist/");
                Escaping.HTML.write(StandardEmitter.valueOf((int)track.getArtist().getId()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getArtist().getName())), jamonWriter);
                jamonWriter.write("</a> -\n                ");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getName())), jamonWriter);
                jamonWriter.write("\n            </span>\n            <span class=\"info\">\n                (");
                Escaping.HTML.write(StandardEmitter.valueOf((int)track.getPlayCount()), jamonWriter);
                jamonWriter.write(" play");
                if (track.getPlayCount() != 1) {
                    jamonWriter.write("s");
                }
                jamonWriter.write(")\n            </span>\n        </li>\n    ");
            }
            jamonWriter.write("\n");
        } else {
            jamonWriter.write("\n    <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n");
        }
        jamonWriter.write("\n</ul>\n\n");
        IFooter __jamon__var_46 = new IFooter(this.getTemplateManager());
        __jamon__var_46.setLocale(this.locale);
        __jamon__var_46.setProperties(this.properties);
        __jamon__var_46.setRecentUsers(this.recentUsers);
        __jamon__var_46.setUser(this.user);
        __jamon__var_46.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

