/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.templates.web.browse.TLatest;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TLatestImpl
extends AbstractTemplateImpl
implements TLatest.Intf {
    private final Locale locale;
    private final Vector<Artist> artists;
    private final User user;
    private final Vector<Album> albums;
    private final Vector<User> recentUsers;
    private final Vector<Track> tracks;
    private final Properties properties;

    protected static TLatest.ImplData __jamon_setOptionalArguments(TLatest.ImplData p_implData) {
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        if (!p_implData.getArtists__IsNotDefault()) {
            p_implData.setArtists(null);
        }
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getAlbums__IsNotDefault()) {
            p_implData.setAlbums(null);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getTracks__IsNotDefault()) {
            p_implData.setTracks(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        return p_implData;
    }

    public TLatestImpl(TemplateManager p_templateManager, TLatest.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TLatestImpl.__jamon_setOptionalArguments(p_implData));
        this.locale = p_implData.getLocale();
        this.artists = p_implData.getArtists();
        this.user = p_implData.getUser();
        this.albums = p_implData.getAlbums();
        this.recentUsers = p_implData.getRecentUsers();
        this.tracks = p_implData.getTracks();
        this.properties = p_implData.getProperties();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_31 = new IHeader(this.getTemplateManager());
        __jamon__var_31.setProperties(this.properties);
        __jamon__var_31.setTitle("Latest Music");
        __jamon__var_31.setLocale(this.locale);
        __jamon__var_31.setUser(this.user);
        __jamon__var_31.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<h2>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.latestTracks")), jamonWriter);
        jamonWriter.write("</h2>\n\n<ul class=\"musiclist\">\n");
        if (this.tracks.size() > 0) {
            jamonWriter.write("\n    ");
            for (Track track : this.tracks) {
                jamonWriter.write("\n        <li class=\"track\">\n            ");
                IMusicLinks __jamon__var_32 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_32.setProperties(this.properties);
                __jamon__var_32.setLocale(this.locale);
                __jamon__var_32.setId(track.getId());
                __jamon__var_32.setName(track.getName());
                __jamon__var_32.setType("tr");
                __jamon__var_32.renderNoFlush(jamonWriter);
                jamonWriter.write("\n            <span class=\"link\">\n                <a href=\"/browse/artist/");
                Escaping.HTML.write(StandardEmitter.valueOf((int)track.getArtist().getId()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getArtist().getName())), jamonWriter);
                jamonWriter.write("</a>\n                - ");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getName())), jamonWriter);
                jamonWriter.write("\n            </span>\n        </li>\n    ");
            }
            jamonWriter.write("\n");
        } else {
            jamonWriter.write("\n    <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n");
        }
        jamonWriter.write("\n</ul>\n\n");
        if (this.artists.size() > 0) {
            jamonWriter.write("\n<div class=\"albumArt\">\n\n    <h2>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.latestArtists")), jamonWriter);
            jamonWriter.write("</h2>\n\n    <ul>\n        ");
            for (Artist artist : this.artists) {
                jamonWriter.write("\n            <li>\n                <a href=\"/browse/artist/");
                Escaping.HTML.write(StandardEmitter.valueOf((int)artist.getId()), jamonWriter);
                jamonWriter.write("\" title=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(artist.getName())), jamonWriter);
                jamonWriter.write("\"><img class=\"cover\" src=\"/file/cover/ar");
                Escaping.HTML.write(StandardEmitter.valueOf((int)artist.getId()), jamonWriter);
                jamonWriter.write("\" /></a>\n                <div class=\"links\">\n                    ");
                IMusicLinks __jamon__var_33 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_33.setProperties(this.properties);
                __jamon__var_33.setLocale(this.locale);
                __jamon__var_33.setId(artist.getId());
                __jamon__var_33.setName(artist.getName());
                __jamon__var_33.setType("ar");
                __jamon__var_33.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                </div>\n            </li>\n        ");
            }
            jamonWriter.write("\n    </ul>\n\n</div>\n");
        }
        jamonWriter.write("\n\n<div class=\"clearer\"></div>\n\n");
        if (this.albums.size() > 0) {
            jamonWriter.write("\n<div class=\"albumArt\">\n\n    <h2>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.latestAlbums")), jamonWriter);
            jamonWriter.write("</h2>\n\n    <ul>\n        ");
            for (Album album : this.albums) {
                jamonWriter.write("\n            <li>\n                <a href=\"/browse/album/");
                Escaping.HTML.write(StandardEmitter.valueOf((int)album.getId()), jamonWriter);
                jamonWriter.write("\" title=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(album.getName())), jamonWriter);
                jamonWriter.write("\"><img class=\"cover\" src=\"/file/cover/al");
                Escaping.HTML.write(StandardEmitter.valueOf((int)album.getId()), jamonWriter);
                jamonWriter.write("\" /></a>\n                <div class=\"links\">\n                    ");
                IMusicLinks __jamon__var_34 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_34.setProperties(this.properties);
                __jamon__var_34.setLocale(this.locale);
                __jamon__var_34.setId(album.getId());
                __jamon__var_34.setName(album.getName());
                __jamon__var_34.setType("al");
                __jamon__var_34.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                </div>\n            </li>\n        ");
            }
            jamonWriter.write("\n    </ul>\n\n</div>\n");
        }
        jamonWriter.write("\n\n");
        IFooter __jamon__var_35 = new IFooter(this.getTemplateManager());
        __jamon__var_35.setLocale(this.locale);
        __jamon__var_35.setProperties(this.properties);
        __jamon__var_35.setRecentUsers(this.recentUsers);
        __jamon__var_35.setUser(this.user);
        __jamon__var_35.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

