/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates;

import com.pugh.sockso.Properties;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.TRSSLatest;
import com.pugh.sockso.web.Server;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TRSSLatestImpl
extends AbstractTemplateImpl
implements TRSSLatest.Intf {
    private final Vector<Track> tracks;
    private final Properties properties;
    private final Server server;

    protected static TRSSLatest.ImplData __jamon_setOptionalArguments(TRSSLatest.ImplData p_implData) {
        if (!p_implData.getTracks__IsNotDefault()) {
            p_implData.setTracks(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getServer__IsNotDefault()) {
            p_implData.setServer(null);
        }
        return p_implData;
    }

    public TRSSLatestImpl(TemplateManager p_templateManager, TRSSLatest.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TRSSLatestImpl.__jamon_setOptionalArguments(p_implData));
        this.tracks = p_implData.getTracks();
        this.properties = p_implData.getProperties();
        this.server = p_implData.getServer();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        String title = this.properties.get("www.title");
        String host = "http://" + this.server.getHost();
        jamonWriter.write("<rss version=\"2.0\">\n    <channel>\n        <title>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)this.tracks.size()), jamonWriter);
        jamonWriter.write(" latest tracks from ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)title), jamonWriter);
        jamonWriter.write("</title>\n        <link>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)host), jamonWriter);
        jamonWriter.write("/rss/latest</link>\n        <description>This feed lists the latest tracks that have been added to the sockso\n            music collection '");
        Escaping.HTML.write(StandardEmitter.valueOf((String)title), jamonWriter);
        jamonWriter.write("'</description>\n    </channel>\n    ");
        for (Track track : this.tracks) {
            jamonWriter.write("\n    <item>\n        ");
            String desc = track.getArtist().getName() + " - " + track.getName();
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            jamonWriter.write("<title>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)desc), jamonWriter);
            jamonWriter.write("</title>\n        <link>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)host), jamonWriter);
            jamonWriter.write("/m3u/tr");
            Escaping.HTML.write(StandardEmitter.valueOf((int)track.getId()), jamonWriter);
            jamonWriter.write("</link>\n        <pubDate>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)formatter.format(track.getDateAdded())), jamonWriter);
            jamonWriter.write("</pubDate>\n        <description><![CDATA[ ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)desc), jamonWriter);
            jamonWriter.write(" ]]></description>\n    </item>\n    ");
        }
        jamonWriter.write("\n</rss>");
    }
}

