/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.playlist;

import com.pugh.sockso.Utils;
import com.pugh.sockso.music.playlist.PlaylistFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class M3uFile
extends PlaylistFile {
    private static final Logger log = Logger.getLogger(M3uFile.class);
    private final ArrayList<String> paths;
    private final File file;

    public M3uFile(File file) {
        this.file = file;
        this.paths = new ArrayList();
    }

    public void load() throws IOException {
        String[] lines = this.getLines(this.file);
        if (lines.length > 0) {
            if (lines[0].equals("#EXTM3U")) {
                this.loadExtendedM3u(lines);
            } else {
                this.loadStandardM3u(lines);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getLines(File file) throws IOException {
        BufferedReader in = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = null;
            while ((line = in.readLine()) != null) {
                log.debug((Object)("Read line: " + line));
                lines.add(line);
            }
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        Utils.close(in);
        return lines.toArray(new String[0]);
    }

    private void loadExtendedM3u(String[] lines) {
        log.debug((Object)"Reading Extended M3u File");
        for (String line : lines) {
            if (line.matches("^#EXT.*") || line.equals("")) continue;
            log.debug((Object)("Adding path: " + line));
            this.paths.add(line);
        }
    }

    private void loadStandardM3u(String[] lines) {
        log.debug((Object)"Reading Standard M3u File");
        for (String line : lines) {
            if (line.equals("")) continue;
            log.debug((Object)("Adding path: " + line));
            this.paths.add(line);
        }
    }

    public String[] getPaths() {
        return this.paths.toArray(new String[0]);
    }
}

