/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.ImageUtilities;

class ErrorLabel
extends JLabel {
    public static final String PROP_IS_VALID = "isValid";
    private Document document;
    private Validator validator;
    private boolean isValid = true;

    public ErrorLabel(Document document, Validator validator) {
        this.setText(null);
        this.setIcon(null);
        assert (null != document);
        assert (null != validator);
        this.document = document;
        this.validator = validator;
        this.revalidateText();
        document.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ErrorLabel.this.revalidateText();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ErrorLabel.this.revalidateText();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ErrorLabel.this.revalidateText();
            }
        });
    }

    public boolean isInputTextValid() {
        return this.isValid;
    }

    protected void revalidateText() {
        boolean bl = this.isValid;
        String string = null;
        try {
            string = this.validator.validate(this.document.getText(0, this.document.getLength()));
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.isValid = string == null;
        this.setText(string);
        this.setIcon(null == string || "".equals(string) ? null : this.getErrorIcon());
        this.firePropertyChange(PROP_IS_VALID, bl, this.isValid);
    }

    protected Icon getErrorIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsfret/source/resources/icons/error-glyph.gif", (boolean)false);
    }

    public static interface Validator {
        public String validate(String var1);
    }
}

