/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiProjectsListRenderer;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.kenai.ui.treelist.TreeListUI;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class KenaiSearchPanel
extends JPanel {
    private final JLabel noSearchResultsLabel = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"NoSearchResults.label.text"));
    private final JLabel noMatchingResultsLabel = new JLabel(NbBundle.getMessage(KenaiSearchPanel.class, (String)"NoResultsMatching.label.text"));
    private final JLabel badRequest = new JLabel();
    private JPanel noSearchLabelPanel;
    private JPanel noMatchingLabelPanel;
    private JPanel badRequestPanel;
    private static JList kenaiFeaturedProjectsList = null;
    private static JList kenaiFeaturedProjectsListWithRepos = null;
    private static JList kenaiRecentProjectsList = null;
    private static JList kenaiRecentProjectsListWithRepos = null;
    private PanelType panelType;
    private ProgressHandle progressHandle;
    private ProgressHandle progressHandleFeatured;
    private ProgressHandle progressHandleRecent;
    private boolean progressRunning;
    private boolean multiSelection;
    private KenaiProjectsListModel listModel;
    private static Pattern projectURLPattern = Pattern.compile(Kenai.getDefault().getUrl().toString().replaceFirst("^https://", "http://") + "/projects/([^/]*)/?.*");
    private static final int projectURLGroup = 1;
    private JPanel createButtonPanel;
    private JButton createNewProjectButton;
    private JPanel featuredProjectPanel;
    private JList kenaiProjectsList;
    private JTabbedPane kenaiProjectsTabPane;
    private JLabel projectsLabel;
    private JPanel recentProjectPanel;
    private JScrollPane scrollPane;
    private JScrollPane scrollPaneFeatured;
    private JScrollPane scrollPaneRecent;
    private JButton searchButton;
    private JPanel searchButtonPanel;
    private JLabel searchInfoLabel;
    private JLabel searchLabel;
    private JPanel searchResultsPanel;
    private JTextField searchTextField;

    public KenaiSearchPanel(PanelType panelType, boolean bl) {
        this.panelType = panelType;
        this.multiSelection = bl;
        this.initComponents();
        this.kenaiProjectsList.setUI(new TreeListUI());
        this.noSearchLabelPanel = this.createLabelPanel(this.noSearchResultsLabel);
        this.noMatchingLabelPanel = this.createLabelPanel(this.noMatchingResultsLabel);
        this.badRequestPanel = this.createLabelPanel(this.badRequest);
        this.searchResultsPanel.remove(this.scrollPane);
        this.searchResultsPanel.add((Component)this.noSearchLabelPanel, "Center");
        if (this.panelType == PanelType.BROWSE) {
            this.remove(this.createButtonPanel);
        }
        final ListSelectionModel listSelectionModel = this.kenaiProjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (listSelectionModel.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        this.kenaiProjectsTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (kenaiFeaturedProjectsList != null) {
                    kenaiFeaturedProjectsList.clearSelection();
                }
                if (kenaiRecentProjectsList != null) {
                    kenaiRecentProjectsList.clearSelection();
                }
                if (kenaiFeaturedProjectsListWithRepos != null) {
                    kenaiFeaturedProjectsListWithRepos.clearSelection();
                }
                if (kenaiRecentProjectsListWithRepos != null) {
                    kenaiRecentProjectsListWithRepos.clearSelection();
                }
                KenaiSearchPanel.this.kenaiProjectsList.clearSelection();
            }
        });
        if (this.panelType == PanelType.OPEN) {
            this.setOpenPanels();
        } else {
            this.setBrowsePanels();
        }
        Kenai.getDefault().addPropertyChangeListener("url", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                kenaiFeaturedProjectsList = null;
                kenaiRecentProjectsList = null;
            }
        });
    }

    private void setOpenPanels() {
        if (kenaiFeaturedProjectsList == null || kenaiFeaturedProjectsList.getModel().getSize() == 0) {
            kenaiFeaturedProjectsList = new JList();
            kenaiFeaturedProjectsList.setUI(new TreeListUI());
            kenaiFeaturedProjectsList.setSelectionMode(this.getListSelMode());
            kenaiFeaturedProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
            this.progressHandleFeatured = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelFeatured"));
            this.presentSpecialProjects(this.featuredProjectPanel, this.scrollPaneFeatured, kenaiFeaturedProjectsList, "featured", this.progressHandleFeatured);
        }
        if (kenaiRecentProjectsList == null || kenaiRecentProjectsList.getModel().getSize() == 0) {
            kenaiRecentProjectsList = new JList();
            kenaiRecentProjectsList.setUI(new TreeListUI());
            kenaiRecentProjectsList.setSelectionMode(this.getListSelMode());
            kenaiRecentProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
            this.progressHandleRecent = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelRecent"));
            this.presentSpecialProjects(this.recentProjectPanel, this.scrollPaneRecent, kenaiRecentProjectsList, "recent", this.progressHandleRecent);
        }
        final ListSelectionModel listSelectionModel = kenaiRecentProjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (listSelectionModel.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        final ListSelectionModel listSelectionModel2 = kenaiFeaturedProjectsList.getSelectionModel();
        listSelectionModel2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (listSelectionModel2.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        kenaiFeaturedProjectsList.clearSelection();
        kenaiRecentProjectsList.clearSelection();
        this.scrollPaneRecent.setViewportView(kenaiRecentProjectsList);
        this.scrollPaneFeatured.setViewportView(kenaiFeaturedProjectsList);
    }

    private void setBrowsePanels() {
        if (kenaiFeaturedProjectsListWithRepos == null || kenaiFeaturedProjectsListWithRepos.getModel().getSize() == 0) {
            kenaiFeaturedProjectsListWithRepos = new JList();
            kenaiFeaturedProjectsListWithRepos.setUI(new TreeListUI());
            kenaiFeaturedProjectsListWithRepos.setSelectionMode(this.getListSelMode());
            kenaiFeaturedProjectsListWithRepos.setCellRenderer(new KenaiProjectsListRenderer2());
            this.progressHandleFeatured = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelFeatured"));
            this.presentSpecialProjects(this.featuredProjectPanel, this.scrollPaneFeatured, kenaiFeaturedProjectsListWithRepos, "featured", this.progressHandleFeatured);
        }
        if (kenaiRecentProjectsListWithRepos == null || kenaiRecentProjectsListWithRepos.getModel().getSize() == 0) {
            kenaiRecentProjectsListWithRepos = new JList();
            kenaiRecentProjectsListWithRepos.setUI(new TreeListUI());
            kenaiRecentProjectsListWithRepos.setSelectionMode(this.getListSelMode());
            kenaiRecentProjectsListWithRepos.setCellRenderer(new KenaiProjectsListRenderer2());
            this.progressHandleRecent = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabelRecent"));
            this.presentSpecialProjects(this.recentProjectPanel, this.scrollPaneRecent, kenaiRecentProjectsListWithRepos, "recent", this.progressHandleRecent);
        }
        final ListSelectionModel listSelectionModel = kenaiRecentProjectsListWithRepos.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (listSelectionModel.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        final ListSelectionModel listSelectionModel2 = kenaiFeaturedProjectsListWithRepos.getSelectionModel();
        listSelectionModel2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (listSelectionModel2.isSelectionEmpty()) {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.FALSE);
                    } else {
                        KenaiSearchPanel.this.firePropertyChange("selectionValid", null, Boolean.TRUE);
                    }
                }
            }
        });
        kenaiFeaturedProjectsListWithRepos.clearSelection();
        kenaiRecentProjectsListWithRepos.clearSelection();
        this.scrollPaneRecent.setViewportView(kenaiRecentProjectsListWithRepos);
        this.scrollPaneFeatured.setViewportView(kenaiFeaturedProjectsListWithRepos);
    }

    public KenaiProject getSelectedProject() {
        KenaiProjectSearchInfo kenaiProjectSearchInfo = null;
        kenaiProjectSearchInfo = this.kenaiProjectsTabPane.getSelectedComponent().equals(this.featuredProjectPanel) ? (KenaiProjectSearchInfo)kenaiFeaturedProjectsList.getSelectedValue() : (this.kenaiProjectsTabPane.getSelectedComponent().equals(this.recentProjectPanel) ? (KenaiProjectSearchInfo)kenaiRecentProjectsList.getSelectedValue() : (KenaiProjectSearchInfo)this.kenaiProjectsList.getSelectedValue());
        return kenaiProjectSearchInfo != null ? kenaiProjectSearchInfo.kenaiProject : null;
    }

    public KenaiProjectSearchInfo getSelectedProjectSearchInfo() {
        KenaiProjectSearchInfo kenaiProjectSearchInfo = null;
        kenaiProjectSearchInfo = this.kenaiProjectsTabPane.getSelectedComponent().equals(this.featuredProjectPanel) ? (KenaiProjectSearchInfo)(this.panelType == PanelType.OPEN ? kenaiFeaturedProjectsList.getSelectedValue() : kenaiFeaturedProjectsListWithRepos.getSelectedValue()) : (this.kenaiProjectsTabPane.getSelectedComponent().equals(this.recentProjectPanel) ? (KenaiProjectSearchInfo)(this.panelType == PanelType.OPEN ? kenaiRecentProjectsList.getSelectedValue() : kenaiRecentProjectsListWithRepos.getSelectedValue()) : (KenaiProjectSearchInfo)this.kenaiProjectsList.getSelectedValue());
        return kenaiProjectSearchInfo != null ? kenaiProjectSearchInfo : null;
    }

    public KenaiProject[] getSelectedProjects() {
        Object[] objectArray = null;
        objectArray = this.kenaiProjectsTabPane.getSelectedComponent().equals(this.featuredProjectPanel) ? (this.panelType == PanelType.OPEN ? kenaiFeaturedProjectsList.getSelectedValues() : kenaiFeaturedProjectsListWithRepos.getSelectedValues()) : (this.kenaiProjectsTabPane.getSelectedComponent().equals(this.recentProjectPanel) ? (this.panelType == PanelType.OPEN ? kenaiRecentProjectsList.getSelectedValues() : kenaiRecentProjectsListWithRepos.getSelectedValues()) : this.kenaiProjectsList.getSelectedValues());
        KenaiProject[] kenaiProjectArray = new KenaiProject[objectArray.length];
        int n = 0;
        for (Object object : objectArray) {
            kenaiProjectArray[n++] = ((KenaiProjectSearchInfo)object).kenaiProject;
        }
        return objectArray.length > 0 ? kenaiProjectArray : null;
    }

    private int getListSelMode() {
        if (!this.multiSelection) {
            return 0;
        }
        return 2;
    }

    private void initComponents() {
        this.searchButtonPanel = new JPanel();
        this.searchLabel = new JLabel();
        this.searchButton = new JButton();
        this.searchInfoLabel = new JLabel();
        this.projectsLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.createButtonPanel = new JPanel();
        this.createNewProjectButton = new JButton();
        this.kenaiProjectsTabPane = new JTabbedPane();
        this.featuredProjectPanel = new JPanel();
        this.scrollPaneFeatured = new JScrollPane();
        this.recentProjectPanel = new JPanel();
        this.scrollPaneRecent = new JScrollPane();
        this.searchResultsPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.kenaiProjectsList = new JList();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setPreferredSize(new Dimension(700, 500));
        this.setLayout(new BorderLayout());
        this.searchButtonPanel.setLayout(new GridBagLayout());
        this.searchLabel.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.searchButtonPanel.add((Component)this.searchLabel, gridBagConstraints);
        this.searchLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KenaiSearchPanel.this.searchButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.searchButtonPanel.add((Component)this.searchButton, gridBagConstraints);
        this.searchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchButton.AccessibleContext.accessibleDescription"));
        this.searchInfoLabel.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchInfoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.searchButtonPanel.add((Component)this.searchInfoLabel, gridBagConstraints);
        this.searchInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchInfoLabel.AccessibleContext.accessibleDescription"));
        this.projectsLabel.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.projectsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 4, 0);
        this.searchButtonPanel.add((Component)this.projectsLabel, gridBagConstraints);
        this.projectsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.projectsLabel.AccessibleContext.accessibleDescription"));
        this.searchTextField.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchTextField.text"));
        this.searchTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KenaiSearchPanel.this.searchTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.searchButtonPanel.add((Component)this.searchTextField, gridBagConstraints);
        this.searchTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchTextField.AccessibleContext.accessibleName"));
        this.searchTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchTextField.AccessibleContext.accessibleDescription"));
        this.add((Component)this.searchButtonPanel, "North");
        this.createButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.createNewProjectButton, (String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.createNewProjectButton.text"));
        this.createNewProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KenaiSearchPanel.this.createNewProjectButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.createButtonPanel.add((Component)this.createNewProjectButton, gridBagConstraints);
        this.createNewProjectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.createNewProjectButton.AccessibleContext.accessibleDescription"));
        this.add((Component)this.createButtonPanel, "South");
        this.featuredProjectPanel.setLayout(new BorderLayout());
        this.featuredProjectPanel.add((Component)this.scrollPaneFeatured, "Center");
        this.kenaiProjectsTabPane.addTab(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.featuredProjectPanel.TabConstraints.tabTitle"), this.featuredProjectPanel);
        this.recentProjectPanel.setLayout(new BorderLayout());
        this.recentProjectPanel.add((Component)this.scrollPaneRecent, "Center");
        this.kenaiProjectsTabPane.addTab(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.recentProjectPanel.TabConstraints.tabTitle"), this.recentProjectPanel);
        this.searchResultsPanel.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.kenaiProjectsList.setSelectionMode(this.getListSelMode());
        this.kenaiProjectsList.setCellRenderer(new KenaiProjectsListRenderer2());
        this.scrollPane.setViewportView(this.kenaiProjectsList);
        this.kenaiProjectsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleName"));
        this.kenaiProjectsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.kenaiProjectsList.AccessibleContext.accessibleDescription"));
        this.searchResultsPanel.add((Component)this.scrollPane, "Center");
        this.kenaiProjectsTabPane.addTab(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.searchResultsPanel.TabConstraints.tabTitle"), this.searchResultsPanel);
        this.add((Component)this.kenaiProjectsTabPane, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.AccessibleContext.accessibleDescription"));
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.invokeSearch();
    }

    private void searchTextFieldActionPerformed(ActionEvent actionEvent) {
        this.invokeSearch();
    }

    private void createNewProjectButtonActionPerformed(ActionEvent actionEvent) {
        new NewKenaiProjectAction().actionPerformed(actionEvent);
    }

    private void presentSpecialProjects(final JPanel jPanel, final JScrollPane jScrollPane, final JList jList, final String string, final ProgressHandle progressHandle) {
        final JPanel jPanel2 = this.createProgressPanel(progressHandle);
        jPanel.add((Component)jPanel2, "Center");
        this.revalidate();
        this.repaint();
        progressHandle.start();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator<KenaiProject> iterator = null;
                String string2 = "&filter=" + string;
                try {
                    iterator = Kenai.getDefault().searchProjects(string2).iterator();
                }
                catch (KenaiException kenaiException) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            progressHandle.finish();
                            jPanel.remove(jPanel2);
                            if ("400 Bad Request".equals(kenaiException.getStatus())) {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"BadRequest.label.text"));
                            } else {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"ServerError.label.text"));
                            }
                            jPanel.add((Component)KenaiSearchPanel.this.badRequestPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                    Logger.getLogger(KenaiSearchPanel.class.getName()).log(Level.INFO, kenaiException.getMessage(), kenaiException);
                    return;
                }
                if (iterator != null && iterator.hasNext()) {
                    final KenaiProjectsListModel kenaiProjectsListModel = new KenaiProjectsListModel(iterator, string2, jList);
                    KenaiSearchPanel.this.setListModel(kenaiProjectsListModel);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            progressHandle.finish();
                            jPanel.remove(jPanel2);
                            jList.setModel(kenaiProjectsListModel);
                            jPanel.add((Component)jScrollPane, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            progressHandle.finish();
                            jPanel.remove(jPanel2);
                            jPanel.add((Component)KenaiSearchPanel.this.noMatchingLabelPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void invokeSearch() {
        UIUtils.logKenaiUsage("PROJECT_SEARCH");
        this.kenaiProjectsTabPane.setSelectedComponent(this.searchResultsPanel);
        this.kenaiProjectsTabPane.validate();
        if (this.getListModel() != null) {
            this.getListModel().stopLoading();
        }
        this.searchTextField.setText(this.searchTextField.getText().toLowerCase());
        this.searchButton.setEnabled(false);
        this.searchTextField.setEnabled(false);
        boolean bl = false;
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiSearchPanel.class, (String)"KenaiSearchPanel.progressLabel"));
        final JPanel jPanel = this.createProgressPanel(this.progressHandle);
        if (this.scrollPane.isShowing()) {
            this.searchResultsPanel.remove(this.scrollPane);
            bl = true;
        } else if (this.noSearchLabelPanel != null && this.noSearchLabelPanel.isShowing()) {
            this.searchResultsPanel.remove(this.noSearchLabelPanel);
            bl = true;
        } else if (this.noMatchingLabelPanel != null && this.noMatchingLabelPanel.isShowing()) {
            this.searchResultsPanel.remove(this.noMatchingLabelPanel);
            bl = true;
        } else if (this.badRequestPanel != null && this.badRequestPanel.isShowing()) {
            this.searchResultsPanel.remove(this.badRequestPanel);
            bl = true;
        }
        if (bl) {
            this.searchResultsPanel.add((Component)jPanel, "Center");
            this.startProgress();
            this.revalidate();
            this.repaint();
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator<KenaiProject> iterator = null;
                String string = KenaiSearchPanel.this.searchTextField.getText();
                Matcher matcher = projectURLPattern.matcher(string);
                if (matcher.matches()) {
                    string = matcher.group(1);
                }
                try {
                    iterator = Kenai.getDefault().searchProjects(string).iterator();
                }
                catch (KenaiException kenaiException) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.searchResultsPanel.remove(jPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            if ("400 Bad Request".equals(kenaiException.getStatus())) {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"BadRequest.label.text"));
                            } else {
                                KenaiSearchPanel.this.badRequest.setText(NbBundle.getMessage(KenaiSearchPanel.class, (String)"ServerError.label.text"));
                            }
                            KenaiSearchPanel.this.searchResultsPanel.add((Component)KenaiSearchPanel.this.badRequestPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                            KenaiSearchPanel.this.searchTextField.requestFocus();
                        }
                    });
                    Logger.getLogger(KenaiSearchPanel.class.getName()).log(Level.INFO, kenaiException.getMessage(), kenaiException);
                    return;
                }
                if (iterator != null && iterator.hasNext()) {
                    final KenaiProjectsListModel kenaiProjectsListModel = new KenaiProjectsListModel(iterator, string, KenaiSearchPanel.this.kenaiProjectsList);
                    KenaiSearchPanel.this.setListModel(kenaiProjectsListModel);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            KenaiSearchPanel.this.kenaiProjectsList.setModel(kenaiProjectsListModel);
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.searchResultsPanel.remove(jPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            KenaiSearchPanel.this.searchResultsPanel.add((Component)KenaiSearchPanel.this.scrollPane, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                        }
                    });
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            KenaiSearchPanel.this.finishProgress();
                            KenaiSearchPanel.this.searchResultsPanel.remove(jPanel);
                            KenaiSearchPanel.this.searchButton.setEnabled(true);
                            KenaiSearchPanel.this.searchTextField.setEnabled(true);
                            KenaiSearchPanel.this.searchResultsPanel.add((Component)KenaiSearchPanel.this.noMatchingLabelPanel, "Center");
                            KenaiSearchPanel.this.revalidate();
                            KenaiSearchPanel.this.repaint();
                            KenaiSearchPanel.this.searchTextField.requestFocus();
                        }
                    });
                }
            }
        });
    }

    private synchronized void setListModel(KenaiProjectsListModel kenaiProjectsListModel) {
        this.listModel = kenaiProjectsListModel;
    }

    private synchronized KenaiProjectsListModel getListModel() {
        return this.listModel;
    }

    private synchronized void startProgress() {
        if (!this.progressRunning && this.progressHandle != null) {
            this.progressHandle.start();
            this.progressRunning = true;
        }
    }

    private synchronized void finishProgress() {
        if (this.progressRunning && this.progressHandle != null) {
            this.progressHandle.finish();
            this.progressRunning = false;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        KenaiProjectsListModel kenaiProjectsListModel = this.getListModel();
        if (kenaiProjectsListModel != null) {
            kenaiProjectsListModel.stopLoading();
        }
    }

    private JPanel createLabelPanel(JLabel jLabel) {
        JPanel jPanel = this.preparePanel();
        jLabel.setEnabled(false);
        jLabel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        return jPanel2;
    }

    private JPanel createProgressPanel(ProgressHandle progressHandle) {
        JPanel jPanel = this.preparePanel();
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 0, 40);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 20, 40);
        jPanel.add((Component)jComponent, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        return jPanel2;
    }

    private JPanel preparePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Color color = UIManager.getColor("window");
        jPanel.setBackground(color != null ? color : Color.WHITE);
        return jPanel;
    }

    public static class KenaiProjectSearchInfo {
        public KenaiProject kenaiProject;
        public KenaiFeature kenaiFeature;
        public String searchPattern;

        public KenaiProjectSearchInfo(KenaiProject kenaiProject, String string) {
            this.kenaiProject = kenaiProject;
            this.searchPattern = string;
            this.kenaiFeature = null;
        }

        public KenaiProjectSearchInfo(KenaiProject kenaiProject, KenaiFeature kenaiFeature, String string) {
            this.kenaiProject = kenaiProject;
            this.kenaiFeature = kenaiFeature;
            this.searchPattern = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KenaiProjectsListModel
    extends DefaultListModel
    implements Runnable {
        private Iterator<KenaiProject> projects;
        private String pattern;
        private JList kpList;
        private static final int MAX_PROJECT_COUNT = 100;
        private boolean itemSelected = false;
        private boolean stopLoading;

        public KenaiProjectsListModel(Iterator<KenaiProject> iterator, String string, JList jList) {
            this.projects = iterator;
            this.pattern = string;
            this.kpList = jList;
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            if (this.projects != null) {
                int n = 0;
                while (this.projects.hasNext() && n < 100) {
                    KenaiProject kenaiProject = this.projects.next();
                    ++n;
                    try {
                        kenaiProject.getProjectIcon();
                    }
                    catch (KenaiException kenaiException) {
                        Logger.getLogger(KenaiSearchPanel.class.getName()).log(Level.INFO, "There are problems with getting a project icon - maybe see http://www.netbeans.org/issues/show_bug.cgi?id=172649", kenaiException);
                    }
                    if (PanelType.OPEN.equals((Object)KenaiSearchPanel.this.panelType)) {
                        this.addElementLater(new KenaiProjectSearchInfo(kenaiProject, this.pattern));
                    } else if (PanelType.BROWSE.equals((Object)KenaiSearchPanel.this.panelType)) {
                        try {
                            KenaiFeature[] kenaiFeatureArray;
                            for (KenaiFeature kenaiFeature : kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.SOURCE)) {
                                if (!"subversion".equals(kenaiFeature.getService()) && !"mercurial".equals(kenaiFeature.getService())) continue;
                                this.addElementLater(new KenaiProjectSearchInfo(kenaiProject, kenaiFeature, this.pattern));
                            }
                        }
                        catch (KenaiException kenaiException) {
                            Exceptions.printStackTrace((Throwable)kenaiException);
                        }
                    }
                    Thread.yield();
                    if (!this.loadingStopped()) continue;
                    return;
                }
            }
        }

        public synchronized void stopLoading() {
            this.stopLoading = true;
        }

        public synchronized boolean loadingStopped() {
            return this.stopLoading;
        }

        private void addElementLater(final KenaiProjectSearchInfo kenaiProjectSearchInfo) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KenaiProjectsListModel.this.addElement(kenaiProjectSearchInfo);
                    if (!KenaiProjectsListModel.this.itemSelected) {
                        KenaiProjectsListModel.this.kpList.requestFocus();
                        KenaiProjectsListModel.this.kpList.setSelectedIndex(0);
                        KenaiProjectsListModel.this.itemSelected = true;
                    }
                }
            });
        }
    }

    private class KenaiProjectsListRenderer2
    implements ListCellRenderer {
        private KenaiProjectsListRenderer2() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return new KenaiProjectsListRenderer(jList, object, n, bl, bl2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        OPEN,
        BROWSE;

    }
}

