/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.DelayExtensionProvider;
import org.netbeans.modules.kenai.collab.chat.NotificationExtension;
import org.netbeans.modules.kenai.collab.chat.NotificationExtensionProvider;
import org.netbeans.modules.kenai.collab.chat.PresenceIndicator;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiConnection
implements PropertyChangeListener {
    public static final String PROP_XMPP_STARTED = "xmpp_started";
    public static final String PROP_XMPP_FINISHED = "xmpp_finished";
    private HashMap<String, PacketListener> groupListeners = new HashMap();
    private HashMap<String, PacketListener> privateListeners = new HashMap();
    private XMPPConnection connection;
    private final Map<String, MultiUserChat> groupChats = new HashMap<String, MultiUserChat>();
    private final Map<String, Chat> privateChats = new HashMap<String, Chat>();
    private static KenaiConnection instance;
    private static Logger XMPPLOG;
    private HashMap<String, LinkedList<Message>> groupMessageQueue = new HashMap();
    private HashMap<String, LinkedList<Message>> privateMessageQueue = new HashMap();
    private static ChatNotifications chatNotifications;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RequestProcessor xmppProcessor = new RequestProcessor("XMPP Processor");
    private boolean isConnectionFailed;
    private String USER;

    public static synchronized KenaiConnection getDefault() {
        if (instance == null) {
            instance = new KenaiConnection();
            ProviderManager providerManager = ProviderManager.getInstance();
            providerManager.addExtensionProvider("delay", "urn:xmpp:delay", (Object)new DelayExtensionProvider());
            providerManager.addExtensionProvider("notification", "http://kenai.com/schema/XMPPNotification", (Object)new NotificationExtensionProvider());
            Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)instance);
        }
        return instance;
    }

    private KenaiConnection() {
    }

    synchronized void leaveGroup(String string) {
        this.groupListeners.remove(string);
    }

    synchronized void leavePrivate(String string) {
        this.privateListeners.remove(string);
    }

    synchronized void tryJoinChat(MultiUserChat multiUserChat) throws XMPPException {
        multiUserChat.join(this.getUserName());
    }

    private synchronized MultiUserChat createChat(KenaiFeature kenaiFeature) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection, this.getChatroomName(kenaiFeature));
        this.groupChats.put(kenaiFeature.getName(), multiUserChat);
        this.groupMessageQueue.put(kenaiFeature.getName(), new LinkedList());
        multiUserChat.addMessageListener((PacketListener)new MessageL());
        this.join(multiUserChat);
        return multiUserChat;
    }

    private void join(MultiUserChat multiUserChat) {
        try {
            multiUserChat.addParticipantListener((PacketListener)new PresenceIndicator.PresenceListener());
            multiUserChat.addParticipantListener((PacketListener)new PresenceListener());
            multiUserChat.join(this.getUserName());
        }
        catch (XMPPException xMPPException) {
            XMPPLOG.log(Level.INFO, "Cannot join " + multiUserChat.getRoom(), xMPPException);
        }
    }

    public synchronized Chat joinPrivate(String string, PacketListener packetListener) {
        String string2 = StringUtils.parseName((String)string);
        Chat chat = this.privateChats.get(string2);
        if (chat == null) {
            chat = Kenai.getDefault().getXMPPConnection().getChatManager().createChat(string, null);
            this.privateChats.put(string2, chat);
        }
        if (this.privateMessageQueue.get(string2) == null) {
            this.privateMessageQueue.put(string2, new LinkedList());
        }
        PacketListener packetListener2 = this.privateListeners.put(string2, packetListener);
        for (Message message : this.privateMessageQueue.get(string2)) {
            packetListener.processPacket((Packet)message);
        }
        assert (packetListener2 == null) : "User " + string2 + " already joined";
        return chat;
    }

    public synchronized void join(MultiUserChat multiUserChat, PacketListener packetListener) {
        String string = StringUtils.parseName((String)multiUserChat.getRoom());
        PacketListener packetListener2 = this.groupListeners.put(string, packetListener);
        for (Message message : this.groupMessageQueue.get(string)) {
            packetListener.processPacket((Packet)message);
        }
        assert (packetListener2 == null) : "Chat room " + string + " already joined";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tryConnect() {
        try {
            this.propertyChangeSupport.firePropertyChange(PROP_XMPP_STARTED, null, null);
            this.connect();
            this.initChats();
            PresenceIndicator.getDefault().setStatus(Kenai.Status.ONLINE);
            this.isConnectionFailed = false;
        }
        catch (XMPPException xMPPException) {
            this.isConnectionFailed = true;
        }
        finally {
            this.propertyChangeSupport.firePropertyChange(PROP_XMPP_FINISHED, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected() && this.connection.isAuthenticated();
    }

    private void connect() throws XMPPException {
        this.connection = Kenai.getDefault().getXMPPConnection();
        this.connection.addPacketListener((PacketListener)new PacketL(), (PacketFilter)new MessageTypeFilter(Message.Type.chat));
    }

    public synchronized void reconnect(MultiUserChat multiUserChat) throws XMPPException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        if (multiUserChat == null) {
            for (MultiUserChat multiUserChat2 : this.getChats()) {
                if (multiUserChat2.isJoined()) continue;
                this.tryJoinChat(multiUserChat2);
            }
        } else if (!multiUserChat.isJoined()) {
            this.tryJoinChat(multiUserChat);
        }
        this.isConnectionFailed = false;
    }

    public Collection<String> getMembers(String string) {
        MultiUserChat multiUserChat = this.getChat(string);
        if (multiUserChat != null) {
            Iterator iterator = multiUserChat.getOccupants();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                arrayList.add(StringUtils.parseResource((String)((String)iterator.next())));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void initChats() {
        if (!this.connection.isConnected()) {
            return;
        }
        for (KenaiFeature kenaiFeature : KenaiConnection.getDefault().getMyChats()) {
            try {
                this.createChat(kenaiFeature);
            }
            catch (IllegalStateException illegalStateException) {
                Exceptions.printStackTrace((Throwable)illegalStateException);
            }
        }
    }

    public synchronized List<MultiUserChat> getChats() {
        ArrayList<MultiUserChat> arrayList = new ArrayList<MultiUserChat>(this.groupChats.values());
        return arrayList;
    }

    public synchronized MultiUserChat getChat(KenaiFeature kenaiFeature) {
        MultiUserChat multiUserChat = this.groupChats.get(kenaiFeature.getName());
        if (multiUserChat == null) {
            multiUserChat = this.createChat(kenaiFeature);
        }
        return multiUserChat;
    }

    public synchronized MultiUserChat getChat(String string) {
        return this.groupChats.get(string);
    }

    public synchronized Chat getPrivateChat(String string) {
        return this.privateChats.get(string);
    }

    public RequestProcessor.Task post(Runnable runnable) {
        return this.xmppProcessor.post(runnable);
    }

    public boolean isConnectionFailed() {
        return this.isConnectionFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("xmpp_login".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        KenaiConnection kenaiConnection = KenaiConnection.this;
                        synchronized (kenaiConnection) {
                            block5: {
                                PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
                                KenaiConnection.this.USER = passwordAuthentication.getUserName();
                                try {
                                    KenaiConnection.this.tryConnect();
                                }
                                catch (IllegalStateException illegalStateException) {
                                    if (Kenai.getDefault().getXMPPConnection() == null) break block5;
                                    Exceptions.printStackTrace((Throwable)illegalStateException);
                                }
                            }
                        }
                    }
                });
            } else {
                try {
                    KenaiConnection kenaiConnection = this;
                    synchronized (kenaiConnection) {
                        for (MultiUserChat multiUserChat : this.getChats()) {
                            try {
                                multiUserChat.leave();
                            }
                            catch (IllegalStateException illegalStateException) {
                                XMPPLOG.log(Level.FINE, null, illegalStateException);
                            }
                        }
                        this.groupChats.clear();
                        this.groupMessageQueue.clear();
                        this.groupListeners.clear();
                        this.privateListeners.clear();
                        this.privateMessageQueue.clear();
                        this.privateChats.clear();
                    }
                    PresenceIndicator.getDefault().setStatus(Kenai.Status.LOGGED_IN);
                    ChatNotifications.getDefault().clearAll();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private String getUserName() {
        return this.USER;
    }

    private String getChatroomName(KenaiFeature kenaiFeature) {
        return kenaiFeature.getName() + "@muc." + Kenai.getDefault().getUrl().getHost();
    }

    public Collection<KenaiFeature> getMyChats() {
        ArrayList<KenaiFeature> arrayList = new ArrayList<KenaiFeature>();
        try {
            for (KenaiProject kenaiProject : Kenai.getDefault().getMyProjects()) {
                arrayList.addAll(Arrays.asList(kenaiProject.getFeatures(KenaiService.Type.CHAT)));
            }
            return arrayList;
        }
        catch (KenaiException kenaiException) {
            throw new RuntimeException(kenaiException);
        }
    }

    static {
        XMPPLOG = Logger.getLogger(KenaiConnection.class.getName());
        chatNotifications = ChatNotifications.getDefault();
    }

    public class PresenceListener
    implements PacketListener {
        public void processPacket(Packet packet) {
            KenaiConnection.this.xmppProcessor.post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ChatTopComponent.refreshContactList();
                        }
                    });
                }
            }, 100);
        }
    }

    private class MessageL
    implements PacketListener {
        private MessageL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            KenaiConnection kenaiConnection = KenaiConnection.this;
            synchronized (kenaiConnection) {
                final Message message = (Message)packet;
                String string = StringUtils.parseName((String)message.getFrom());
                if (string.contains("@")) {
                    string = StringUtils.parseName((String)string);
                }
                final String string2 = string;
                final NotificationExtension notificationExtension = (NotificationExtension)message.getExtension("notification", "http://kenai.com/schema/XMPPNotification");
                if (notificationExtension != null && message.getExtension("x", "jabber:x:delay") == null) {
                    KenaiConnection.this.post(new Runnable(){

                        public void run() {
                            try {
                                Kenai.getDefault().getProject(string2).firePropertyChange("project_notification", null, (Object)notificationExtension.getNotification());
                            }
                            catch (KenaiException kenaiException) {
                                Exceptions.printStackTrace((Throwable)kenaiException);
                            }
                        }
                    });
                }
                if (notificationExtension != null && !Boolean.parseBoolean(System.getProperty("kenai.show.notifications.in.chat", "true"))) {
                    return;
                }
                LinkedList linkedList = (LinkedList)KenaiConnection.this.groupMessageQueue.get(string2);
                linkedList.add(message);
                final PacketListener packetListener = (PacketListener)KenaiConnection.this.groupListeners.get(string2);
                if (packetListener != null) {
                    packetListener.processPacket((Packet)message);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (chatNotifications.isEnabled(string2) && (packetListener == null || !ChatTopComponent.isGroupInitedAndVisible(string2))) {
                            chatNotifications.addGroupMessage(message);
                        } else {
                            chatNotifications.getMessagingHandle(string2).notifyMessageReceived(message);
                            chatNotifications.getMessagingHandle(string2).notifyMessagesRead();
                        }
                    }
                });
            }
        }
    }

    private class PacketL
    implements PacketListener {
        private PacketL() {
        }

        public void processPacket(Packet packet) {
            final Message message = (Message)packet;
            String string = StringUtils.parseName((String)message.getFrom());
            LinkedList<Message> linkedList = (LinkedList<Message>)KenaiConnection.this.privateMessageQueue.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<Message>();
                KenaiConnection.this.privateMessageQueue.put(string, linkedList);
            }
            linkedList.add(message);
            PacketListener packetListener = (PacketListener)KenaiConnection.this.privateListeners.get(string);
            if (packetListener != null) {
                packetListener.processPacket((Packet)message);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!ChatTopComponent.isPrivateInitedAndVisible(ChatTopComponent.createPrivateName(StringUtils.parseName((String)message.getFrom())))) {
                        chatNotifications.addPrivateMessage(message);
                    }
                }
            });
        }
    }
}

