/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXBusyLabel;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatPanel;
import org.netbeans.modules.kenai.collab.chat.ContactList;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ChatTopComponent
extends TopComponent {
    private static final String KENAI_OPEN_CHATS_PREF = ".open.chats.";
    private static ChatTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/kenai/collab/resources/chat.png";
    static final String PLUS = "org/netbeans/modules/kenai/collab/resources/plus.png";
    private static final String PREFERRED_ID = "ChatTopComponent";
    private final KenaiConnection kec = KenaiConnection.getDefault();
    private HashSet<String> open = new HashSet();
    private final Preferences prefs = NbPreferences.forModule(ChatTopComponent.class);
    private final JPanel chatsPanel = new JPanel(){

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    };
    private boolean initInProgress = false;
    private JTabbedPane chats;
    private ContactList contactList;
    private JPanel errorScreen;
    private JLabel initLabel;
    private JPanel initPanel;
    private JLabel lblXmppError;
    private JLabel loginLink;
    private JPanel loginScreen;
    private JLabel retryLink;

    public void reconnect() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                KenaiConnection kenaiConnection = ChatTopComponent.this.kec;
                synchronized (kenaiConnection) {
                    try {
                        ChatTopComponent.this.kec.reconnect(null);
                    }
                    catch (XMPPException xMPPException) {
                        Logger.getLogger(ChatTopComponent.class.getName()).log(Level.INFO, xMPPException.getMessage(), xMPPException);
                    }
                }
                if (ChatTopComponent.this.kec.isConnected()) {
                    ChatTopComponent.this.putChatsScreen();
                } else if (ChatTopComponent.this.kec.isConnectionFailed()) {
                    ChatTopComponent.this.putErrorScreen();
                } else {
                    ChatTopComponent.this.putLoginScreen();
                }
            }
        });
    }

    public void requestActive() {
        this.requestActive(true);
    }

    void requestActive(final boolean bl) {
        super.requestActive();
        Component component = this.chats.getSelectedComponent();
        if (component != null) {
            component.requestFocus();
        }
        if (this.chats.getTabCount() == 1 && bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ChatTopComponent.this.chats.getTabCount() != 1 || !bl || ChatTopComponent.this.chats.isShowing()) {
                        // empty if block
                    }
                }
            });
        }
    }

    private ChatTopComponent() {
        this.initComponents();
        this.clearChatsTabbedPane();
        this.contactList.putClientProperty("noCloseButton", Boolean.TRUE);
        this.setName(NbBundle.getMessage(ChatTopComponent.class, (String)"CTL_ChatTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ChatTopComponent.class, (String)"HINT_ChatTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        OverlayLayout overlayLayout = new OverlayLayout(this.chatsPanel);
        this.chatsPanel.setLayout(overlayLayout);
        this.chats.setAlignmentX(0.0f);
        this.chats.setAlignmentY(0.0f);
        this.chatsPanel.add(this.chats);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ChatTopComponent.this.chats.getSelectedIndex();
                if (n >= 0) {
                    String string;
                    ChatTopComponent.this.chats.setForegroundAt(n, Color.BLACK);
                    if (!ChatTopComponent.this.initInProgress && (string = ChatTopComponent.this.chats.getComponentAt(n).getName()) != null) {
                        ChatNotifications.getDefault().removeGroup(string);
                        string = string.substring(string.indexOf(46) + 1);
                        ChatNotifications.getDefault().removePrivate(string);
                    }
                    ChatTopComponent.this.chats.getComponentAt(n).requestFocus();
                }
            }
        };
        Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)new KenaiL());
        this.chats.addChangeListener(changeListener);
        this.chats.addPropertyChangeListener("close", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("close".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof ChatPanel) {
                    ChatTopComponent.this.removeChat((ChatPanel)propertyChangeEvent.getNewValue());
                }
            }
        });
        if (this.kec.isConnected()) {
            this.putChatsScreen();
        } else if (this.kec.isConnectionFailed()) {
            this.putErrorScreen();
        } else {
            this.putLoginScreen();
        }
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.chats.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.chats.setOpaque(true);
        }
    }

    private void putChatsScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.add(ChatTopComponent.this.chatsPanel, "Center");
                ChatTopComponent.this.putChats();
                ChatTopComponent.this.contactList.updateFilter();
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void clearChatsTabbedPane() {
        this.chats.removeAll();
        this.addMoreChatsTab(0);
    }

    private void addMoreChatsTab(int n) {
        this.chats.add(this.contactList);
        this.chats.setTitleAt(0, "");
        this.chats.setIconAt(n, ImageUtilities.loadImageIcon((String)PLUS, (boolean)true));
        this.chats.setToolTipTextAt(n, NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_MoreChats"));
    }

    private void putLoginScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.clearChatsTabbedPane();
                ChatTopComponent.this.open.clear();
                ChatTopComponent.this.add(ChatTopComponent.this.loginScreen, "Center");
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void putErrorScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.clearChatsTabbedPane();
                ChatTopComponent.this.open.clear();
                ChatTopComponent.this.add(ChatTopComponent.this.errorScreen, "Center");
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void putConnectingScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                ChatTopComponent.this.removeAll();
                ChatTopComponent.this.clearChatsTabbedPane();
                ChatTopComponent.this.open.clear();
                ((JXBusyLabel)ChatTopComponent.this.initLabel).setBusy(true);
                ChatTopComponent.this.add(ChatTopComponent.this.initPanel, "Center");
                ChatTopComponent.this.validate();
                ChatTopComponent.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private int getTab(String string) {
        for (int i = 0; i < this.chats.getTabCount(); ++i) {
            if (!string.equals(this.chats.getComponentAt(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public void setActiveGroup(String string) {
        ChatNotifications.getDefault().removeGroup(string);
        int n = this.getTab(string);
        if (n < 0) {
            MultiUserChat multiUserChat = this.kec.getChat(string);
            if (multiUserChat != null) {
                ChatPanel chatPanel = new ChatPanel(multiUserChat);
                this.addChat(chatPanel);
                n = this.chats.getTabCount() - 1;
                this.chats.setSelectedComponent(chatPanel);
            }
        } else {
            this.chats.setSelectedIndex(n);
        }
    }

    public void setActivePrivate(String string) {
        ChatNotifications.getDefault().removePrivate(string);
        int n = this.getTab(ChatTopComponent.createPrivateName(string));
        if (n < 0) {
            ChatPanel chatPanel = new ChatPanel(string + '@' + Kenai.getDefault().getUrl().getHost());
            this.addChat(chatPanel);
            n = this.chats.getTabCount() - 1;
            this.chats.setSelectedComponent(chatPanel);
        } else {
            this.chats.setSelectedIndex(n);
        }
    }

    public void insertToActiveChat(String string) {
        Component component = this.chats.getSelectedComponent();
        if (component instanceof ChatPanel) {
            ChatPanel chatPanel = (ChatPanel)component;
            chatPanel.insertToInputArea(string);
        }
    }

    public static final String createPrivateName(String string) {
        return "private." + string;
    }

    public void addChat(ChatPanel chatPanel) {
        int n = this.chats.getTabCount();
        this.chats.add(chatPanel);
        try {
            if (!chatPanel.isPrivate()) {
                this.chats.setTitleAt(n, Kenai.getDefault().getProject(chatPanel.getName()).getDisplayName());
            } else {
                this.chats.setTitleAt(n, chatPanel.getName().substring(chatPanel.getName().indexOf(46) + 1));
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (!chatPanel.isPrivate()) {
            this.open.add(chatPanel.getName());
            this.storeOpenChats();
        }
        this.chats.setSelectedComponent(chatPanel);
        this.validate();
    }

    void removeChat(ChatPanel chatPanel) {
        int n = this.chats.indexOfComponent(chatPanel);
        assert (n >= 0) : "Component not found in CloseButtonTabbedPane " + chatPanel;
        this.open.remove(chatPanel.getName());
        this.chats.remove(chatPanel);
        if (this.chats.getSelectedIndex() == this.chats.getTabCount() - 1 && this.chats.getTabCount() > 1) {
            this.chats.setSelectedIndex(this.chats.getSelectedIndex() - 1);
        }
        if (chatPanel.isPrivate()) {
            this.kec.leavePrivate(chatPanel.getPrivateName());
        } else {
            this.kec.leaveGroup(chatPanel.getName());
        }
        this.validate();
        this.storeOpenChats();
    }

    void setModified(ChatPanel chatPanel) {
        int n = this.chats.indexOfComponent(chatPanel);
        this.chats.setForegroundAt(n, Color.BLUE);
    }

    public static boolean isGroupInitedAndVisible(String string) {
        return instance == null ? false : instance.isShowing() && instance.isOpened() && ChatTopComponent.instance.open.contains(string) && string.equals(ChatTopComponent.instance.chats.getSelectedComponent().getName());
    }

    public static boolean isPrivateInitedAndVisible(String string) {
        return instance == null ? false : instance.isShowing() && instance.isOpened() && string.equals(ChatTopComponent.instance.chats.getSelectedComponent().getName());
    }

    private void putChats() {
        String string;
        this.initInProgress = true;
        List<MultiUserChat> list = this.kec.getChats();
        if (list.size() == 1) {
            MultiUserChat multiUserChat = (MultiUserChat)list.iterator().next();
            ChatPanel chatPanel = new ChatPanel(multiUserChat);
            this.addChat(chatPanel);
        } else if (list.size() != 0 && (string = this.prefs.get(Kenai.getDefault().getUrl().getHost() + KENAI_OPEN_CHATS_PREF + Kenai.getDefault().getPasswordAuthentication().getUserName(), "")).length() > 1) {
            Component component = null;
            for (String string2 : string.split(",")) {
                MultiUserChat multiUserChat = this.kec.getChat(string2);
                if (multiUserChat != null) {
                    component = new ChatPanel(multiUserChat);
                    this.addChat((ChatPanel)component);
                    continue;
                }
                Logger.getLogger(ChatTopComponent.class.getName()).warning("Cannot find chat " + string2);
            }
            if (component != null) {
                ChatNotifications.getDefault().removeGroup(component.getName());
            }
        }
        this.validate();
        this.initInProgress = false;
    }

    private void initComponents() {
        this.chats = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.contactList = new ContactList();
        this.loginScreen = new JPanel();
        this.loginLink = new JLabel();
        this.errorScreen = new JPanel();
        this.lblXmppError = new JLabel();
        this.retryLink = new JLabel();
        this.initPanel = new JPanel();
        this.initLabel = new JXBusyLabel(new Dimension(16, 16));
        this.chats.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ChatTopComponent.this.chatsMouseClicked(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ChatTopComponent.this.chatsMousePressed(mouseEvent);
            }
        });
        this.chats.addTab(NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.contactList.TabConstraints.tabTitle", (Object[])new Object[0]), this.contactList);
        this.loginScreen.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.loginLink.setForeground(Color.blue);
        Mnemonics.setLocalizedText((JLabel)this.loginLink, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.loginLink.text"));
        this.loginLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ChatTopComponent.this.loginLinkMouseClicked(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ChatTopComponent.this.loginLinkMouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ChatTopComponent.this.loginLinkMouseExited(mouseEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.loginScreen);
        this.loginScreen.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(4, 4, 4).add((Component)this.loginLink).addContainerGap(194, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(4, 4, 4).add((Component)this.loginLink).addContainerGap(414, Short.MAX_VALUE)));
        this.errorScreen.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.lblXmppError, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.lblXmppError.text"));
        Mnemonics.setLocalizedText((JLabel)this.retryLink, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.retryLink.text"));
        this.retryLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ChatTopComponent.this.retryLinkMouseClicked(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ChatTopComponent.this.retryLinkMouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ChatTopComponent.this.retryLinkMouseExited(mouseEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.errorScreen);
        this.errorScreen.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(5, 5, 5).add((Component)this.lblXmppError).addPreferredGap(0).add((Component)this.retryLink).addContainerGap(31, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblXmppError).add((Component)this.retryLink)).addContainerGap(413, Short.MAX_VALUE)));
        this.setLayout(new BorderLayout());
        this.initPanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.initLabel, (String)NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.initLabel.text"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.initPanel);
        this.initPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(5, 5, 5).add((Component)this.initLabel).addContainerGap(292, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(5, 5, 5).add((Component)this.initLabel).addContainerGap(279, Short.MAX_VALUE)));
        this.add(this.initPanel, "Center");
    }

    private void retryLinkMouseClicked(MouseEvent mouseEvent) {
        this.reconnect();
    }

    private void retryLinkMouseEntered(MouseEvent mouseEvent) {
        this.retryLink.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void retryLinkMouseExited(MouseEvent mouseEvent) {
        this.retryLink.setCursor(Cursor.getDefaultCursor());
    }

    private void chatsMouseClicked(MouseEvent mouseEvent) {
        int n = this.chats.getUI().tabForCoordinate(this.chats, mouseEvent.getX(), mouseEvent.getY());
        if (n == this.chats.getTabCount() - 1) {
            // empty if block
        }
    }

    private void loginLinkMouseExited(MouseEvent mouseEvent) {
        this.loginLink.setCursor(Cursor.getDefaultCursor());
    }

    private void loginLinkMouseEntered(MouseEvent mouseEvent) {
        this.loginLink.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void loginLinkMouseClicked(MouseEvent mouseEvent) {
        final Kenai kenai = Kenai.getDefault();
        if (kenai.getStatus() == Kenai.Status.OFFLINE) {
            UIUtils.showLogin();
        } else if (!Utilities.isChatSupported()) {
            JOptionPane.showMessageDialog(this.retryLink, NbBundle.getMessage(ChatTopComponent.class, (String)"ChatTopComponent.ChatNotAvailable", (Object)Kenai.getDefault().getName()));
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        PasswordAuthentication passwordAuthentication = kenai.getPasswordAuthentication();
                        kenai.login(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), true);
                    }
                    catch (KenaiException kenaiException) {
                        Exceptions.printStackTrace((Throwable)kenaiException);
                    }
                }
            });
        }
    }

    private void chatsMousePressed(MouseEvent mouseEvent) {
        int n = this.chats.getUI().tabForCoordinate(this.chats, mouseEvent.getX(), mouseEvent.getY());
        if (n != 0 && mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new Close());
            if (this.chats.getTabCount() > 2) {
                jPopupMenu.add(new CloseAll());
                jPopupMenu.add(new CloseAllButCurrent());
            }
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static synchronized ChatTopComponent getDefault() {
        if (instance == null) {
            instance = new ChatTopComponent();
        }
        return instance;
    }

    public static synchronized ChatTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(ChatTopComponent.class.getName()).warning("Cannot find ChatTopComponent component. It will not be located properly in the window system.");
            return ChatTopComponent.getDefault();
        }
        if (topComponent instanceof ChatTopComponent) {
            return (ChatTopComponent)topComponent;
        }
        Logger.getLogger(ChatTopComponent.class.getName()).warning("There seem to be multiple components with the 'ChatTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ChatTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static void refreshContactList() {
        if (instance != null && ChatTopComponent.instance.contactList != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    instance.contactList.updateContacts();
                    instance.repaint();
                }
            });
        }
    }

    void switchToContactList() {
        this.chats.setSelectedIndex(0);
    }

    private void storeOpenChats() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.open.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        this.prefs.put(Kenai.getDefault().getUrl().getHost() + KENAI_OPEN_CHATS_PREF + Kenai.getDefault().getPasswordAuthentication().getUserName(), stringBuffer.toString());
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_CloseAllButCurrent"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (Component component : ChatTopComponent.this.chats.getComponents()) {
                if (!(component instanceof ChatPanel) || component.isShowing()) continue;
                ChatTopComponent.this.removeChat((ChatPanel)component);
            }
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_CloseAll"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (Component component : ChatTopComponent.this.chats.getComponents()) {
                if (!(component instanceof ChatPanel)) continue;
                ChatTopComponent.this.removeChat((ChatPanel)component);
            }
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_CloseWindow"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChatPanel chatPanel = (ChatPanel)ChatTopComponent.this.chats.getSelectedComponent();
            ChatTopComponent.this.removeChat(chatPanel);
        }
    }

    private final class OpenChatAction
    extends AbstractAction {
        private KenaiFeature f;

        public OpenChatAction(KenaiFeature kenaiFeature) {
            try {
                String string = Kenai.getDefault().getProject(kenaiFeature.getName()).getDisplayName();
                this.putValue("Name", string);
            }
            catch (KenaiException kenaiException) {
                Exceptions.printStackTrace((Throwable)kenaiException);
            }
            this.f = kenaiFeature;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChatTopComponent.this.addChat(new ChatPanel(ChatTopComponent.this.kec.getChat(this.f)));
        }
    }

    final class KenaiL
    implements PropertyChangeListener {
        KenaiL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("login".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Kenai.Status status = Kenai.getDefault().getStatus();
                        if (status != Kenai.Status.ONLINE) {
                            ChatTopComponent.this.loginLink.setText(NbBundle.getMessage(ChatTopComponent.class, (String)(status == Kenai.Status.OFFLINE ? "ChatTopComponent.loginLink.text" : "ChatTopComponent.loginLink.startChat")));
                        }
                    }
                });
            } else if ("xmpp_login".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getNewValue() == null) {
                    ChatTopComponent.this.putLoginScreen();
                } else {
                    ChatTopComponent.this.kec.post(new Runnable(){

                        public void run() {
                            if (ChatTopComponent.this.kec.isConnectionFailed()) {
                                ChatTopComponent.this.putErrorScreen();
                            } else {
                                ChatTopComponent.this.kec.getMyChats();
                                ChatTopComponent.this.putChatsScreen();
                            }
                        }
                    });
                }
            } else if ("xmpp_login_started".equals(propertyChangeEvent.getPropertyName())) {
                ChatTopComponent.this.putConnectingScreen();
            } else if ("xmpp_login_failed".equals(propertyChangeEvent.getPropertyName())) {
                ChatTopComponent.this.putLoginScreen();
            }
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ChatTopComponent.getDefault();
        }
    }
}

