/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedJoinInfo;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinLexerInputOperation;
import org.netbeans.lib.lexer.JoinTokenListBase;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTokenList<T extends TokenId>
implements TokenList<T> {
    private static final Logger LOG = Logger.getLogger(JoinTokenList.class.getName());
    protected final TokenListList<T> tokenListList;
    protected final JoinTokenListBase base;
    protected final int tokenListStartIndex;
    protected int activeTokenListIndex;
    protected EmbeddedTokenList<T> activeTokenList;
    protected int activeStartJoinIndex;
    protected int activeEndJoinIndex;

    public static <T extends TokenId> JoinTokenList<T> create(TokenListList<T> tokenListList, int n, int n2) {
        assert (n2 > 0) : "tokenListCount must be >0";
        JoinTokenListBase joinTokenListBase = new JoinTokenListBase(n2);
        JoinTokenList<T> joinTokenList = new JoinTokenList<T>(tokenListList, joinTokenListBase, n);
        super.init();
        return joinTokenList;
    }

    public JoinTokenList(TokenListList<T> tokenListList, JoinTokenListBase joinTokenListBase, int n) {
        this.tokenListList = tokenListList;
        this.base = joinTokenListBase;
        this.tokenListStartIndex = n;
        this.activeTokenListIndex = -1;
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenListList.languagePath();
    }

    public TokenListList<T> tokenListList() {
        return this.tokenListList;
    }

    public JoinTokenListBase base() {
        return this.base;
    }

    public int tokenListStartIndex() {
        return this.tokenListStartIndex;
    }

    public EmbeddedTokenList<T> tokenList(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + " < 0");
        }
        if (n >= this.base.tokenListCount) {
            throw new IndexOutOfBoundsException("index=" + n + " >= size()=" + this.base.tokenListCount);
        }
        return (EmbeddedTokenList)this.tokenListList.get(this.tokenListStartIndex + n);
    }

    public int tokenListCount() {
        return this.base.tokenListCount;
    }

    @Override
    public int tokenCountCurrent() {
        return this.base.joinTokenCount;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    public int activeStartJoinIndex() {
        return this.activeStartJoinIndex;
    }

    public int activeEndJoinIndex() {
        return this.activeEndJoinIndex;
    }

    public int activeTokenListIndex() {
        return this.activeTokenListIndex;
    }

    public void setActiveTokenListIndex(int n) {
        if (this.activeTokenListIndex != n) {
            this.activeTokenListIndex = n;
            this.fetchActiveTokenListData();
        }
    }

    public EmbeddedTokenList<T> activeTokenList() {
        return this.activeTokenList;
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        AbstractToken<T> abstractToken;
        TokenOrEmbedding<T> tokenOrEmbedding;
        this.locateTokenListByIndex(n);
        TokenOrEmbedding<T> tokenOrEmbedding2 = tokenOrEmbedding = this.activeTokenList != null ? this.activeTokenList.tokenOrEmbedding(n - this.activeStartJoinIndex) : null;
        if (n == this.activeStartJoinIndex && tokenOrEmbedding != null && (abstractToken = tokenOrEmbedding.token()).getClass() == PartToken.class) {
            tokenOrEmbedding = ((PartToken)abstractToken).joinTokenOrEmbedding();
        }
        return tokenOrEmbedding;
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        throw new IllegalStateException("Internal error - should never be called");
    }

    @Override
    public int tokenOffset(int n) {
        AbstractToken<T> abstractToken;
        this.locateTokenListByIndex(n);
        if (n == this.activeStartJoinIndex && (abstractToken = this.activeTokenList.tokenOrEmbedding(n - this.activeStartJoinIndex).token()).getClass() == PartToken.class) {
            return ((JoinToken)((PartToken)abstractToken).joinToken()).offset(null);
        }
        return this.activeTokenList.tokenOffset(n - this.activeStartJoinIndex);
    }

    public int tokenListIndex(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            int n7 = this.tokenList(n6).startOffset();
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            n5 = n6;
            break;
        }
        return n5;
    }

    @Override
    public int[] tokenIndex(int n) {
        AbstractToken<T> abstractToken;
        boolean bl;
        boolean bl2 = bl = n >= this.activeTokenList.startOffset() || this.activeTokenListIndex == 0;
        if (bl) {
            if (n >= this.activeTokenList.endOffset() && this.activeTokenListIndex + 1 != this.tokenListCount() && n >= this.tokenList(this.activeTokenListIndex + 1).startOffset() && this.activeTokenListIndex + 1 < this.tokenListCount()) {
                this.activeTokenListIndex = this.tokenListIndex(n, this.activeTokenListIndex + 1, this.tokenListCount());
                this.fetchActiveTokenListData();
            }
        } else if (this.activeTokenListIndex > 0) {
            this.activeTokenListIndex = this.tokenListIndex(n, 0, this.activeTokenListIndex);
            if (this.activeTokenListIndex < 0) {
                this.activeTokenListIndex = 0;
            }
            this.fetchActiveTokenListData();
        }
        EmbeddedJoinInfo embeddedJoinInfo = this.activeTokenList.joinInfo;
        int n2 = embeddedJoinInfo.joinTokenLastPartShift();
        int n3 = this.activeTokenList.joinTokenCount();
        int[] nArray = LexerUtilsConstants.tokenIndexBinSearch(this.activeTokenList, n, n3);
        int n4 = nArray[0];
        nArray[0] = nArray[0] + embeddedJoinInfo.joinTokenIndex();
        if (n4 == n3 && n2 > 0) {
            this.activeTokenListIndex += n2;
            this.fetchActiveTokenListData();
            PartToken partToken = (PartToken)this.activeTokenList.tokenOrEmbeddingUnsync(0).token();
            nArray[1] = ((JoinToken)partToken.joinToken()).offset(null);
        } else if (n4 == 0 && (abstractToken = this.activeTokenList.tokenOrEmbedding(0).token()).getClass() == PartToken.class) {
            nArray[1] = ((JoinToken)((PartToken)abstractToken).joinToken()).offset(null);
        }
        return nArray;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        this.locateTokenListByIndex(n);
        return this.activeTokenList.replaceFlyToken(n - this.activeStartJoinIndex, abstractToken, n2);
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        this.locateTokenListByIndex(n);
        this.activeTokenList.wrapToken(n - this.activeStartJoinIndex, embeddingContainer);
    }

    @Override
    public final int modCount() {
        return this.rootTokenList().modCount() + this.base.extraModCount;
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.rootTokenList().inputAttributes();
    }

    @Override
    public int lookahead(int n) {
        this.locateTokenListByIndex(n);
        return this.activeTokenList.lookahead(n - this.activeStartJoinIndex);
    }

    @Override
    public Object state(int n) {
        this.locateTokenListByIndex(n);
        return this.activeTokenList.state(n - this.activeStartJoinIndex);
    }

    @Override
    public final TokenList<?> rootTokenList() {
        return this.tokenListList.rootTokenList();
    }

    @Override
    public CharSequence inputSourceText() {
        return this.rootTokenList().inputSourceText();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.rootTokenList().tokenHierarchyOperation();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.activeTokenListIndex == 0) {
            return this.activeTokenList.startOffset();
        }
        EmbeddedTokenList<T> embeddedTokenList = this.tokenList(0);
        this.updateStatus(embeddedTokenList);
        return embeddedTokenList.startOffset();
    }

    @Override
    public int endOffset() {
        int n = this.tokenListCount() - 1;
        if (n < 0) {
            return 0;
        }
        if (this.activeTokenListIndex == n) {
            return this.activeTokenList.endOffset();
        }
        EmbeddedTokenList<T> embeddedTokenList = this.tokenList(n);
        this.updateStatus(embeddedTokenList);
        return embeddedTokenList.endOffset();
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    public int tokenStartLocalIndex(int n) {
        int n2 = this.tokenCount();
        if (n != n2) {
            this.locateTokenListByIndex(n);
            AbstractToken<T> abstractToken = this.activeTokenList.tokenOrEmbeddingUnsync(n - this.activeStartJoinIndex).token();
            if (abstractToken.getClass() == PartToken.class) {
                PartToken partToken = (PartToken)abstractToken;
                this.activeTokenListIndex -= ((JoinToken)partToken.joinToken()).extraTokenListSpanCount();
                this.fetchActiveTokenListData();
                return this.activeTokenList.tokenCountCurrent() - 1;
            }
            return n - this.activeStartJoinIndex;
        }
        this.setActiveTokenListIndex(this.tokenListCount());
        return 0;
    }

    protected final void locateTokenListByIndex(int n) {
        if (n < this.activeStartJoinIndex) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("index=" + n + " < 0");
            }
            --this.activeTokenListIndex;
            this.fetchActiveTokenListData();
            if (n < this.activeStartJoinIndex) {
                this.positionToJoinIndex(n, 0, this.activeTokenListIndex - 1);
            }
        } else if (n == this.activeEndJoinIndex) {
            int n2;
            int n3 = n2 = this.activeTokenList != null ? this.activeTokenList.joinInfo.joinTokenLastPartShift() : 0;
            if (n2 > 0) {
                this.activeTokenListIndex += n2;
                this.fetchActiveTokenListData();
            } else if (this.activeTokenListIndex + 1 < this.tokenListCount()) {
                ++this.activeTokenListIndex;
                this.fetchActiveTokenListData();
                this.adjustJoinedOrSkipEmpty();
            }
        } else if (n > this.activeEndJoinIndex && this.activeTokenListIndex + 1 < this.tokenListCount()) {
            ++this.activeTokenListIndex;
            this.fetchActiveTokenListData();
            if (n >= this.activeEndJoinIndex) {
                this.positionToJoinIndex(n, this.activeTokenListIndex + 1, this.base.tokenListCount - 1);
            }
        }
    }

    private void positionToJoinIndex(int n, int n2, int n3) {
        while (n2 <= n3) {
            this.activeTokenListIndex = n2 + n3 >>> 1;
            this.fetchActiveTokenListData();
            if (this.activeStartJoinIndex < n) {
                n2 = this.activeTokenListIndex + 1;
                continue;
            }
            if (this.activeStartJoinIndex > n) {
                n3 = this.activeTokenListIndex - 1;
                continue;
            }
            this.adjustJoinedOrSkipEmpty();
            return;
        }
        if (this.activeTokenListIndex != n3) {
            this.activeTokenListIndex = n3;
            this.fetchActiveTokenListData();
        }
    }

    private void adjustJoinedOrSkipEmpty() {
        if (this.activeStartJoinIndex == this.activeEndJoinIndex) {
            int n = this.activeTokenList.joinInfo.joinTokenLastPartShift();
            if (n > 0) {
                this.activeTokenListIndex += n;
                this.fetchActiveTokenListData();
            } else {
                while (this.activeTokenList.tokenCountCurrent() == 0) {
                    ++this.activeTokenListIndex;
                    this.fetchActiveTokenListData();
                    if (this.activeTokenListIndex != this.tokenListCount()) continue;
                    return;
                }
                if (this.activeStartJoinIndex == this.activeEndJoinIndex) {
                    n = this.activeTokenList.joinInfo.joinTokenLastPartShift();
                    this.activeTokenListIndex += n;
                    this.fetchActiveTokenListData();
                }
            }
        }
    }

    protected final void fetchActiveTokenListData() {
        if (this.activeTokenListIndex != this.tokenListCount()) {
            this.activeTokenList = this.tokenList(this.activeTokenListIndex);
            this.updateStatus(this.activeTokenList);
            this.activeStartJoinIndex = this.activeTokenList.joinInfo.joinTokenIndex();
            this.activeEndJoinIndex = this.activeStartJoinIndex + this.activeTokenList.joinTokenCount();
        } else {
            this.activeTokenList = null;
            this.activeStartJoinIndex = this.activeEndJoinIndex = this.tokenCount();
        }
    }

    protected void updateStatus(EmbeddedTokenList<T> embeddedTokenList) {
        embeddedTokenList.embeddingContainer().updateStatus();
    }

    private void init() {
        JoinLexerInputOperation joinLexerInputOperation = new JoinLexerInputOperation(this, 0, null, 0, ((EmbeddedTokenList)this.tokenListList.get(this.tokenListStartIndex)).startOffset());
        joinLexerInputOperation.init();
        int n = 0;
        int n2 = this.tokenListCount();
        if (n2 > 0) {
            Object object;
            int n3;
            AbstractToken abstractToken;
            boolean bl = LOG.isLoggable(Level.FINE);
            int n4 = 0;
            EmbeddedTokenList embeddedTokenList = this.initTokenList(n4, n);
            while ((abstractToken = joinLexerInputOperation.nextToken()) != null) {
                n3 = joinLexerInputOperation.skipTokenListCount();
                if (n3 > 0) {
                    while (--n3 >= 0) {
                        embeddedTokenList = this.initTokenList(++n4, n);
                    }
                    joinLexerInputOperation.clearSkipTokenListCount();
                }
                if (abstractToken.getClass() == JoinToken.class) {
                    object = (JoinToken)abstractToken;
                    List list = ((JoinToken)object).joinedParts();
                    int n5 = ((JoinToken)object).extraTokenListSpanCount();
                    int n6 = 0;
                    for (int i = 0; i < n5; ++i) {
                        embeddedTokenList.joinInfo.setJoinTokenLastPartShift(n5 - i);
                        if (embeddedTokenList.textLength() > 0) {
                            embeddedTokenList.addToken(list.get(n6++), 0, null);
                        }
                        embeddedTokenList = this.initTokenList(++n4, n);
                    }
                    abstractToken = list.get(n6);
                }
                embeddedTokenList.addToken(abstractToken, joinLexerInputOperation);
                if (bl) {
                    object = new StringBuilder(50);
                    ArrayUtilities.appendBracketedIndex((StringBuilder)object, (int)n, (int)2);
                    abstractToken.dumpInfo((StringBuilder)object, null, true, true, 0);
                    ((StringBuilder)object).append('\n');
                    LOG.fine(((StringBuilder)object).toString());
                }
                ++n;
            }
            if (bl) {
                LOG.fine("JoinTokenList created for " + this.tokenListList.languagePath() + " with " + n + " tokens\n");
            }
            while (++n4 < n2) {
                embeddedTokenList = this.initTokenList(n4, n);
            }
            for (n3 = n2 - 1; n3 >= 0; --n3) {
                object = (EmbeddedTokenList)this.tokenListList.get(this.tokenListStartIndex + n3);
                ((EmbeddedTokenList)object).trimStorageToSize();
                assert (((EmbeddedTokenList)object).joinInfo != null);
            }
        }
        this.base.joinTokenCount = n;
    }

    private EmbeddedTokenList<T> initTokenList(int n, int n2) {
        EmbeddedTokenList<T> embeddedTokenList = this.tokenList(n);
        if (embeddedTokenList.tokenCountCurrent() > 0) {
            embeddedTokenList.clear();
        }
        assert (embeddedTokenList.joinInfo == null) : "Non-null joinInfo in tokenList " + embeddedTokenList.dumpInfo(null) + "\n" + this.tokenListList;
        embeddedTokenList.joinInfo = new EmbeddedJoinInfo(this.base, n2, n);
        return embeddedTokenList;
    }

    public String checkConsistency() {
        String string = LexerUtilsConstants.checkConsistencyTokenList(this, false);
        if (string == null) {
            int n = 0;
            Token token = null;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.tokenListCount(); ++i) {
                int n4;
                EmbeddedTokenList<T> embeddedTokenList = this.tokenList(i);
                string = LexerUtilsConstants.checkConsistencyTokenList(embeddedTokenList, false);
                if (string != null) {
                    return string;
                }
                if (embeddedTokenList.joinInfo == null) {
                    return "Null joinInfo for ETL at token-list-index " + i;
                }
                if (n != embeddedTokenList.joinInfo.joinTokenIndex()) {
                    return "joinTokenIndex=" + n + " != etl.joinInfo.joinTokenIndex()=" + embeddedTokenList.joinInfo.joinTokenIndex() + " at token-list-index " + i;
                }
                if (i != embeddedTokenList.joinInfo.tokenListIndex()) {
                    return "token-list-index=" + i + " != etl.joinInfo.tokenListIndex()=" + embeddedTokenList.joinInfo.tokenListIndex();
                }
                int n5 = n4 = embeddedTokenList.tokenCount();
                if (n4 > 0) {
                    AbstractToken<T> abstractToken = embeddedTokenList.tokenOrEmbeddingUnsync(0).token();
                    int n6 = 0;
                    if (token != null) {
                        if (abstractToken.getClass() != PartToken.class) {
                            return "Unfinished joinToken at token-list-index=" + i;
                        }
                        if ((string = this.checkConsistencyJoinToken((JoinToken<T>)token, abstractToken, n3++, i)) != null) {
                            return string;
                        }
                        if (n3 == n2) {
                            token = null;
                        } else {
                            if (n4 > 1) {
                                return "More than one token and non-last part of unfinished join token at token-list-index " + i;
                            }
                            --n5;
                        }
                        n6 = 1;
                    }
                    if (n4 > n6) {
                        assert (token == null);
                        abstractToken = embeddedTokenList.tokenOrEmbeddingUnsync(n4 - 1).token();
                        if (abstractToken.getClass() == PartToken.class) {
                            --n5;
                            token = ((PartToken)abstractToken).joinToken();
                            n2 = ((JoinToken)token).joinedParts().size();
                            n3 = 0;
                            if (n2 < 2) {
                                return "joinedPartCount=" + n2 + " < 2";
                            }
                            if ((string = this.checkConsistencyJoinToken((JoinToken<T>)token, abstractToken, n3++, i)) != null) {
                                return string;
                            }
                        }
                    }
                    for (int j = n6; j < n5; ++j) {
                        if (embeddedTokenList.tokenOrEmbeddingUnsync(j).token().getClass() != PartToken.class) continue;
                        return "Inside PartToken at index " + j + "; joinTokenCount=" + n5;
                    }
                }
                if (n5 != embeddedTokenList.joinTokenCount()) {
                    return "joinTokenCount=" + n5 + " != etl.joinTokenCount()=" + embeddedTokenList.joinTokenCount() + " at token-list-index " + i;
                }
                n += n5;
            }
            if (token != null) {
                return "Unfinished join token at end";
            }
            if (n != this.base.joinTokenCount) {
                return "joinTokenCount=" + n + " != base.joinTokenCount=" + this.base.joinTokenCount;
            }
        }
        return string;
    }

    private String checkConsistencyJoinToken(JoinToken<T> joinToken, AbstractToken<T> abstractToken, int n, int n2) {
        PartToken partToken = (PartToken)abstractToken;
        if (joinToken.joinedParts().get(n) != abstractToken) {
            return "activeJoinToken.joinedParts().get(" + n + ") != token at token-list-index " + n2;
        }
        if (partToken.joinToken() != joinToken) {
            return "Invalid join token of part at partIndex " + n + " at token-list-index " + n2;
        }
        EmbeddedTokenList<T> embeddedTokenList = this.tokenList(n2);
        int n3 = embeddedTokenList.joinInfo.joinTokenLastPartShift();
        if (n3 < 0) {
            return "lps=" + n3 + " < 0";
        }
        if (n2 + n3 >= this.tokenListCount()) {
            return "Invalid lps=" + n3 + " at token-list-index " + n2 + "; tokenListCount=" + this.tokenListCount();
        }
        AbstractToken<T> abstractToken2 = this.tokenList(n2 + n3).tokenOrEmbeddingUnsync(0).token();
        if (abstractToken2.getClass() != PartToken.class) {
            return "Invalid lps: lastPart not PartToken " + abstractToken2.dumpInfo(null, null, true, true, 0) + " at token-list-index " + n2;
        }
        if (((JoinToken)((PartToken)abstractToken2).joinToken()).lastPart() != abstractToken2) {
            return "Invalid lps: Not last part " + abstractToken2.dumpInfo(null, null, true, true, 0) + " at token-list-index " + n2;
        }
        return null;
    }

    public StringBuilder dumpInfo(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(256);
        }
        int n = this.tokenListCount();
        int n2 = String.valueOf(n - 1).length();
        int n3 = this.activeTokenListIndex;
        this.setActiveTokenListIndex(0);
        for (int i = 0; i < n; ++i) {
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n2);
            this.tokenList(i).dumpInfo(stringBuilder);
            stringBuilder.append('\n');
        }
        this.setActiveTokenListIndex(n3);
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder = this.dumpInfo(stringBuilder);
        return LexerUtilsConstants.appendTokenList(stringBuilder, this).toString();
    }
}

