/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsElement;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstElement
extends JsElement {
    public static final Set<Modifier> NONE = EnumSet.noneOf(Modifier.class);
    public static final Set<Modifier> STATIC = EnumSet.of(Modifier.STATIC);
    public static final Set<Modifier> PRIVATE = EnumSet.of(Modifier.PRIVATE);
    public static final Set<Modifier> STATIC_PRIVATE = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC);
    protected List<AstElement> children;
    protected Node node;
    protected String name;
    protected String in;
    protected JsParseResult info;
    protected String signature;
    protected ElementKind kind;
    protected String type;
    protected Map<String, String> docProps;
    protected String fqn;
    protected Set<Modifier> modifiers;

    AstElement(JsParseResult jsParseResult, Node node) {
        this.info = jsParseResult;
        this.node = node;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getIn();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                stringBuilder.append(".");
            }
            stringBuilder.append(this.getName());
            this.signature = stringBuilder.toString();
        }
        return this.signature;
    }

    public Node getNode() {
        return this.node;
    }

    public Map<String, String> getDocProps() {
        return this.docProps;
    }

    @Override
    public String getFqn() {
        if (this.fqn == null) {
            assert (this.name != null);
            this.fqn = this.in != null && this.in.length() > 0 ? this.in + "." + this.name : this.name;
        }
        return this.fqn;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.fqn != null) {
                int n = this.fqn.lastIndexOf(46);
                if (n != -1) {
                    this.name = this.fqn.substring(n + 1);
                    this.in = this.fqn.substring(0, n);
                }
            } else if (this.node.getType() == 121) {
                Node node;
                if (this.node.hasChildren() && (node = this.node.getFirstChild()).getType() == 39) {
                    this.name = node.getString();
                }
            } else if (this.node.isStringNode()) {
                this.name = this.node.getString();
            } else if (this.node.getType() == 38 || this.node.getType() == 30) {
                this.name = AstUtilities.getCallName(this.node, false);
            }
        }
        return this.name;
    }

    @Override
    public String getIn() {
        if (this.in == null) {
            this.in = "";
        }
        return this.in;
    }

    void setKind(ElementKind elementKind) {
        this.kind = elementKind;
    }

    @Override
    public ElementKind getKind() {
        if (this.kind == null) {
            switch (this.node.getType()) {
                case 39: 
                case 49: 
                case 163: {
                    return ElementKind.VARIABLE;
                }
            }
            return ElementKind.OTHER;
        }
        return this.kind;
    }

    public List<AstElement> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return "JsElement:" + this.getName() + "(" + this.getKind() + ")";
    }

    public JsParseResult getParseResult() {
        return this.info;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.getName().startsWith("_")) {
                bl2 = true;
            }
            if (this.docProps != null) {
                if (this.docProps.containsKey("@deprecated")) {
                    bl = true;
                }
                if (this.docProps.containsKey("@private")) {
                    bl2 = true;
                }
                if (this.docProps.containsKey("@constructor")) {
                    bl3 = true;
                }
                if (this.docProps.containsKey("@return")) {
                    this.type = this.docProps.get("@return");
                }
                if (bl || bl2 || bl3) {
                    this.modifiers = EnumSet.noneOf(Modifier.class);
                    if (bl) {
                        this.modifiers.add(Modifier.DEPRECATED);
                    }
                    if (bl2) {
                        this.modifiers.add(Modifier.PRIVATE);
                    }
                    if (bl3) {
                        this.kind = ElementKind.CONSTRUCTOR;
                    }
                } else {
                    this.modifiers = NONE;
                }
            } else {
                this.modifiers = bl2 ? PRIVATE : NONE;
            }
        }
        return this.modifiers;
    }

    void markStatic() {
        this.getModifiers();
        if (this.modifiers == NONE) {
            this.modifiers = STATIC;
        } else {
            this.modifiers = EnumSet.copyOf(this.modifiers);
            this.modifiers.add(Modifier.STATIC);
        }
    }

    private void initDocProps(JsParseResult jsParseResult) {
        Map<String, String> map;
        if (this.node == null) {
            return;
        }
        TokenSequence<? extends JsCommentTokenId> tokenSequence = AstUtilities.getCommentFor(jsParseResult, this.node);
        if (tokenSequence != null && (map = JsCommentLexer.findFunctionTypes(tokenSequence)) != null) {
            this.docProps = map;
        }
    }

    public static AstElement createElement(JsParseResult jsParseResult, Node node, String string, String string2, JsAnalyzer.AnalysisResult analysisResult) {
        if (node.element != null) {
            node.element = null;
        }
        AstElement astElement = AstElement.getElement(jsParseResult, node);
        if ("Element.Methods".equals(string2)) {
            string2 = "Element";
        }
        astElement.name = string;
        astElement.in = string2;
        return astElement;
    }

    public static AstElement getElement(JsParseResult jsParseResult, Node node) {
        if (node.element != null) {
            return (AstElement)node.element;
        }
        switch (node.getType()) {
            case 108: {
                if (!(node instanceof FunctionNode)) break;
                FunctionAstElement functionAstElement = new FunctionAstElement(jsParseResult, (FunctionNode)node);
                super.initDocProps(jsParseResult);
                node.element = functionAstElement;
                return functionAstElement;
            }
        }
        AstElement astElement = new AstElement(jsParseResult, node);
        astElement.initDocProps(jsParseResult);
        node.element = astElement;
        return astElement;
    }

    void setType(String string) {
        this.type = string;
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.node.nodeType;
            if (this.node.nodeType == null) {
                this.getModifiers();
            }
        }
        return this.type;
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult parserResult) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        Element element = JsParser.resolveHandle(jsParseResult, this);
        if (element instanceof AstElement) {
            Node node = ((AstElement)element).getNode();
            if (node != null) {
                return LexUtilities.getLexerOffsets(jsParseResult, new OffsetRange(node.getSourceStart(), node.getSourceEnd()));
            }
            return OffsetRange.NONE;
        }
        if (element != null) {
            Logger.global.log(Level.WARNING, "Foreign element: " + element + " of type " + (element != null ? element.getClass().getName() : "null"));
        } else if (this.getNode() != null) {
            OffsetRange offsetRange = AstUtilities.getRange(this.getNode());
            if (offsetRange != OffsetRange.NONE) {
                JsParseResult jsParseResult2 = this.info;
                if (jsParseResult2 == null) {
                    jsParseResult2 = jsParseResult;
                }
                return LexUtilities.getLexerOffsets(jsParseResult2, offsetRange);
            }
            return OffsetRange.NONE;
        }
        return OffsetRange.NONE;
    }
}

