/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.j2ee.ddloaders.app.EarDataObject;
import org.openide.actions.OpenAction;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class EarDataNode
extends DataNode {
    private static final String DEPLOYMENT = "deployment";
    private EarDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;
    private Action[] filteredActions;

    public EarDataNode(EarDataObject earDataObject) {
        this(earDataObject, Children.LEAF);
    }

    public EarDataNode(EarDataObject earDataObject, Children children) {
        super((DataObject)earDataObject, children);
        this.dataObject = earDataObject;
        this.setIconBaseWithExtension(this.dataObject.getIconBaseForValidDocument());
        this.initListeners();
    }

    public Action[] getActions(boolean bl) {
        if (this.filteredActions == null) {
            Action[] actionArray = super.getActions(bl);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            SystemAction systemAction = SystemAction.get(OpenAction.class);
            for (int i = 0; i < actionArray.length; ++i) {
                if (actionArray[i] instanceof OpenAction || systemAction != null && actionArray[i] != null && systemAction.getValue("Name").equals(actionArray[i].getValue("Name"))) continue;
                arrayList.add(actionArray[i]);
            }
            this.filteredActions = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.filteredActions;
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("documentDTD".equals(propertyChangeEvent.getPropertyName())) {
                    EarDataNode.this.firePropertyChange(EarDataNode.PROPERTY_DOCUMENT_TYPE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
                if ("valid".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    EarDataNode.this.removePropertyChangeListener(EarDataNode.this.ddListener);
                }
                if ("documentValid".equals(propertyChangeEvent.getPropertyName())) {
                    if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                        EarDataNode.this.setIconBaseWithExtension(EarDataNode.this.dataObject.getIconBaseForValidDocument());
                    } else {
                        EarDataNode.this.setIconBaseWithExtension(EarDataNode.this.dataObject.getIconBaseForInvalidDocument());
                    }
                }
                if ("propertySets".equals(propertyChangeEvent.getPropertyName())) {
                    EarDataNode.this.firePropertySetsChange(null, null);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName(DEPLOYMENT);
        set.setDisplayName(NbBundle.getMessage(EarDataNode.class, (String)"PROP_deploymentSet"));
        set.setShortDescription(NbBundle.getMessage(EarDataNode.class, (String)"HINT_deploymentSet"));
        set.setValue("helpID", (Object)"TBD---Ludo ejbjar node");
        PropertySupport.ReadOnly readOnly = new PropertySupport.ReadOnly(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle(EarDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle(EarDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                return EarDataNode.this.dataObject.getApplication().getVersion();
            }
        };
        set.put((Node.Property)readOnly);
        sheet.put(set);
        return sheet;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("TBD ejbjar file");
    }
}

