/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.libraries;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyIO;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) {
        RubyClass rubyClass = ruby.getIO();
        rubyClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        try {
            OpenFile openFile = rubyIO.getOpenFile();
            ChannelDescriptor channelDescriptor = openFile.getMainStream().getDescriptor();
            if (!channelDescriptor.isOpen() || !openFile.getMainStream().getModes().isReadable() || openFile.getMainStream().feof()) {
                return threadContext.getRuntime().getFalse();
            }
            int n = openFile.getMainStream().ready();
            if (n > 0) {
                return threadContext.getRuntime().newFixnum(n);
            }
        }
        catch (Exception exception) {
            return threadContext.getRuntime().getFalse();
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject io_wait(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        try {
            OpenFile openFile = rubyIO.getOpenFile();
            ChannelDescriptor channelDescriptor = openFile.getMainStream().getDescriptor();
            if (openFile.getMainStream().feof()) {
                return threadContext.getRuntime().getNil();
            }
            openFile.getMainStream().waitUntilReady();
        }
        catch (Exception exception) {
            return threadContext.getRuntime().getNil();
        }
        return iRubyObject;
    }
}

