/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class JavaMethod
extends DynamicMethod
implements JumpTarget,
Cloneable {
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes;
    private String javaName;
    private boolean isSingleton;
    protected StaticScope staticScope;

    public JavaMethod(RubyModule rubyModule, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.FRAME_ONLY);
        this.staticScope = null;
    }

    public JavaMethod(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
        super(rubyModule, visibility, callConfiguration);
        this.staticScope = staticScope;
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    public JavaMethod(RubyModule rubyModule, Visibility visibility, int n) {
        super(rubyModule, visibility, CallConfiguration.FRAME_ONLY);
        this.staticScope = null;
    }

    protected JavaMethod() {
    }

    public void init(RubyModule rubyModule, Arity arity, Visibility visibility, StaticScope staticScope, CallConfiguration callConfiguration) {
        this.staticScope = staticScope;
        this.arity = arity;
        this.arityValue = arity.getValue();
        super.init(rubyModule, visibility, callConfiguration);
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public DynamicMethod dup() {
        try {
            JavaMethod javaMethod = (JavaMethod)this.clone();
            return javaMethod;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected final void preFrameAndScope(ThreadContext threadContext, IRubyObject iRubyObject, String string, Block block) {
        threadContext.preMethodFrameAndScope(this.implementationClass, string, iRubyObject, block, this.staticScope);
    }

    protected final void preFrameOnly(ThreadContext threadContext, IRubyObject iRubyObject, String string, Block block) {
        threadContext.preMethodFrameOnly(this.implementationClass, string, iRubyObject, block);
    }

    protected final void preScopeOnly(ThreadContext threadContext) {
        threadContext.preMethodScopeOnly(this.implementationClass, this.staticScope);
    }

    protected final void preBacktraceOnly(ThreadContext threadContext, String string) {
        threadContext.preMethodBacktraceOnly(string);
    }

    protected final void preBacktraceAndScope(ThreadContext threadContext, String string) {
        threadContext.preMethodBacktraceAndScope(string, this.implementationClass, this.staticScope);
    }

    protected final void postFrameAndScope(ThreadContext threadContext) {
        threadContext.postMethodFrameAndScope();
    }

    protected final void postFrameOnly(ThreadContext threadContext) {
        threadContext.postMethodFrameOnly();
    }

    protected final void postScopeOnly(ThreadContext threadContext) {
        threadContext.postMethodScopeOnly();
    }

    protected final void postBacktraceOnly(ThreadContext threadContext) {
        threadContext.postMethodBacktraceOnly();
    }

    protected final void postBacktraceAndScope(ThreadContext threadContext) {
        threadContext.postMethodBacktraceAndScope();
    }

    protected final void callTrace(ThreadContext threadContext, String string) {
        threadContext.trace(RubyEvent.C_CALL, string, this.getImplementationClass());
    }

    protected final void returnTrace(ThreadContext threadContext, String string) {
        threadContext.trace(RubyEvent.C_CALL, string, this.getImplementationClass());
    }

    public void setArity(Arity arity) {
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    public Arity getArity() {
        return this.arity;
    }

    @Deprecated
    public void setArgumentTypes(Class[] classArray) {
        this.argumentTypes = classArray;
    }

    @Deprecated
    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean bl) {
        this.isSingleton = bl;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isNative() {
        return true;
    }

    public static abstract class JavaMethodThreeBlock
    extends JavaMethod {
        public JavaMethodThreeBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodThreeBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodThreeBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 3) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
        }

        public Arity getArity() {
            return Arity.THREE_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodThree
    extends JavaMethod {
        public JavaMethodThree(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodThree(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodThree(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 3) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
        }

        public Arity getArity() {
            return Arity.THREE_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodTwoBlock
    extends JavaMethod {
        public JavaMethodTwoBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodTwoBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodTwoBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 2) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], block);
        }

        public Arity getArity() {
            return Arity.TWO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodTwoOrThree
    extends JavaMethod {
        public JavaMethodTwoOrThree(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodTwoOrThree(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodTwoOrThree(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
                case 3: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 2, 3);
            return null;
        }
    }

    public static abstract class JavaMethodTwo
    extends JavaMethod {
        public JavaMethodTwo(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodTwo(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodTwo(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 2) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
        }

        public Arity getArity() {
            return Arity.TWO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThreeBlock
    extends JavaMethod {
        public JavaMethodOneOrTwoOrThreeBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOneOrTwoOrThreeBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    throw threadContext.getRuntime().newArgumentError(0, 1);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], block);
                }
                case 3: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
                }
            }
            throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 3);
        }
    }

    public static abstract class JavaMethodOneOrTwoBlock
    extends JavaMethod {
        public JavaMethodOneOrTwoBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOneOrTwoBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOneOrTwoBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], block);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
            return null;
        }
    }

    public static abstract class JavaMethodOneBlock
    extends JavaMethod {
        public JavaMethodOneBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOneBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOneBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 1) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodOneOrTwoOrThree
    extends JavaMethod {
        public JavaMethodOneOrTwoOrThree(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOneOrTwoOrThree(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
                case 3: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 3);
            return null;
        }
    }

    public static abstract class JavaMethodOneOrTwo
    extends JavaMethod {
        public JavaMethodOneOrTwo(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOneOrTwo(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOneOrTwo(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 1, 2);
            return null;
        }
    }

    public static abstract class JavaMethodOne
    extends JavaMethod {
        public JavaMethodOne(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodOne(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodOne(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 1) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    public static abstract class JavaMethodZeroBlock
    extends JavaMethod {
        public JavaMethodZeroBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 0) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, block);
        }

        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrNBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7, Block var8);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, block);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], block);
                }
                case 3: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 3);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThreeOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThreeOrN(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
                case 3: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
                }
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrThree
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrThree(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, IRubyObject var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
                case 3: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 3);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrNBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, block);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6, Block var7);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, block);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1], block);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 2);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwoOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwoOrN(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwoOrN(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4});
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray);
        }
    }

    public static abstract class JavaMethodZeroOrOneOrTwo
    extends JavaMethod {
        public JavaMethodZeroOrOneOrTwo(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrTwo(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, IRubyObject var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
                case 2: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], iRubyObjectArray[1]);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 2);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrNBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneOrNBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrNBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3}, block);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4}, block);
        }
    }

    public static abstract class JavaMethodZeroOrOneBlock
    extends JavaMethod {
        public JavaMethodZeroOrOneBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, Block var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5, Block var6);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, block);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0], block);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 1);
            return null;
        }
    }

    public static abstract class JavaMethodZeroOrOneOrN
    extends JavaMethod {
        public JavaMethodZeroOrOneOrN(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOneOrN(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOneOrN(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3});
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            return this.call(threadContext, iRubyObject, rubyModule, string, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4});
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
            }
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray);
        }
    }

    public static abstract class JavaMethodZeroOrOne
    extends JavaMethod {
        public JavaMethodZeroOrOne(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZeroOrOne(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZeroOrOne(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            switch (iRubyObjectArray.length) {
                case 0: {
                    return this.call(threadContext, iRubyObject, rubyModule, string);
                }
                case 1: {
                    return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray[0]);
                }
            }
            Arity.raiseArgumentError(threadContext.getRuntime(), iRubyObjectArray.length, 0, 1);
            return null;
        }
    }

    public static abstract class JavaMethodZero
    extends JavaMethod {
        public JavaMethodZero(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodZero(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodZero(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            if (iRubyObjectArray.length != 0) {
                throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 0);
            }
            return this.call(threadContext, iRubyObject, rubyModule, string);
        }

        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    public static abstract class JavaMethodNoBlock
    extends JavaMethod {
        public JavaMethodNoBlock(RubyModule rubyModule, Visibility visibility) {
            super(rubyModule, visibility);
        }

        public JavaMethodNoBlock(RubyModule rubyModule, Visibility visibility, CallConfiguration callConfiguration, StaticScope staticScope, Arity arity) {
            super(rubyModule, visibility, callConfiguration, staticScope, arity);
        }

        public JavaMethodNoBlock(RubyModule rubyModule, Visibility visibility, int n) {
            super(rubyModule, visibility, n);
        }

        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5);

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
            return this.call(threadContext, iRubyObject, rubyModule, string, iRubyObjectArray);
        }
    }
}

