/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyString;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.Invoker;
import org.jruby.nb.ext.ffi.NativeType;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.ext.ffi.jna.FunctionInvoker;
import org.jruby.nb.ext.ffi.jna.Invocation;
import org.jruby.nb.ext.ffi.jna.JNAInvoker;
import org.jruby.nb.ext.ffi.jna.JNAMemory;
import org.jruby.nb.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.nb.ext.ffi.jna.Marshaller;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class JNAProvider
extends FFIProvider {
    JNAProvider(Ruby ruby) {
        super(ruby);
    }

    public final Invoker createInvoker(Ruby ruby, String string, String string2, NativeType nativeType, NativeType[] nativeTypeArray, String string3) {
        Function function = NativeLibrary.getInstance((String)string).getFunction(string2, "stdcall".equals(string3) ? 1 : 0);
        FunctionInvoker functionInvoker = this.getFunctionInvoker(nativeType);
        Marshaller[] marshallerArray = new Marshaller[nativeTypeArray.length];
        for (int i = 0; i < marshallerArray.length; ++i) {
            marshallerArray[i] = JNAProvider.getMarshaller(nativeTypeArray[i]);
        }
        return new JNAInvoker(ruby, function, functionInvoker, marshallerArray);
    }

    public int getLastError() {
        return Native.getLastError();
    }

    public void setLastError(int n) {
        Native.setLastError((int)n);
    }

    private FunctionInvoker getFunctionInvoker(NativeType nativeType) {
        switch (nativeType) {
            case VOID: {
                return VoidInvoker.INSTANCE;
            }
            case POINTER: {
                return PointerInvoker.INSTANCE;
            }
            case INT8: 
            case INT16: 
            case INT32: {
                return Signed32Invoker.INSTANCE;
            }
            case UINT8: 
            case UINT16: 
            case UINT32: {
                return Unsigned32Invoker.INSTANCE;
            }
            case INT64: 
            case UINT64: {
                return Signed64Invoker.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().addressSize() == 32 ? Signed32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().addressSize() == 32 ? Unsigned32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case FLOAT32: {
                return Float32Invoker.INSTANCE;
            }
            case FLOAT64: {
                return Float64Invoker.INSTANCE;
            }
            case STRING: 
            case RBXSTRING: {
                return StringInvoker.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + (Object)((Object)nativeType));
    }

    private static final Marshaller getMarshaller(NativeType nativeType) {
        switch (nativeType) {
            case INT8: {
                return Signed8Marshaller.INSTANCE;
            }
            case UINT8: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case INT16: {
                return Signed16Marshaller.INSTANCE;
            }
            case UINT16: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT32: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT32: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case INT64: {
                return Signed64Marshaller.INSTANCE;
            }
            case UINT64: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case FLOAT32: {
                return Float32Marshaller.INSTANCE;
            }
            case FLOAT64: {
                return Float64Marshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
            case RBXSTRING: {
                return RbxStringMarshaller.INSTANCE;
            }
            case POINTER: {
                return PointerMarshaller.INSTANCE;
            }
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return BufferMarshaller.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + (Object)((Object)nativeType));
    }

    private static final class BufferMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new BufferMarshaller();

        private BufferMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            if (iRubyObject instanceof JNAMemory) {
                return ((JNAMemory)((Object)iRubyObject)).getNativeMemory();
            }
            if (iRubyObject.isNil()) {
                return Pointer.NULL;
            }
            if (iRubyObject instanceof RubyString) {
                ByteList byteList = ((RubyString)iRubyObject).getByteList();
                return ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.realSize);
            }
            return Util.convertParameter(iRubyObject, Object.class);
        }
    }

    private static final class RbxStringMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new RbxStringMarshaller();

        private RbxStringMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            final ByteList byteList = iRubyObject.asString().getByteList();
            final int n = byteList.length();
            final Memory memory = new Memory((long)(n + 1));
            memory.write(0L, byteList.unsafeBytes(), byteList.begin(), n);
            memory.setByte((long)byteList.length(), (byte)0);
            invocation.addPostInvoke(new Runnable(){

                public void run() {
                    memory.read(0L, byteList.unsafeBytes(), byteList.begin(), n);
                }
            });
            return memory;
        }
    }

    private static final class StringMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            RubyString rubyString = iRubyObject.asString();
            ByteList byteList = rubyString.getByteList();
            Memory memory = new Memory((long)(byteList.length() + 1));
            memory.write(0L, byteList.unsafeBytes(), byteList.begin(), byteList.length());
            memory.setByte((long)byteList.length(), (byte)0);
            return memory;
        }
    }

    private static final class PointerMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new PointerMarshaller();

        private PointerMarshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            if (iRubyObject instanceof JNAMemory) {
                return ((JNAMemory)((Object)iRubyObject)).getNativeMemory();
            }
            if (iRubyObject.isNil()) {
                return Pointer.NULL;
            }
            if (iRubyObject instanceof RubyString) {
                final ByteList byteList = ((RubyString)iRubyObject).getByteList();
                final int n = byteList.length();
                final Memory memory = new Memory((long)n);
                memory.write(0L, byteList.unsafeBytes(), byteList.begin(), n);
                invocation.addPostInvoke(new Runnable(){

                    public void run() {
                        memory.read(0L, byteList.unsafeBytes(), byteList.begin(), n);
                    }
                });
                return memory;
            }
            return Util.convertParameter(iRubyObject, Pointer.class);
        }
    }

    private static final class Float64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Float64Marshaller();

        private Float64Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Util.doubleValue(iRubyObject);
        }
    }

    private static final class Float32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Float32Marshaller();

        private Float32Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Float.valueOf(Util.floatValue(iRubyObject));
        }
    }

    private static final class Unsigned64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned64Marshaller();

        private Unsigned64Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Util.uint64Value(iRubyObject);
        }
    }

    private static final class Signed64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed64Marshaller();

        private Signed64Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Util.int64Value(iRubyObject);
        }
    }

    private static final class Unsigned32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned32Marshaller();

        private Unsigned32Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return (int)Util.uint32Value(iRubyObject);
        }
    }

    private static final class Signed32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed32Marshaller();

        private Signed32Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Util.int32Value(iRubyObject);
        }
    }

    private static final class Unsigned16Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned16Marshaller();

        private Unsigned16Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return (short)Util.uint16Value(iRubyObject);
        }
    }

    private static final class Signed16Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed16Marshaller();

        private Signed16Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Util.int16Value(iRubyObject);
        }
    }

    private static final class Unsigned8Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned8Marshaller();

        private Unsigned8Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return (byte)Util.uint8Value(iRubyObject);
        }
    }

    private static final class Signed8Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed8Marshaller();

        private Signed8Marshaller() {
        }

        public final Object marshal(Invocation invocation, IRubyObject iRubyObject) {
            return Util.int8Value(iRubyObject);
        }
    }

    private static final class StringInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new StringInvoker();

        private StringInvoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            Pointer pointer = function.invokePointer(objectArray);
            if (pointer == null) {
                return ruby.getNil();
            }
            int n = (int)pointer.indexOf(0L, (byte)0);
            if (n == 0) {
                return RubyString.newEmptyString(ruby);
            }
            ByteList byteList = new ByteList(n);
            byteList.length(n);
            pointer.read(0L, byteList.unsafeBytes(), byteList.begin(), n);
            return RubyString.newString(ruby, byteList);
        }
    }

    private static final class PointerInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new PointerInvoker();

        private PointerInvoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            return new JNAMemoryPointer(ruby, function.invokePointer(objectArray));
        }
    }

    private static final class Float64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Float64Invoker();

        private Float64Invoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            return ruby.newFloat(function.invokeDouble(objectArray));
        }
    }

    private static final class Float32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Float32Invoker();

        private Float32Invoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            return ruby.newFloat(function.invokeFloat(objectArray));
        }
    }

    private static final class Signed64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed64Invoker();

        private Signed64Invoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            return ruby.newFixnum(function.invokeLong(objectArray));
        }
    }

    private static final class Unsigned32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned32Invoker();

        private Unsigned32Invoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            long l = function.invokeInt(objectArray);
            return ruby.newFixnum(l < 0L ? (l & Integer.MAX_VALUE) + 0x80000000L : l);
        }
    }

    private static final class Signed32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed32Invoker();

        private Signed32Invoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            return ruby.newFixnum(function.invokeInt(objectArray));
        }
    }

    private static final class VoidInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new VoidInvoker();

        private VoidInvoker() {
        }

        public final IRubyObject invoke(Ruby ruby, Function function, Object[] objectArray) {
            function.invoke(objectArray);
            return ruby.getNil();
        }
    }
}

