/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyString;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.environment.IOSEnvironmentReader;
import org.jruby.nb.environment.OSEnvironmentReaderExcepton;
import org.jruby.nb.environment.OSEnvironmentReaderFromJava5SystemGetenv;
import org.jruby.nb.environment.OSEnvironmentReaderFromRuntimeExec;

public class OSEnvironment {
    void handleException(Exception exception) {
        throw (OSEnvironmentReaderExcepton)new OSEnvironmentReaderExcepton().initCause(exception);
    }

    public Map getEnvironmentVariableMap(Ruby ruby) {
        Map map = null;
        if (ruby.getInstanceConfig().getEnvironment() != null) {
            return OSEnvironment.getAsMapOfRubyStrings(ruby, ruby.getInstanceConfig().getEnvironment().entrySet());
        }
        if (Ruby.isSecurityRestricted()) {
            map = new HashMap();
        } else {
            IOSEnvironmentReader iOSEnvironmentReader;
            String string = System.getProperty("jruby.env.method");
            if (string == null || string.length() < 1) {
                iOSEnvironmentReader = OSEnvironment.getAccessibleOSEnvironment(ruby, OSEnvironmentReaderFromJava5SystemGetenv.class.getName());
                if (iOSEnvironmentReader == null) {
                    iOSEnvironmentReader = OSEnvironment.getAccessibleOSEnvironment(ruby, OSEnvironmentReaderFromRuntimeExec.class.getName());
                }
            } else {
                ruby.getWarnings().warn(IRubyWarnings.ID.ENV_VARS_FROM_CLI_METHOD, "Getting environment variables using command line defined method: " + string, string);
                iOSEnvironmentReader = OSEnvironment.getAccessibleOSEnvironment(ruby, string);
            }
            map = null;
            if (iOSEnvironmentReader != null) {
                Map map2 = null;
                map2 = iOSEnvironmentReader.getVariables(ruby);
                map = OSEnvironment.getAsMapOfRubyStrings(ruby, map2.entrySet());
            }
        }
        return map;
    }

    public Map getSystemPropertiesMap(Ruby ruby) {
        if (Ruby.isSecurityRestricted()) {
            return new HashMap();
        }
        return OSEnvironment.getAsMapOfRubyStrings(ruby, System.getProperties().entrySet());
    }

    private static IOSEnvironmentReader getAccessibleOSEnvironment(Ruby ruby, String string) {
        IOSEnvironmentReader iOSEnvironmentReader = null;
        try {
            iOSEnvironmentReader = (IOSEnvironmentReader)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, exception.getMessage(), new Object[0]);
        }
        if (iOSEnvironmentReader != null && iOSEnvironmentReader.isAccessible(ruby)) {
            return iOSEnvironmentReader;
        }
        return null;
    }

    private static Map getAsMapOfRubyStrings(Ruby ruby, Set set) {
        HashMap<RubyString, RubyString> hashMap = new HashMap<RubyString, RubyString>();
        for (Map.Entry entry : set) {
            hashMap.put(ruby.newString(entry.getKey().toString()), ruby.newString(entry.getValue().toString()));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getVariablesFrom(BufferedReader bufferedReader) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(61);
                if (n < 1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                hashMap.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            hashMap = null;
            this.handleException(iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                hashMap = null;
                this.handleException(iOException);
            }
        }
        return hashMap;
    }
}

