/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.monitor.client.ClientDisplay;
import org.netbeans.modules.web.monitor.client.ContextDisplay;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.CookieDisplay;
import org.netbeans.modules.web.monitor.client.CurrNode;
import org.netbeans.modules.web.monitor.client.HeaderDisplay;
import org.netbeans.modules.web.monitor.client.NavigateNode;
import org.netbeans.modules.web.monitor.client.NestedNode;
import org.netbeans.modules.web.monitor.client.RequestDisplay;
import org.netbeans.modules.web.monitor.client.SavedNode;
import org.netbeans.modules.web.monitor.client.SessionDisplay;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class TransactionView
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener,
ChangeListener {
    private static transient TransactionView instance = null;
    private static transient Controller controller = null;
    private transient JToggleButton timeAButton;
    private transient JToggleButton timeDButton;
    private transient JToggleButton alphaButton;
    private transient JToggleButton timestampButton;
    private transient Dimension logD = new Dimension(250, 400);
    private transient Dimension dataD = new Dimension(500, 400);
    private transient Dimension tabD = new Dimension(500, 472);
    private static transient ExplorerManager mgr = null;
    private transient JPanel logPanel = null;
    private transient JPanel dataPanel = null;
    private transient JSplitPane splitPanel = null;
    private transient double dividerRatio = 0.35;
    private transient BeanTreeView tree = null;
    private transient AbstractNode selected = null;
    private transient RequestDisplay requestDisplay = null;
    private transient CookieDisplay cookieDisplay = null;
    private transient SessionDisplay sessionDisplay = null;
    private transient ContextDisplay contextDisplay = null;
    private transient ClientDisplay clientDisplay = null;
    private transient HeaderDisplay headerDisplay = null;
    boolean fontChanged = true;
    private int displayType = 0;
    private boolean openedOnceAlready = false;

    public boolean requestFocusInWindow() {
        if (this.tree != null) {
            return this.tree.requestFocusInWindow();
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        String string = NbBundle.getBundle((Class)TransactionView.class).getString("MON_Transaction_View_F1_Help_ID");
        return new HelpCtx(string);
    }

    private TransactionView() {
        this.setIcon(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/menuitem.gif")).getImage());
        this.setToolTipText(NbBundle.getMessage((Class)TransactionView.class, (String)"MON_Window_Tooltip"));
        controller = Controller.getInstance();
        this.initialize();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)TransactionView.class).getString("ACS_MON_monitorDesc"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)TransactionView.class).getString("ACS_MON_monitorName"));
    }

    static synchronized TransactionView getInstance() {
        if (instance == null) {
            instance = new TransactionView();
        }
        return instance;
    }

    private void initialize() {
        mgr = new ExplorerManager();
        mgr.addPropertyChangeListener((PropertyChangeListener)this);
        mgr.setRootContext((Node)controller.getRoot());
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)mgr, (ActionMap)this.getActionMap()));
        this.setLayout(new BorderLayout());
        this.tree = new BeanTreeView();
        this.tree.setDefaultActionAllowed(true);
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)TransactionView.class).getString("ACS_MON_treeName"));
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)TransactionView.class).getString("ACS_MON_treeDesc"));
        this.createLogPanel();
        this.createDataPanel();
        this.splitPanel = new JSplitPane(1, this.logPanel, this.dataPanel);
        this.splitPanel.setDividerLocation((int)this.logD.getWidth());
        this.splitPanel.setResizeWeight(this.dividerRatio);
        this.splitPanel.setDividerSize(1);
        this.splitPanel.setOneTouchExpandable(true);
        this.add(this.splitPanel);
        this.setName(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Title"));
    }

    void openTransactionNodes() {
        OpenTransactionNodesRequest openTransactionNodesRequest = new OpenTransactionNodesRequest();
        RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)openTransactionNodesRequest, (int)500);
    }

    public int getPersistenceType() {
        return 1;
    }

    void selectNode(Node node) {
        try {
            Node[] nodeArray;
            if (node != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = node;
            } else {
                nodeArray = new Node[]{};
            }
            mgr.setSelectedNodes(nodeArray);
        }
        catch (Exception exception) {
            Logger.getLogger(TransactionView.class.getName()).log(Level.INFO, "selectNode", exception);
        }
    }

    public void open() {
        super.open();
        if (!this.openedOnceAlready) {
            this.openedOnceAlready = true;
            controller.getTransactions();
            this.openTransactionNodes();
        }
        controller.checkServer(false);
    }

    public boolean isInitialized() {
        return this.openedOnceAlready;
    }

    protected void updateTitle() {
        this.setName(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Title"));
    }

    public Object writeReplace() throws ObjectStreamException {
        return new ResolvableHelper();
    }

    private void createLogPanel() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(4, 4, 4, 4)));
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/update.gif")));
        jButton.setToolTipText(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Reload_all_17"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                controller.getTransactions();
            }
        });
        this.timeAButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/timesortA.gif")), false);
        this.timeAButton.setToolTipText(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Order_transactions_15"));
        this.timeAButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!((JToggleButton)actionEvent.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeDButton.setSelected(false);
                TransactionView.this.alphaButton.setSelected(false);
                Controller controller = controller;
                Controller controller2 = controller;
                controller2.getClass();
                controller.setComparator(controller2.new Controller.CompTime(false));
            }
        });
        this.timeDButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/timesortB.gif")), true);
        this.timeDButton.setToolTipText(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Order_transactions_16"));
        this.timeDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!((JToggleButton)actionEvent.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeAButton.setSelected(false);
                TransactionView.this.alphaButton.setSelected(false);
                Controller controller = controller;
                Controller controller2 = controller;
                controller2.getClass();
                controller.setComparator(controller2.new Controller.CompTime(true));
            }
        });
        this.alphaButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/a2z.gif")), false);
        this.alphaButton.setToolTipText(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Order_transactions_14"));
        this.alphaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!((JToggleButton)actionEvent.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeAButton.setSelected(false);
                TransactionView.this.timeDButton.setSelected(false);
                controller.setComparator(controller.new Controller.CompAlpha());
            }
        });
        this.timestampButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/timestamp.gif")), TransactionNode.showTimeStamp());
        this.timestampButton.setToolTipText(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Show_time_25"));
        this.timestampButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransactionNode.toggleTimeStamp();
                controller.updateNodeNames();
            }
        });
        jToolBar.add(jButton);
        jToolBar.add(this.timeDButton);
        jToolBar.add(this.timeAButton);
        jToolBar.add(this.alphaButton);
        JPanel jPanel = new JPanel(){

            public float getAlignmentX() {
                return 0.0f;
            }

            public float getAlignmentY() {
                return 0.0f;
            }
        };
        jPanel.setMaximumSize(new Dimension(10, 10));
        jToolBar.add(jPanel);
        jToolBar.add(this.timestampButton);
        this.logPanel = new JPanel();
        this.logPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", jToolBar);
        jPanel2.add("Center", (Component)this.tree);
        this.logPanel.add("Center", jPanel2);
        this.logPanel.setPreferredSize(this.logD);
    }

    private void createDataPanel() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)TransactionView.class).getString("ACS_MON_Transaction_dataName"));
        jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)TransactionView.class).getString("ACS_MON_Transaction_dataDesc"));
        jTabbedPane.setPreferredSize(this.tabD);
        jTabbedPane.setMaximumSize(this.tabD);
        FontMetrics fontMetrics = this.getFontMetrics(jTabbedPane.getFont());
        int n = fontMetrics.getHeight();
        this.requestDisplay = new RequestDisplay();
        JScrollPane jScrollPane = new JScrollPane(this.requestDisplay);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
        jTabbedPane.addTab(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Request_19_Tab"), jScrollPane);
        this.cookieDisplay = new CookieDisplay();
        jScrollPane = new JScrollPane(this.cookieDisplay);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
        jTabbedPane.addTab(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Cookies_4_Tab"), jScrollPane);
        this.sessionDisplay = new SessionDisplay();
        jScrollPane = new JScrollPane(this.sessionDisplay);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
        jTabbedPane.addTab(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Session_24"), jScrollPane);
        this.contextDisplay = new ContextDisplay();
        jScrollPane = new JScrollPane(this.contextDisplay);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
        jTabbedPane.addTab(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Context_23"), jScrollPane);
        this.clientDisplay = new ClientDisplay();
        jScrollPane = new JScrollPane(this.clientDisplay);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
        jTabbedPane.addTab(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Client_Server"), jScrollPane);
        this.headerDisplay = new HeaderDisplay();
        jScrollPane = new JScrollPane(this.headerDisplay);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(n);
        jTabbedPane.addTab(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Header_19"), jScrollPane);
        jTabbedPane.addChangeListener(this);
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.add("Center", jTabbedPane);
        this.dataPanel.setPreferredSize(this.dataD);
    }

    void displayTransaction(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof TransactionNode || node instanceof NestedNode) {
            try {
                this.selected = (AbstractNode)node;
            }
            catch (ClassCastException classCastException) {
                this.selected = null;
                this.selectNode(null);
            }
        } else {
            this.selected = null;
            this.selectNode(null);
        }
        this.showData();
    }

    void saveTransaction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        controller.saveTransaction(nodeArray);
        this.selected = null;
        this.selectNode(null);
        this.showData();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setName(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Title"));
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        this.displayType = jTabbedPane.getSelectedIndex();
        this.showData();
    }

    void showData() {
        DataRecord dataRecord = null;
        try {
            if (this.selected != null) {
                dataRecord = controller.getDataRecord(this.selected);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.displayType == 0) {
            this.requestDisplay.setData(dataRecord);
        } else if (this.displayType == 1) {
            this.cookieDisplay.setData(dataRecord);
        } else if (this.displayType == 2) {
            this.sessionDisplay.setData(dataRecord);
        } else if (this.displayType == 3) {
            this.contextDisplay.setData(dataRecord);
        } else if (this.displayType == 4) {
            this.clientDisplay.setData(dataRecord);
        } else if (this.displayType == 5) {
            this.headerDisplay.setData(dataRecord);
        }
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setName(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Title"));
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes") && propertyChangeEvent.getNewValue() instanceof Node[]) {
            try {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                if (nodeArray.length == 1) {
                    this.displayTransaction(nodeArray[0]);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(TransactionView.class.getName()).log(Level.INFO, "", exception);
                this.selected = null;
                this.showData();
                return;
            }
        }
    }

    void blank() {
        this.selected = null;
        this.selectNode(null);
        this.showData();
    }

    public void paint(Graphics graphics) {
        if (this.fontChanged) {
            super.paint(graphics);
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        this.fontChanged = false;
        double d = (double)fontMetrics.stringWidth(NbBundle.getBundle((Class)TransactionView.class).getString("MON_Transactions_27")) * 1.1;
        if (d > this.logD.getWidth()) {
            double d2 = d / this.logD.getWidth();
            this.logD.setSize(d, d2 * this.logD.getHeight());
            this.dataD.setSize(d2 * this.dataD.getWidth(), d2 * this.dataD.getHeight());
        }
        this.logPanel.setPreferredSize(this.logD);
        this.dataPanel.setPreferredSize(this.dataD);
        this.splitPanel.resetToPreferredSizes();
        this.splitPanel.setDividerLocation((int)this.logD.getWidth());
        try {
            Container container = this.getParent();
            while (true) {
                if (container instanceof JFrame) {
                    JFrame jFrame = (JFrame)container;
                    jFrame.pack();
                    break;
                }
                container = container.getParent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String preferredID() {
        return "TransactionView";
    }

    void setTimestampButtonSelected(boolean bl) {
        this.timestampButton.setSelected(bl);
    }

    boolean isTimestampButtonSelected() {
        return this.timestampButton.isSelected();
    }

    void addTimestampButtonActionListener(ActionListener actionListener) {
        this.timestampButton.addActionListener(actionListener);
    }

    boolean isAscButtonSelected() {
        return this.timeAButton.isSelected();
    }

    boolean isDescButtonSelected() {
        return this.timeDButton.isSelected();
    }

    boolean isAlphButtonSelected() {
        return this.alphaButton.isSelected();
    }

    void toggleTaskbarButtons(boolean bl, boolean bl2, boolean bl3) {
        this.timeAButton.setSelected(bl);
        this.timeDButton.setSelected(bl2);
        this.alphaButton.setSelected(bl3);
    }

    public ExplorerManager getExplorerManager() {
        return mgr;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)mgr, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)mgr, (boolean)false);
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 1234546018839457544L;

        Object readResolve() {
            Controller.getInstance().getTransactions();
            return TransactionView.getInstance();
        }
    }

    class OpenTransactionNodesRequest
    implements Runnable {
        OpenTransactionNodesRequest() {
        }

        public void run() {
            this.openTransactionNodes();
        }

        void openTransactionNodes() {
            NavigateNode navigateNode = controller.getRoot();
            Children children = navigateNode.getChildren();
            Node[] nodeArray = children.getNodes();
            CurrNode currNode = (CurrNode)nodeArray[0];
            SavedNode savedNode = (SavedNode)nodeArray[1];
            Children children2 = currNode.getChildren();
            Node[] nodeArray2 = children2.getNodes();
            int n = nodeArray2.length;
            if (n > 0) {
                int n2 = 0;
                if (TransactionView.this.timeAButton.isSelected()) {
                    n2 = n - 1;
                }
                TransactionView.this.selectNode(nodeArray2[n2]);
            } else {
                Children children3 = savedNode.getChildren();
                Node[] nodeArray3 = children3.getNodes();
                int n3 = nodeArray3.length;
                if (n3 > 0) {
                    TransactionView.this.selectNode(nodeArray3[0]);
                }
            }
        }
    }
}

