/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.LocalPathCell;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsWebAdvanced
extends JPanel {
    private static final long serialVersionUID = 7842376554376847L;
    static final String DEFAULT_LOCAL_PATH = "";
    static final int COLUMN_REMOTE_PATH = 0;
    static final int COLUMN_LOCAL_PATH = 1;
    final PhpProject project;
    private final PathMappingTableModel pathMappingTableModel;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport;
    private JRadioButton askUrlRadioButton;
    private ButtonGroup debugUrlButtonGroup;
    private JLabel debugUrlLabel;
    private JLabel defaultUrlPreviewLabel;
    private JRadioButton defaultUrlRadioButton;
    private JRadioButton doNotOpenBrowserRadioButton;
    private JButton newPathMappingButton;
    private JLabel pathMappingInfoLabel;
    private JLabel pathMappingLabel;
    private JScrollPane pathMappingScrollPane;
    private JTable pathMappingTable;
    private JLabel proxyHostLabel;
    private JTextField proxyHostTextField;
    private JLabel proxyLabel;
    private JLabel proxyPortLabel;
    private JTextField proxyPortTextField;
    private JButton removePathMappingButton;

    RunAsWebAdvanced(PhpProject phpProject, Properties properties) {
        assert (phpProject != null);
        assert (properties != null);
        this.project = phpProject;
        this.initComponents();
        this.setDebugUrl(properties);
        this.setDebugProxy(properties);
        String[] stringArray = new String[]{NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_ServerPath"), NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_LocalPath")};
        this.pathMappingTableModel = new PathMappingTableModel(stringArray, this.getPathMappings(properties.remotePaths, properties.localPaths));
        this.pathMappingTable.setModel(this.pathMappingTableModel);
        this.pathMappingTable.setDefaultRenderer(LocalPathCell.class, new LocalPathCellRenderer());
        this.pathMappingTable.addMouseListener(new LocalPathCellMouseListener(this.pathMappingTable));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsWebAdvanced.this.validateFields();
            }
        };
        this.defaultUrlRadioButton.addActionListener(actionListener);
        this.askUrlRadioButton.addActionListener(actionListener);
        this.doNotOpenBrowserRadioButton.addActionListener(actionListener);
        this.pathMappingTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                RunAsWebAdvanced.this.handleButtonStates();
                RunAsWebAdvanced.this.validateFields();
            }
        });
        this.pathMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RunAsWebAdvanced.this.handleButtonStates();
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsWebAdvanced.this.validateFields();
            }
        };
        this.proxyHostTextField.getDocument().addDocumentListener(documentListener);
        this.proxyPortTextField.getDocument().addDocumentListener(documentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_AdvancedWebConfiguration"), true, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            this.validateFields();
            dialog.setVisible(true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            dialog.dispose();
            throw throwable;
        }
        dialog.dispose();
        return this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }

    public PhpProjectProperties.DebugUrl getDebugUrl() {
        PhpProjectProperties.DebugUrl debugUrl = null;
        if (this.defaultUrlRadioButton.isSelected()) {
            debugUrl = PhpProjectProperties.DebugUrl.DEFAULT_URL;
        } else if (this.askUrlRadioButton.isSelected()) {
            debugUrl = PhpProjectProperties.DebugUrl.ASK_FOR_URL;
        } else if (this.doNotOpenBrowserRadioButton.isSelected()) {
            debugUrl = PhpProjectProperties.DebugUrl.DO_NOT_OPEN_BROWSER;
        }
        assert (debugUrl != null);
        return debugUrl;
    }

    public Pair<String, String> getPathMapping() {
        FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        int n = this.pathMappingTableModel.getRowCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)this.pathMappingTableModel.getValueAt(i, 0);
            if (!StringUtils.hasText((String)string)) continue;
            String string2 = null;
            string2 = ((LocalPathCell)this.pathMappingTableModel.getValueAt(i, 1)).getPath();
            File file = new File(string2);
            assert (file.isDirectory()) : string2 + " must be a directory!";
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            String string3 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            if (string3 != null) {
                string2 = string3;
            }
            arrayList.add(string);
            arrayList2.add(string2);
        }
        return Pair.of((Object)StringUtils.implode(arrayList, (String)"||NB||"), (Object)StringUtils.implode(arrayList2, (String)"||NB||"));
    }

    public Pair<String, String> getDebugProxy() {
        String string = this.proxyHostTextField.getText();
        String string2 = null;
        if (StringUtils.hasText((String)string)) {
            string2 = this.proxyPortTextField.getText();
        }
        return Pair.of((Object)string, string2);
    }

    void validateFields() {
        String string;
        assert (this.notificationLineSupport != null);
        for (int i = 0; i < this.pathMappingTableModel.getRowCount(); ++i) {
            string = (String)this.pathMappingTableModel.getValueAt(i, 0);
            String string2 = ((LocalPathCell)this.pathMappingTableModel.getValueAt(i, 1)).getPath();
            if (!StringUtils.hasText((String)string) && !StringUtils.hasText((String)string2)) continue;
            if (!StringUtils.hasText((String)string) && StringUtils.hasText((String)string2)) {
                this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_RemotePathEmpty"));
                this.descriptor.setValid(false);
                return;
            }
            if (StringUtils.hasText((String)string) && !StringUtils.hasText((String)string2)) {
                this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_LocalPathEmpty"));
                this.descriptor.setValid(false);
                return;
            }
            if (this.isLocalPathValid(string2)) continue;
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_LocalPathNotValid", (Object)string2));
            this.descriptor.setValid(false);
            return;
        }
        String string3 = this.proxyHostTextField.getText();
        if (StringUtils.hasText((String)string3) && (string = RemoteValidator.validatePort(this.proxyPortTextField.getText())) != null) {
            this.notificationLineSupport.setErrorMessage(string);
            this.descriptor.setValid(false);
            return;
        }
        string = null;
        if ((this.doNotOpenBrowserRadioButton.isSelected() || this.askUrlRadioButton.isSelected()) && !this.isAnyRemotePathDefined()) {
            string = NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_WarningNoPathMapping");
        }
        if (string != null) {
            this.notificationLineSupport.setWarningMessage(string);
        } else {
            this.notificationLineSupport.clearMessages();
        }
        this.descriptor.setValid(true);
    }

    private boolean isAnyRemotePathDefined() {
        for (int i = 0; i < this.pathMappingTableModel.getRowCount(); ++i) {
            String string = (String)this.pathMappingTableModel.getValueAt(i, 0);
            if (!StringUtils.hasText((String)string)) continue;
            return true;
        }
        return false;
    }

    void handleButtonStates() {
        this.removePathMappingButton.setEnabled(this.isTableRowSelected());
        this.newPathMappingButton.setEnabled(this.pathMappingTableModel.isLastServerPathFilled());
    }

    private Object[][] getPathMappings(String string, String string2) {
        List list = StringUtils.explode((String)string, (String)"||NB||");
        List list2 = StringUtils.explode((String)string2, (String)"||NB||");
        int n = list.size();
        int n2 = list2.size();
        Object[][] objectArray = new Object[n + 1][2];
        for (int i = 0; i < n; ++i) {
            String string3 = DEFAULT_LOCAL_PATH;
            if (i < n2) {
                string3 = (String)list2.get(i);
            }
            Pair<String, String> pair = this.getPathMapping((String)list.get(i), string3);
            objectArray[i][0] = pair.first;
            objectArray[i][1] = new LocalPathCell((String)pair.second);
        }
        objectArray[n][0] = null;
        objectArray[n][1] = new LocalPathCell(DEFAULT_LOCAL_PATH);
        return objectArray;
    }

    private Pair<String, String> getPathMapping(String string, String string2) {
        if (StringUtils.hasText((String)string)) {
            FileObject fileObject = ProjectPropertiesSupport.getSourcesDirectory(this.project);
            if (RunAsWebAdvanced.isSources(string2)) {
                string2 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
            } else {
                FileObject fileObject2 = fileObject.getFileObject(string2);
                if (fileObject2 != null) {
                    string2 = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
                }
            }
        } else {
            string2 = DEFAULT_LOCAL_PATH;
        }
        return Pair.of((Object)string, (Object)string2);
    }

    private int getTableSelectedRow() {
        return this.pathMappingTable.getSelectedRow();
    }

    private boolean isTableRowSelected() {
        return this.getTableSelectedRow() != -1;
    }

    private void setDebugUrl(Properties properties) {
        String string = properties.debugUrl;
        if (string == null) {
            string = PhpProjectProperties.DebugUrl.DEFAULT_URL.name();
        }
        switch (PhpProjectProperties.DebugUrl.valueOf(string)) {
            case DEFAULT_URL: {
                this.defaultUrlRadioButton.setSelected(true);
                break;
            }
            case ASK_FOR_URL: {
                this.askUrlRadioButton.setSelected(true);
                break;
            }
            case DO_NOT_OPEN_BROWSER: {
                this.doNotOpenBrowserRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown debug url type: " + string);
            }
        }
        this.defaultUrlPreviewLabel.setText(properties.urlPreview);
    }

    private void setDebugProxy(Properties properties) {
        this.proxyHostTextField.setText(properties.proxyHost);
        String string = properties.proxyPort;
        if (RemoteValidator.validatePort(string) != null) {
            string = String.valueOf(9001);
        }
        this.proxyPortTextField.setText(string);
    }

    private void initComponents() {
        this.debugUrlButtonGroup = new ButtonGroup();
        this.debugUrlLabel = new JLabel();
        this.defaultUrlRadioButton = new JRadioButton();
        this.defaultUrlPreviewLabel = new JLabel();
        this.askUrlRadioButton = new JRadioButton();
        this.doNotOpenBrowserRadioButton = new JRadioButton();
        this.pathMappingLabel = new JLabel();
        this.pathMappingScrollPane = new JScrollPane();
        this.pathMappingTable = new JTable();
        this.newPathMappingButton = new JButton();
        this.removePathMappingButton = new JButton();
        this.pathMappingInfoLabel = new JLabel();
        this.proxyLabel = new JLabel();
        this.proxyHostLabel = new JLabel();
        this.proxyHostTextField = new JTextField();
        this.proxyPortLabel = new JLabel();
        this.proxyPortTextField = new JTextField();
        this.setFocusTraversalPolicy(null);
        this.debugUrlLabel.setLabelFor(this.defaultUrlRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.debugUrlLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.debugUrlLabel.text"));
        this.debugUrlButtonGroup.add(this.defaultUrlRadioButton);
        this.defaultUrlRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultUrlRadioButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlRadioButton.text"));
        this.defaultUrlPreviewLabel.setLabelFor(this.defaultUrlRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.defaultUrlPreviewLabel, (String)"dummy");
        this.debugUrlButtonGroup.add(this.askUrlRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.askUrlRadioButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.askUrlRadioButton.text"));
        this.debugUrlButtonGroup.add(this.doNotOpenBrowserRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.doNotOpenBrowserRadioButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.doNotOpenBrowserRadioButton.text"));
        this.pathMappingLabel.setLabelFor(this.pathMappingTable);
        Mnemonics.setLocalizedText((JLabel)this.pathMappingLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingLabel.text"));
        this.pathMappingTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.pathMappingScrollPane.setViewportView(this.pathMappingTable);
        this.pathMappingTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingTable.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.newPathMappingButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.newPathMappingButton.text"));
        this.newPathMappingButton.setEnabled(false);
        this.newPathMappingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsWebAdvanced.this.newPathMappingButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removePathMappingButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.removePathMappingButton.text"));
        this.removePathMappingButton.setEnabled(false);
        this.removePathMappingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsWebAdvanced.this.removePathMappingButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.pathMappingInfoLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.proxyLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyLabel.text"));
        this.proxyHostLabel.setLabelFor(this.proxyHostTextField);
        Mnemonics.setLocalizedText((JLabel)this.proxyHostLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostLabel.text"));
        this.proxyPortLabel.setLabelFor(this.proxyPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.proxyPortLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortLabel.text"));
        this.proxyPortTextField.setPreferredSize(new Dimension(46, 19));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pathMappingScrollPane, -1, 402, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.removePathMappingButton).add((Component)this.newPathMappingButton))).add((Component)this.debugUrlLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.defaultUrlRadioButton).addPreferredGap(0).add((Component)this.defaultUrlPreviewLabel)).add((Component)this.askUrlRadioButton).add((Component)this.doNotOpenBrowserRadioButton).add((Component)this.pathMappingLabel).add((Component)this.pathMappingInfoLabel).add((Component)this.proxyLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.proxyHostLabel).addPreferredGap(0).add((Component)this.proxyHostTextField, -2, 207, -2).addPreferredGap(0).add((Component)this.proxyPortLabel).addPreferredGap(0).add((Component)this.proxyPortTextField, -2, -1, -2))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.newPathMappingButton, this.removePathMappingButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.debugUrlLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.defaultUrlRadioButton).add((Component)this.defaultUrlPreviewLabel)).addPreferredGap(0).add((Component)this.askUrlRadioButton).addPreferredGap(0).add((Component)this.doNotOpenBrowserRadioButton).addPreferredGap(1).add((Component)this.pathMappingLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.newPathMappingButton).addPreferredGap(0).add((Component)this.removePathMappingButton)).add((Component)this.pathMappingScrollPane, -1, 127, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.pathMappingInfoLabel).addPreferredGap(1).add((Component)this.proxyLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.proxyHostTextField, -2, -1, -2).add((Component)this.proxyHostLabel).add((Component)this.proxyPortLabel).add((Component)this.proxyPortTextField, -2, -1, -2)).addContainerGap()));
        this.debugUrlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.debugUrlLabel.AccessibleContext.accessibleName"));
        this.debugUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.debugUrlLabel.AccessibleContext.accessibleDescription"));
        this.defaultUrlRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlRadioButton.AccessibleContext.accessibleName"));
        this.defaultUrlRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlRadioButton.AccessibleContext.accessibleDescription"));
        this.defaultUrlPreviewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlPreviewLabel.AccessibleContext.accessibleName"));
        this.defaultUrlPreviewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlPreviewLabel.AccessibleContext.accessibleDescription"));
        this.askUrlRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.askUrlRadioButton.AccessibleContext.accessibleName"));
        this.askUrlRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.askUrlRadioButton.AccessibleContext.accessibleDescription"));
        this.doNotOpenBrowserRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.doNotOpenBrowserRadioButton.AccessibleContext.accessibleName"));
        this.doNotOpenBrowserRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.doNotOpenBrowserRadioButton.AccessibleContext.accessibleDescription"));
        this.pathMappingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingLabel.AccessibleContext.accessibleName"));
        this.pathMappingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingLabel.AccessibleContext.accessibleDescription"));
        this.pathMappingScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingScrollPane.AccessibleContext.accessibleName"));
        this.pathMappingScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingScrollPane.AccessibleContext.accessibleDescription"));
        this.newPathMappingButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.newPathMappingButton.AccessibleContext.accessibleName"));
        this.newPathMappingButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.newPathMappingButton.AccessibleContext.accessibleDescription"));
        this.removePathMappingButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.removePathMappingButton.AccessibleContext.accessibleName"));
        this.removePathMappingButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.removePathMappingButton.AccessibleContext.accessibleDescription"));
        this.pathMappingInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingInfoLabel.AccessibleContext.accessibleName"));
        this.pathMappingInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingInfoLabel.AccessibleContext.accessibleDescription"));
        this.proxyLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyLabel.AccessibleContext.accessibleName"));
        this.proxyLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyLabel.AccessibleContext.accessibleDescription"));
        this.proxyHostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostLabel.AccessibleContext.accessibleName"));
        this.proxyHostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostLabel.AccessibleContext.accessibleDescription"));
        this.proxyHostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostTextField.AccessibleContext.accessibleName"));
        this.proxyHostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostTextField.AccessibleContext.accessibleDescription"));
        this.proxyPortLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortLabel.AccessibleContext.accessibleName"));
        this.proxyPortLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortLabel.AccessibleContext.accessibleDescription"));
        this.proxyPortTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.AccessibleContext.accessibleDescription"));
    }

    private void newPathMappingButtonActionPerformed(ActionEvent actionEvent) {
        this.pathMappingTableModel.addRow(new Object[]{null, new LocalPathCell(DEFAULT_LOCAL_PATH)});
    }

    private void removePathMappingButtonActionPerformed(ActionEvent actionEvent) {
        assert (this.getTableSelectedRow() != -1) : "A table row must be selected";
        while (this.getTableSelectedRow() != -1) {
            this.pathMappingTableModel.removeRow(this.getTableSelectedRow());
        }
        if (this.pathMappingTableModel.getRowCount() == 0) {
            this.newPathMappingButtonActionPerformed(null);
        }
    }

    static boolean isSources(String string) {
        return string == null || DEFAULT_LOCAL_PATH.equals(string);
    }

    private boolean isLocalPathValid(String string) {
        assert (StringUtils.hasText((String)string));
        File file = new File(string);
        return file.isDirectory() && file.isAbsolute();
    }

    public static final class Properties {
        public final String debugUrl;
        public final String urlPreview;
        public final String remotePaths;
        public final String localPaths;
        public final String proxyHost;
        public final String proxyPort;

        public Properties(String string, String string2, String string3, String string4, String string5, String string6) {
            this.debugUrl = string;
            this.urlPreview = string2;
            this.remotePaths = string3;
            this.localPaths = string4;
            this.proxyHost = string5;
            this.proxyPort = string6;
        }
    }

    private final class LocalPathCellMouseListener
    extends MouseAdapter {
        private final JTable table;

        public LocalPathCellMouseListener(JTable jTable) {
            this.table = jTable;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n2 = this.table.rowAtPoint(point);
            Object object = this.table.getValueAt(n2, n = this.table.columnAtPoint(point));
            if (object instanceof LocalPathCell) {
                Rectangle rectangle = this.table.getCellRect(n2, n, false);
                LocalPathCell localPathCell = (LocalPathCell)object;
                JButton jButton = localPathCell.getButton();
                if (mouseEvent.getX() > rectangle.x + rectangle.width - jButton.getWidth()) {
                    File file = Utils.browseLocationAction(this.table, this.getLastFolder(), NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_SelectProjectFolder"));
                    if (file != null) {
                        localPathCell.setPath(file.getAbsolutePath());
                        LastUsedFolders.setPathMapping(file);
                    }
                    RunAsWebAdvanced.this.validateFields();
                }
            }
        }

        private File getLastFolder() {
            File file = LastUsedFolders.getPathMapping();
            if (file == null) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (!CommandUtils.isUnderAnySourceGroup(RunAsWebAdvanced.this.project, fileObject, false)) {
                return FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(RunAsWebAdvanced.this.project));
            }
            return file;
        }
    }

    private final class LocalPathCellRenderer
    implements TableCellRenderer {
        private LocalPathCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            LocalPathCell localPathCell = (LocalPathCell)object;
            if (localPathCell == null) {
                localPathCell = new LocalPathCell(RunAsWebAdvanced.DEFAULT_LOCAL_PATH);
            }
            if (bl) {
                localPathCell.setBgColor(jTable.getSelectionBackground());
                localPathCell.setFgColor(jTable.getSelectionForeground());
            } else {
                localPathCell.setBgColor(jTable.getBackground());
                localPathCell.setFgColor(jTable.getForeground());
            }
            return localPathCell;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PathMappingTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 169356031075115831L;

        public PathMappingTableModel(String[] stringArray, Object[][] objectArray) {
            super(objectArray, stringArray);
        }

        public boolean isLastServerPathFilled() {
            int n = this.getRowCount();
            if (n == 0) {
                return true;
            }
            return StringUtils.hasText((String)((String)this.getValueAt(n - 1, 0)));
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return LocalPathCell.class;
            }
            if (n == 0) {
                return String.class;
            }
            throw new IllegalStateException("Unhandled column index: " + n);
        }
    }
}

