/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CustomizerPhpUnit
extends JPanel {
    private static final long serialVersionUID = 2171421712032630826L;
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final PhpProject project;
    private JButton bootstrapBrowseButton;
    private JCheckBox bootstrapCheckBox;
    private JButton bootstrapGenerateButton;
    private JLabel bootstrapLabel;
    private JTextField bootstrapTextField;
    private JButton configurationBrowseButton;
    private JCheckBox configurationCheckBox;
    private JButton configurationGenerateButton;
    private JLabel configurationLabel;
    private JTextField configurationTextField;
    private JLabel phpUnitLabel;
    private JButton suiteBrowseButton;
    private JCheckBox suiteCheckBox;
    private JLabel suiteInfoLabel;
    private JLabel suiteLabel;
    private JTextField suiteTextField;

    public CustomizerPhpUnit(ProjectCustomizer.Category category, PhpProjectProperties phpProjectProperties) {
        this.category = category;
        this.uiProps = phpProjectProperties;
        this.project = phpProjectProperties.getProject();
        this.initComponents();
        this.initFile(phpProjectProperties.getPhpUnitBootstrap(), this.bootstrapCheckBox, this.bootstrapTextField);
        this.initFile(phpProjectProperties.getPhpUnitConfiguration(), this.configurationCheckBox, this.configurationTextField);
        this.initFile(phpProjectProperties.getPhpUnitSuite(), this.suiteCheckBox, this.suiteTextField);
        this.enableFile(this.bootstrapCheckBox.isSelected(), this.bootstrapLabel, this.bootstrapTextField, this.bootstrapGenerateButton, this.bootstrapBrowseButton);
        this.enableFile(this.configurationCheckBox.isSelected(), this.configurationLabel, this.configurationTextField, this.configurationGenerateButton, this.configurationBrowseButton);
        this.enableFile(this.suiteCheckBox.isSelected(), this.suiteLabel, this.suiteTextField, this.suiteBrowseButton, null);
        this.addListeners();
        this.validateData();
    }

    void enableFile(boolean bl, JLabel jLabel, JTextField jTextField, JButton jButton, JButton jButton2) {
        jLabel.setEnabled(bl);
        jTextField.setEnabled(bl);
        jButton.setEnabled(bl);
        if (jButton2 != null) {
            jButton2.setEnabled(bl);
        }
    }

    void validateData() {
        String string = "";
        if (this.bootstrapCheckBox.isSelected() && (string = this.getValidFile(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_Bootstrap"), this.bootstrapTextField)) == null) {
            return;
        }
        String string2 = "";
        if (this.configurationCheckBox.isSelected() && (string2 = this.getValidFile(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_XmlConfiguration"), this.configurationTextField)) == null) {
            return;
        }
        String string3 = "";
        if (this.suiteCheckBox.isSelected() && (string3 = this.getValidFile(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_TestSuite"), this.suiteTextField)) == null) {
            return;
        }
        this.uiProps.setPhpUnitBootstrap(string);
        this.uiProps.setPhpUnitConfiguration(string2);
        this.uiProps.setPhpUnitSuite(string3);
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void initFile(String string, JCheckBox jCheckBox, JTextField jTextField) {
        if (StringUtils.hasText((String)string)) {
            jCheckBox.setSelected(true);
            jTextField.setText(string);
        }
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.bootstrapCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CustomizerPhpUnit.this.enableFile(itemEvent.getStateChange() == 1, CustomizerPhpUnit.this.bootstrapLabel, CustomizerPhpUnit.this.bootstrapTextField, CustomizerPhpUnit.this.bootstrapGenerateButton, CustomizerPhpUnit.this.bootstrapBrowseButton);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.bootstrapTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.configurationCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CustomizerPhpUnit.this.enableFile(itemEvent.getStateChange() == 1, CustomizerPhpUnit.this.configurationLabel, CustomizerPhpUnit.this.configurationTextField, CustomizerPhpUnit.this.configurationGenerateButton, CustomizerPhpUnit.this.configurationBrowseButton);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.configurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.suiteCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CustomizerPhpUnit.this.enableFile(itemEvent.getStateChange() == 1, CustomizerPhpUnit.this.suiteLabel, CustomizerPhpUnit.this.suiteTextField, CustomizerPhpUnit.this.suiteBrowseButton, null);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.suiteTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    private String getValidFile(String string, JTextField jTextField) {
        String string2 = jTextField.getText();
        String string3 = this.validateFile(string2, string);
        if (string3 != null) {
            this.category.setErrorMessage(string3);
            this.category.setValid(false);
            return null;
        }
        return string2;
    }

    private String validateFile(String string, String string2) {
        if (!StringUtils.hasText((String)string)) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NoFile", (Object)string2);
        }
        File file = new File(string);
        if (!file.isFile()) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NotFile", (Object)string2);
        }
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NotAbsoluteFile", (Object)string2);
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NotReadableFile", (Object)string2);
        }
        return null;
    }

    private File getDefaultDirectory() {
        File file = null;
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(this.project, false);
        if (fileObject != null) {
            file = FileUtil.toFile((FileObject)fileObject);
        } else {
            FileObject fileObject2 = ProjectPropertiesSupport.getSourcesDirectory(this.project);
            assert (fileObject2 != null);
            file = FileUtil.toFile((FileObject)fileObject2);
        }
        assert (file != null);
        return file;
    }

    private boolean checkTestDirectory() {
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(this.project, false);
        if (fileObject == null && this.askQuestion(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_TestsNotSet", (Object)((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName()))) {
            fileObject = ProjectPropertiesSupport.getTestDirectory(this.project, true);
        }
        return fileObject != null;
    }

    private boolean askQuestion(String string) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION;
    }

    private void initComponents() {
        this.phpUnitLabel = new JLabel();
        this.bootstrapLabel = new JLabel();
        this.bootstrapTextField = new JTextField();
        this.bootstrapBrowseButton = new JButton();
        this.bootstrapGenerateButton = new JButton();
        this.configurationCheckBox = new JCheckBox();
        this.configurationLabel = new JLabel();
        this.configurationTextField = new JTextField();
        this.configurationBrowseButton = new JButton();
        this.bootstrapCheckBox = new JCheckBox();
        this.configurationGenerateButton = new JButton();
        this.suiteCheckBox = new JCheckBox();
        this.suiteLabel = new JLabel();
        this.suiteTextField = new JTextField();
        this.suiteBrowseButton = new JButton();
        this.suiteInfoLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return CustomizerPhpUnit.this.suiteTextField;
            }

            public Component getFirstComponent(Container container) {
                return CustomizerPhpUnit.this.suiteTextField;
            }

            public Component getLastComponent(Container container) {
                return CustomizerPhpUnit.this.suiteBrowseButton;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == CustomizerPhpUnit.this.suiteTextField) {
                    return CustomizerPhpUnit.this.suiteBrowseButton;
                }
                if (component == CustomizerPhpUnit.this.suiteCheckBox) {
                    return CustomizerPhpUnit.this.suiteTextField;
                }
                if (component == CustomizerPhpUnit.this.bootstrapCheckBox) {
                    return CustomizerPhpUnit.this.bootstrapTextField;
                }
                if (component == CustomizerPhpUnit.this.configurationGenerateButton) {
                    return CustomizerPhpUnit.this.suiteCheckBox;
                }
                if (component == CustomizerPhpUnit.this.configurationBrowseButton) {
                    return CustomizerPhpUnit.this.configurationGenerateButton;
                }
                if (component == CustomizerPhpUnit.this.configurationCheckBox) {
                    return CustomizerPhpUnit.this.configurationTextField;
                }
                if (component == CustomizerPhpUnit.this.bootstrapGenerateButton) {
                    return CustomizerPhpUnit.this.configurationCheckBox;
                }
                if (component == CustomizerPhpUnit.this.bootstrapBrowseButton) {
                    return CustomizerPhpUnit.this.bootstrapGenerateButton;
                }
                if (component == CustomizerPhpUnit.this.bootstrapTextField) {
                    return CustomizerPhpUnit.this.bootstrapBrowseButton;
                }
                if (component == CustomizerPhpUnit.this.configurationTextField) {
                    return CustomizerPhpUnit.this.configurationBrowseButton;
                }
                return CustomizerPhpUnit.this.suiteTextField;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == CustomizerPhpUnit.this.suiteBrowseButton) {
                    return CustomizerPhpUnit.this.suiteTextField;
                }
                if (component == CustomizerPhpUnit.this.suiteTextField) {
                    return CustomizerPhpUnit.this.suiteCheckBox;
                }
                if (component == CustomizerPhpUnit.this.bootstrapTextField) {
                    return CustomizerPhpUnit.this.bootstrapCheckBox;
                }
                if (component == CustomizerPhpUnit.this.suiteCheckBox) {
                    return CustomizerPhpUnit.this.configurationGenerateButton;
                }
                if (component == CustomizerPhpUnit.this.configurationGenerateButton) {
                    return CustomizerPhpUnit.this.configurationBrowseButton;
                }
                if (component == CustomizerPhpUnit.this.configurationTextField) {
                    return CustomizerPhpUnit.this.configurationCheckBox;
                }
                if (component == CustomizerPhpUnit.this.configurationCheckBox) {
                    return CustomizerPhpUnit.this.bootstrapGenerateButton;
                }
                if (component == CustomizerPhpUnit.this.bootstrapGenerateButton) {
                    return CustomizerPhpUnit.this.bootstrapBrowseButton;
                }
                if (component == CustomizerPhpUnit.this.bootstrapBrowseButton) {
                    return CustomizerPhpUnit.this.bootstrapTextField;
                }
                if (component == CustomizerPhpUnit.this.configurationBrowseButton) {
                    return CustomizerPhpUnit.this.configurationTextField;
                }
                return CustomizerPhpUnit.this.suiteBrowseButton;
            }
        });
        this.phpUnitLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.phpUnitLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.phpUnitLabel.text"));
        this.bootstrapLabel.setLabelFor(this.bootstrapTextField);
        Mnemonics.setLocalizedText((JLabel)this.bootstrapLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.text"));
        this.bootstrapBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPhpUnit.this.bootstrapBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapGenerateButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.text"));
        this.bootstrapGenerateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPhpUnit.this.bootstrapGenerateButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configurationCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.text"));
        this.configurationLabel.setLabelFor(this.configurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.text"));
        this.configurationBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPhpUnit.this.configurationBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationGenerateButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.text"));
        this.configurationGenerateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPhpUnit.this.configurationGenerateButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.suiteCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.text"));
        this.suiteLabel.setLabelFor(this.suiteTextField);
        Mnemonics.setLocalizedText((JLabel)this.suiteLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suiteBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.text"));
        this.suiteBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerPhpUnit.this.suiteBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.suiteInfoLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.suiteInfoLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.bootstrapLabel).addPreferredGap(0).add((Component)this.bootstrapTextField, -1, 181, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bootstrapBrowseButton).addPreferredGap(0).add((Component)this.bootstrapGenerateButton)).add((Component)this.configurationCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.configurationLabel).addPreferredGap(0).add((Component)this.configurationTextField, -1, 128, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.configurationBrowseButton).addPreferredGap(0).add((Component)this.configurationGenerateButton)).add((Component)this.suiteCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.suiteLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.suiteInfoLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.suiteTextField, -1, 275, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.suiteBrowseButton)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.phpUnitLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bootstrapCheckBox).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.bootstrapBrowseButton, this.bootstrapGenerateButton, this.configurationBrowseButton, this.configurationGenerateButton, this.suiteBrowseButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.phpUnitLabel).addPreferredGap(0).add((Component)this.bootstrapCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.bootstrapLabel).add((Component)this.bootstrapTextField, -2, -1, -2).add((Component)this.bootstrapGenerateButton).add((Component)this.bootstrapBrowseButton)).add(18, 18, 18).add((Component)this.configurationCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.configurationLabel).add((Component)this.configurationTextField, -2, -1, -2).add((Component)this.configurationGenerateButton).add((Component)this.configurationBrowseButton)).add(18, 18, 18).add((Component)this.suiteCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.suiteLabel).add((Component)this.suiteTextField, -2, -1, -2).add((Component)this.suiteBrowseButton)).addPreferredGap(0).add((Component)this.suiteInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.phpUnitLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.phpUnitLabel.AccessibleContext.accessibleName"));
        this.phpUnitLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.phpUnitLabel.AccessibleContext.accessibleDescription"));
        this.bootstrapLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.AccessibleContext.accessibleName"));
        this.bootstrapLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.AccessibleContext.accessibleDescription"));
        this.bootstrapTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapTextField.AccessibleContext.accessibleName"));
        this.bootstrapTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapTextField.AccessibleContext.accessibleDescription"));
        this.bootstrapBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.AccessibleContext.accessibleName"));
        this.bootstrapBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.AccessibleContext.accessibleDescription"));
        this.bootstrapGenerateButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.AccessibleContext.accessibleName"));
        this.bootstrapGenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.AccessibleContext.accessibleDescription"));
        this.configurationCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.AccessibleContext.accessibleName"));
        this.configurationCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.AccessibleContext.accessibleName"));
        this.configurationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.AccessibleContext.accessibleDescription"));
        this.configurationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationTextField.AccessibleContext.accessibleName"));
        this.configurationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationTextField.AccessibleContext.accessibleDescription"));
        this.configurationBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.AccessibleContext.accessibleName"));
        this.configurationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.AccessibleContext.accessibleDescription"));
        this.bootstrapCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.AccessibleContext.accessibleName"));
        this.bootstrapCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationGenerateButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.AccessibleContext.accessibleName"));
        this.configurationGenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.AccessibleContext.accessibleDescription"));
        this.suiteCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.AccessibleContext.accessibleName"));
        this.suiteCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.AccessibleContext.accessibleDescription"));
        this.suiteLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.AccessibleContext.accessibleName"));
        this.suiteLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.AccessibleContext.accessibleDescription"));
        this.suiteTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteTextField.AccessibleContext.accessibleName"));
        this.suiteTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteTextField.AccessibleContext.accessibleDescription"));
        this.suiteBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.AccessibleContext.accessibleName"));
        this.suiteBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.AccessibleContext.accessibleDescription"));
        this.suiteInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.AccessibleContext.accessibleName"));
        this.suiteInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.AccessibleContext.accessibleDescription"));
    }

    private void bootstrapBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseFileAction(this, this.getDefaultDirectory(), NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_SelectBootstrap"));
        if (file != null) {
            this.bootstrapTextField.setText(file.getAbsolutePath());
        }
    }

    private void bootstrapGenerateButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        if (this.checkTestDirectory() && (file = PhpUnit.createBootstrapFile(this.project)) != null) {
            this.bootstrapTextField.setText(file.getAbsolutePath());
        }
    }

    private void configurationBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseFileAction(this, this.getDefaultDirectory(), NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_SelectConfiguration"));
        if (file != null) {
            this.configurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void configurationGenerateButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        if (this.checkTestDirectory() && (file = PhpUnit.createConfigurationFile(this.project)) != null) {
            this.configurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void suiteBrowseButtonActionPerformed(ActionEvent actionEvent) {
        File file = Utils.browseFileAction(this, this.getDefaultDirectory(), NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_SelectSuite"));
        if (file != null) {
            this.suiteTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerPhpUnit.this.validateData();
        }
    }
}

