/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class DebugScript
extends RunScript {
    private final Provider provider;

    public DebugScript(Provider provider) {
        super(provider);
        this.provider = provider;
    }

    public void run() {
        Callable<Cancellable> callable = this.getCallable();
        XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
        assert (xDebugStarter != null);
        if (xDebugStarter.isAlreadyRunning()) {
            if (CommandUtils.warnNoMoreDebugSession()) {
                xDebugStarter.stop();
                this.run();
            }
        } else {
            XDebugStarter.Properties properties = XDebugStarter.Properties.create(this.provider.getStartFile(), true, ProjectPropertiesSupport.getDebugPathMapping(this.provider.getProject()), ProjectPropertiesSupport.getDebugProxy(this.provider.getProject()));
            xDebugStarter.start(this.provider.getProject(), callable, properties);
        }
    }

    protected boolean isControllable() {
        return false;
    }

    protected String getOutputTabTitle() {
        return String.format("%s %s", super.getOutputTabTitle(), NbBundle.getMessage(DebugScript.class, (String)"MSG_Suffix_Debug"));
    }

    protected ExternalProcessBuilder getProcessBuilder() {
        return super.getProcessBuilder().addEnvironmentVariable("XDEBUG_CONFIG", "idekey=" + PhpOptions.getInstance().getDebuggerSessionId());
    }

    public static interface Provider
    extends RunScript.Provider {
        public PhpProject getProject();

        public FileObject getStartFile();
    }
}

