/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.php.project.PhpPreferences;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableModel;
import org.openide.util.ImageUtilities;

public final class SortColumnHeaderRenderer
implements TableCellRenderer {
    private static final String SORTING_COLUMN_INDEX = "SortingColumnIndex";
    private static final String SORTING_ASCENDING = "SortingAscending";
    private static ImageIcon sortDescIcon;
    private static ImageIcon sortAscIcon;
    private final TransferFileTableModel model;
    private final TableCellRenderer textRenderer;
    private int sortColumnIndex;
    private boolean sortAscending;

    public SortColumnHeaderRenderer(TransferFileTableModel transferFileTableModel, TableCellRenderer tableCellRenderer) {
        assert (transferFileTableModel != null);
        assert (tableCellRenderer != null);
        this.model = transferFileTableModel;
        this.textRenderer = tableCellRenderer;
        this.sortColumnIndex = SortColumnHeaderRenderer.getPreferences().getInt(SORTING_COLUMN_INDEX, this.getDefaultSortingColumn());
        this.sortAscending = SortColumnHeaderRenderer.getPreferences().getBoolean(SORTING_ASCENDING, true);
        transferFileTableModel.sort(this.sortColumnIndex, this.sortAscending);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.textRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            if (n2 == this.sortColumnIndex) {
                jLabel.setIcon(this.sortAscending ? this.getSortAscIcon() : this.getSortDescIcon());
                jLabel.setHorizontalTextPosition(2);
            } else {
                jLabel.setIcon(null);
            }
        }
        return component;
    }

    public void setDefaultSorting() {
        this.setSorting(this.getDefaultSortingColumn());
    }

    private int getDefaultSortingColumn() {
        return 1;
    }

    public void setSorting(int n) {
        if (n != this.sortColumnIndex) {
            this.sortColumnIndex = n;
            this.sortAscending = true;
        } else {
            this.sortAscending = !this.sortAscending;
        }
        SortColumnHeaderRenderer.getPreferences().putInt(SORTING_COLUMN_INDEX, this.sortColumnIndex);
        SortColumnHeaderRenderer.getPreferences().putBoolean(SORTING_ASCENDING, this.sortAscending);
        this.model.sort(n, this.sortAscending);
    }

    public void sort() {
        this.model.sort(this.sortColumnIndex, this.sortAscending);
    }

    private ImageIcon getSortAscIcon() {
        if (sortAscIcon == null) {
            sortAscIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/columnsSortedDesc.gif", (boolean)false);
        }
        return sortAscIcon;
    }

    private ImageIcon getSortDescIcon() {
        if (sortDescIcon == null) {
            sortDescIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/columnsSortedAsc.gif", (boolean)false);
        }
        return sortDescIcon;
    }

    private static Preferences getPreferences() {
        return PhpPreferences.getPreferences(false);
    }
}

