/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;

public final class SftpConfiguration
extends RemoteConfiguration {
    private static final String PATH_SEPARATOR = "/";
    private final String host;
    private final int port;
    private final String userName;
    private final String password;
    private final String knownHostsFile;
    private final String identityFile;
    private final String initialDirectory;
    private final int timeout;

    public SftpConfiguration(ConfigManager.Configuration configuration) {
        super(configuration);
        this.host = configuration.getValue("host");
        this.port = Integer.parseInt(configuration.getValue("port"));
        this.userName = configuration.getValue("user");
        this.password = configuration.getValue("password", true);
        this.knownHostsFile = configuration.getValue("knownHostsFile");
        this.identityFile = configuration.getValue("identityFile");
        this.initialDirectory = configuration.getValue("initialDirectory");
        this.timeout = Integer.parseInt(configuration.getValue("timeout"));
    }

    public String getHost() {
        return this.host;
    }

    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password != null ? this.password : "";
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public String getIdentityFile() {
        return this.identityFile;
    }

    public String getUrl(String string) {
        assert (string != null);
        String string2 = this.initialDirectory;
        if (string.trim().length() > 0) {
            string2 = string2 + string;
        }
        return "sftp://" + this.host + string2.replaceAll("/{2,}", PATH_SEPARATOR);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SftpConfiguration sftpConfiguration = (SftpConfiguration)object;
        if (!(this.host == sftpConfiguration.host || this.host != null && this.host.equals(sftpConfiguration.host))) {
            return false;
        }
        if (this.port != sftpConfiguration.port) {
            return false;
        }
        if (!(this.userName == sftpConfiguration.userName || this.userName != null && this.userName.equals(sftpConfiguration.userName))) {
            return false;
        }
        if (!(this.password == sftpConfiguration.password || this.password != null && this.password.equals(sftpConfiguration.password))) {
            return false;
        }
        return this.identityFile == sftpConfiguration.identityFile || this.identityFile != null && this.identityFile.equals(sftpConfiguration.identityFile);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 97 * n + (this.host != null ? this.host.hashCode() : 0);
        n = 97 * n + this.port;
        n = 97 * n + (this.userName != null ? this.userName.hashCode() : 0);
        n = 97 * n + (this.password != null ? this.password.hashCode() : 0);
        n = 97 * n + (this.identityFile != null ? this.identityFile.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [displayName: ");
        stringBuilder.append(this.getDisplayName());
        stringBuilder.append(", name: ");
        stringBuilder.append(this.getName());
        stringBuilder.append(", host: ");
        stringBuilder.append(this.host);
        stringBuilder.append(", port: ");
        stringBuilder.append(this.port);
        stringBuilder.append(", userName: ");
        stringBuilder.append(this.getUserName());
        stringBuilder.append(", password: *****");
        stringBuilder.append(", knownHostsFile: ");
        stringBuilder.append(this.knownHostsFile);
        stringBuilder.append(", identityFile: ");
        stringBuilder.append(this.identityFile);
        stringBuilder.append(", initialDirectory: ");
        stringBuilder.append(this.initialDirectory);
        stringBuilder.append(", timeout: ");
        stringBuilder.append(this.timeout);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

