/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    static final String INCLUDES = "**";
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final PhpProject project;
    private final PropertyEvaluator evaluator;
    private List<PathResourceImplementation> resources;
    private final SourceRoots sources;
    private SourceRoots tests;
    private SourceRoots selenium;

    public SourcePathImplementation(PhpProject phpProject, SourceRoots sourceRoots) {
        this(phpProject, sourceRoots, null, null);
    }

    public SourcePathImplementation(PhpProject phpProject, SourceRoots sourceRoots, SourceRoots sourceRoots2, SourceRoots sourceRoots3) {
        assert (phpProject != null);
        assert (sourceRoots != null);
        this.project = phpProject;
        this.evaluator = ProjectPropertiesSupport.getPropertyEvaluator(phpProject);
        this.sources = sourceRoots;
        sourceRoots.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceRoots));
        this.tests = sourceRoots2;
        this.selenium = sourceRoots3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        URL[] uRLArray = this;
        synchronized (this) {
            if (this.resources != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.resources;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            uRLArray = this.sources.getRootURLs();
            URL[] uRLArray2 = this;
            synchronized (this) {
                if (this.resources == null) {
                    ArrayList<FilteringPathResource> arrayList = new ArrayList<FilteringPathResource>(uRLArray.length);
                    for (URL uRL : uRLArray) {
                        arrayList.add((SourcePathImplementation)this.new FilteringPathResource(this.evaluator, uRL));
                    }
                    this.resources = Collections.unmodifiableList(arrayList);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return this.resources;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SourceRoots.PROP_ROOTS.equals(propertyChangeEvent.getPropertyName())) {
            this.invalidate();
        } else if (propertyChangeEvent.getSource() == this.evaluator && propertyChangeEvent.getPropertyName() == null) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            this.resources = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    String computeExcludes(File file) {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (File file2 : this.project.getIgnoredFiles()) {
            String string = PropertyUtils.relativizeFile((File)file, (File)file2);
            if (!this.isUnderneath(string)) continue;
            String string2 = string;
            if (file2.isDirectory()) {
                string2 = string2 + "/**";
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2);
        }
        this.ignoreTests(stringBuilder, file, this.tests);
        this.ignoreTests(stringBuilder, file, this.selenium);
        return stringBuilder.toString();
    }

    private void ignoreTests(StringBuilder stringBuilder, File file, SourceRoots sourceRoots) {
        if (sourceRoots == null) {
            return;
        }
        assert (sourceRoots.isTest()) : "Not test source roots provided";
        for (FileObject fileObject : sourceRoots.getRoots()) {
            File file2 = FileUtil.toFile((FileObject)fileObject);
            if (file2 == null) continue;
            assert (file2.isDirectory());
            String string = PropertyUtils.relativizeFile((File)file, (File)file2);
            if (!this.isUnderneath(string)) continue;
            String string2 = string + "/**";
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2);
        }
    }

    private boolean isUnderneath(String string) {
        return string != null && !string.equals(".") && !string.startsWith("../");
    }

    private final class FilteringPathResource
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        volatile PathMatcher matcher;
        private final URL root;

        FilteringPathResource(PropertyEvaluator propertyEvaluator, URL uRL) {
            assert (propertyEvaluator != null);
            assert (uRL != null);
            this.root = uRL;
            propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        }

        public URL[] getRoots() {
            return new URL[]{this.root};
        }

        public boolean includes(URL uRL, String string) {
            if (this.matcher == null) {
                File file = new File(URI.create(uRL.toExternalForm()));
                this.matcher = new PathMatcher(SourcePathImplementation.INCLUDES, SourcePathImplementation.this.computeExcludes(file), file);
            }
            return this.matcher.matches(string, true);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("ignore.path") || string.equals("test.src.dir") || string.equals("selenium.src.dir")) {
                this.matcher = null;
                PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, "includes", null, null);
                propertyChangeEvent2.setPropagationId(propertyChangeEvent);
                this.pcs.firePropertyChange(propertyChangeEvent2);
            }
        }
    }
}

