/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class CustomizeProject
extends ProjectAction
implements Presenter.Popup {
    private static final String namePattern = NbBundle.getMessage(CustomizeProject.class, (String)"LBL_CustomizeProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage(CustomizeProject.class, (String)"LBL_CustomizeProjectAction_Popup_Name");

    public CustomizeProject() {
        this((Lookup)null);
    }

    public CustomizeProject(Lookup lookup) {
        super((String)null, namePattern, namePatternPopup, null, lookup);
        this.refresh(this.getLookup());
    }

    protected void refresh(Lookup lookup) {
        super.refresh(lookup);
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length != 1 || projectArray[0].getLookup().lookup(CustomizerProvider.class) == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void actionPerformed(Lookup lookup) {
        CustomizerProvider customizerProvider;
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, null);
        if (projectArray.length == 1 && (customizerProvider = (CustomizerProvider)projectArray[0].getLookup().lookup(CustomizerProvider.class)) != null) {
            if (!DataObject.getRegistry().getModifiedSet().isEmpty()) {
                HashSet<DataObject> hashSet = new HashSet<DataObject>();
                List list = ProjectOperations.getMetadataFiles((Project)projectArray[0]);
                block0: for (Object object : DataObject.getRegistry().getModifiedSet()) {
                    if (projectArray[0] != FileOwnerQuery.getOwner((FileObject)object.getPrimaryFile())) continue;
                    for (FileObject fileObject : list) {
                        if (!fileObject.equals(object.getPrimaryFile()) && (!fileObject.isFolder() || !FileUtil.isParentOf((FileObject)fileObject, (FileObject)object.getPrimaryFile()))) continue;
                        hashSet.add((DataObject)object);
                        continue block0;
                    }
                }
                if (!hashSet.isEmpty()) {
                    Object object;
                    String string = NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.saveAll");
                    object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.save_modified_files"), NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.save_modified_title"), 2, 2, new Object[]{string, NotifyDescriptor.CANCEL_OPTION}, (Object)string));
                    if (object != string) {
                        return;
                    }
                    for (DataObject dataObject : hashSet) {
                        ExitDialog.doSave(dataObject);
                    }
                }
            }
            customizerProvider.showCustomizer();
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new CustomizeProject(lookup);
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem jMenuItem = new JMenuItem();
        Actions.connect((JMenuItem)jMenuItem, (Action)this, (boolean)true);
        jMenuItem.setText(namePatternPopup);
        return jMenuItem;
    }
}

