/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class LocalizedBundleInfo {
    public static final String NAME = "OpenIDE-Module-Name";
    public static final String DISPLAY_CATEGORY = "OpenIDE-Module-Display-Category";
    public static final String SHORT_DESCRIPTION = "OpenIDE-Module-Short-Description";
    public static final String LONG_DESCRIPTION = "OpenIDE-Module-Long-Description";
    static final LocalizedBundleInfo EMPTY = new LocalizedBundleInfo(new EditableProperties[]{new EditableProperties(true)});
    private final EditableProperties[] props;
    private final File[] paths;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private boolean modified;

    public static LocalizedBundleInfo load(FileObject[] fileObjectArray) throws IOException {
        return new LocalizedBundleInfo(fileObjectArray);
    }

    public static LocalizedBundleInfo load(InputStream[] inputStreamArray) throws IOException {
        EditableProperties[] editablePropertiesArray = new EditableProperties[inputStreamArray.length];
        for (int i = 0; i < editablePropertiesArray.length; ++i) {
            editablePropertiesArray[i] = new EditableProperties(true);
            editablePropertiesArray[i].load(inputStreamArray[i]);
        }
        return new LocalizedBundleInfo(editablePropertiesArray);
    }

    private LocalizedBundleInfo(EditableProperties[] editablePropertiesArray) {
        this.props = editablePropertiesArray;
        this.paths = new File[editablePropertiesArray.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalizedBundleInfo(FileObject[] fileObjectArray) throws IOException {
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.props = new EditableProperties[fileObjectArray.length];
        this.paths = new File[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            InputStream inputStream = fileObjectArray[i].getInputStream();
            try {
                this.props[i] = new EditableProperties(true);
                this.props[i].load(inputStream);
            }
            finally {
                inputStream.close();
            }
            this.paths[i] = FileUtil.toFile((FileObject)fileObjectArray[i]);
            fileObjectArray[i].addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    try {
                        LocalizedBundleInfo.this.reload();
                    }
                    catch (IOException iOException) {
                        Util.err.log(16, "Cannot reload localized bundle info " + FileUtil.getFileDisplayName((FileObject)fileEvent.getFile()));
                    }
                }
            });
        }
    }

    public void reload() throws IOException {
        String string = this.getDisplayName();
        for (int i = 0; i < this.paths.length; ++i) {
            FileObject fileObject;
            this.props[i] = this.paths[i] == null ? new EditableProperties(true) : ((fileObject = FileUtil.toFileObject((File)this.paths[i])) != null ? Util.loadProperties(fileObject) : new EditableProperties(true));
        }
        this.modified = false;
        this.firePropertyChange("displayName", string, this.getDisplayName());
    }

    public void store() throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i] == null) continue;
            FileObject fileObject = FileUtil.toFileObject((File)this.paths[i]);
            if (fileObject == null) {
                return;
            }
            Util.storeProperties(fileObject, this.props[i]);
        }
        this.modified = false;
    }

    public EditableProperties toEditableProperties() {
        return this.props[0];
    }

    private String getProperty(String string) {
        for (int i = this.props.length - 1; i >= 0; --i) {
            if (!this.props[i].containsKey((Object)string)) continue;
            return this.props[i].getProperty(string);
        }
        return null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getDisplayName() {
        return this.getProperty(NAME);
    }

    public void setDisplayName(String string) {
        String string2 = this.getDisplayName();
        this.setProperty(NAME, string, false);
        this.firePropertyChange("displayName", string2, this.getDisplayName());
    }

    public String getCategory() {
        return this.getProperty(DISPLAY_CATEGORY);
    }

    public void setCategory(String string) {
        this.setProperty(DISPLAY_CATEGORY, string, false);
    }

    public String getShortDescription() {
        return this.getProperty(SHORT_DESCRIPTION);
    }

    public void setShortDescription(String string) {
        this.setProperty(SHORT_DESCRIPTION, string, false);
    }

    public String getLongDescription() {
        return this.getProperty(LONG_DESCRIPTION);
    }

    public void setLongDescription(String string) {
        this.setProperty(LONG_DESCRIPTION, string, true);
    }

    public File[] getPaths() {
        return this.paths;
    }

    private void setProperty(String string, String string2, boolean bl) {
        if (Utilities.compareObjects((Object)string2, (Object)this.getProperty(string))) {
            return;
        }
        this.modified = true;
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 != null && string2.length() > 0) {
            if (bl) {
                this.props[this.props.length - 1].setProperty(string, LocalizedBundleInfo.splitBySentence(string2));
            } else {
                this.props[this.props.length - 1].setProperty(string, string2);
            }
        } else {
            for (int i = 0; i < this.props.length; ++i) {
                this.props[i].remove((Object)string);
            }
        }
    }

    private static String[] splitBySentence(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        BreakIterator breakIterator = BreakIterator.getSentenceInstance(Locale.US);
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        while ((n = breakIterator.next()) != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public String toString() {
        return "LocalizedBundleInfo[" + this.getDisplayName() + "; " + this.getCategory() + "; " + this.getShortDescription() + "; " + this.getLongDescription() + "]";
    }

    public static interface Provider {
        public LocalizedBundleInfo getLocalizedBundleInfo();
    }
}

