/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.codegenerator;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.codegenerator.NewCodeGeneratorIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CodeGeneratorPanel
extends BasicWizardIterator.Panel {
    private NewCodeGeneratorIterator.DataModel data;
    private JCheckBox cpCheckBox;
    private JTextField cpFileNameField;
    private JLabel cpFileNameLabel;
    private JLabel fileNameLabel;
    private JTextField fileNametextField;
    private JLabel mimeTypeLabel;
    private JTextField mimeTypeTextField;
    private JComboBox packageNameCombo;
    private JLabel packageNameLabel;

    CodeGeneratorPanel(WizardDescriptor wizardDescriptor, NewCodeGeneratorIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", this.getMessage("LBL_CodeGeneratorPanel_Title"));
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CodeGeneratorPanel.this.checkValidity();
            }
        };
        if (dataModel.getPackageName() != null) {
            this.packageNameCombo.setSelectedItem(dataModel.getPackageName());
        }
        this.fileNametextField.getDocument().addDocumentListener(documentAdapter);
        this.cpFileNameField.getDocument().addDocumentListener(documentAdapter);
        this.mimeTypeTextField.getDocument().addDocumentListener(documentAdapter);
        Component component = this.packageNameCombo.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(documentAdapter);
        }
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.fileNametextField = new JTextField();
        this.mimeTypeLabel = new JLabel();
        this.mimeTypeTextField = new JTextField();
        this.cpCheckBox = new JCheckBox();
        this.cpFileNameLabel = new JLabel();
        this.cpFileNameField = new JTextField();
        this.packageNameCombo = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.packageNameLabel = new JLabel();
        this.fileNameLabel.setLabelFor(this.fileNametextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNameLabel.text"));
        this.fileNametextField.setText(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNametextField.text"));
        this.mimeTypeLabel.setLabelFor(this.mimeTypeTextField);
        Mnemonics.setLocalizedText((JLabel)this.mimeTypeLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeLabel.text"));
        this.mimeTypeTextField.setText(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cpCheckBox, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpCheckBox.text"));
        this.cpCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CodeGeneratorPanel.this.cpCheckBoxStateChanged(changeEvent);
            }
        });
        this.cpFileNameLabel.setLabelFor(this.cpFileNameField);
        Mnemonics.setLocalizedText((JLabel)this.cpFileNameLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameLabel.text"));
        this.cpFileNameField.setEditable(this.cpCheckBox.isSelected());
        this.cpFileNameField.setText(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameField.text"));
        this.packageNameCombo.setEditable(true);
        this.packageNameLabel.setLabelFor(this.packageNameCombo);
        Mnemonics.setLocalizedText((JLabel)this.packageNameLabel, (String)NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.packageNameLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileNameLabel).add((Component)this.mimeTypeLabel).add((Component)this.packageNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileNametextField, -1, 304, Short.MAX_VALUE).add((Component)this.mimeTypeTextField, -1, 304, Short.MAX_VALUE).add((Component)this.packageNameCombo, 0, 304, Short.MAX_VALUE))).add((Component)this.cpCheckBox))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(33, 33, 33).add((Component)this.cpFileNameLabel).addPreferredGap(0).add((Component)this.cpFileNameField, -1, 172, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileNameLabel).add((Component)this.fileNametextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.packageNameCombo, -2, -1, -2).add((Component)this.packageNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.mimeTypeLabel).add((Component)this.mimeTypeTextField, -2, -1, -2)).add(18, 18, 18).add((Component)this.cpCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cpFileNameLabel).add((Component)this.cpFileNameField, -2, -1, -2)).addContainerGap(123, Short.MAX_VALUE)));
        this.fileNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNameLabel.AccessibleContext.accessibleDescription"));
        this.fileNametextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNametextField.AccessibleContext.accessibleName"));
        this.fileNametextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.fileNametextField.AccessibleContext.accessibleDescription"));
        this.mimeTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeLabel.AccessibleContext.accessibleDescription"));
        this.mimeTypeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeTextField.AccessibleContext.accessibleName"));
        this.mimeTypeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.mimeTypeTextField.AccessibleContext.accessibleDescription"));
        this.cpCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpCheckBox.AccessibleContext.accessibleDescription"));
        this.cpFileNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameLabel.AccessibleContext.accessibleDescription"));
        this.cpFileNameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameField.AccessibleContext.accessibleName"));
        this.cpFileNameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.cpFileNameField.AccessibleContext.accessibleDescription"));
        this.packageNameCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.packageNameCombo.AccessibleContext.accessibleDescription"));
        this.packageNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.packageNameLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeGeneratorPanel.class, (String)"CodeGeneratorPanel.AccessibleContext.accessibleDescription"));
    }

    private void cpCheckBoxStateChanged(ChangeEvent changeEvent) {
        this.cpFileNameField.setEditable(this.cpCheckBox.isSelected());
        this.checkValidity();
    }

    protected String getPanelName() {
        return NbBundle.getMessage(CodeGeneratorPanel.class, (String)"LBL_CodeGeneratorPanel_Title");
    }

    protected void storeToDataModel() {
        this.data.setMimeType(this.mimeTypeTextField.getText().trim());
        this.data.setFileName(this.normalize(this.fileNametextField.getText().trim()));
        this.data.setContextProviderRequired(this.cpCheckBox.isSelected());
        this.data.setProviderFileName(this.cpFileNameField.getText().trim());
        this.data.setPackageName(this.packageNameCombo.getEditor().getItem().toString());
        NewCodeGeneratorIterator.generateFileChanges(this.data);
    }

    protected void readFromDataModel() {
        this.mimeTypeTextField.setText(this.data.getMimeType());
        this.fileNametextField.setText(this.data.getFileName());
        this.cpFileNameField.setText(this.data.getProviderFileName());
        this.cpCheckBox.setSelected(this.data.isContextProviderRequired());
        this.packageNameCombo.setSelectedItem(this.data.getPackageName());
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(CodeGeneratorPanel.class);
    }

    private String normalize(String string) {
        if (string.endsWith(".java")) {
            return string.substring(0, string.length() - 5);
        }
        return string;
    }

    private boolean checkValidity() {
        String string = this.fileNametextField.getText().trim();
        String string2 = this.mimeTypeTextField.getText().trim();
        if (string.length() == 0) {
            this.setWarning(this.getMessage("ERR_FN_EMPTY"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.normalize(string))) {
            this.setError(this.getMessage("ERR_FN_INVALID"));
            return false;
        }
        if (string2.length() == 0) {
            this.setWarning(this.getMessage("ERR_MT_EMPTY"), false);
            return false;
        }
        String string3 = this.packageNameCombo.getEditor().getItem().toString();
        if (string3.equals("")) {
            this.setWarning(this.getMessage("EMPTY_PACKAGE"), false);
            return false;
        }
        if (this.cpCheckBox.isSelected()) {
            String string4 = this.cpFileNameField.getText().trim();
            if (string4.length() == 0) {
                this.setWarning(this.getMessage("ERR_FN_EMPTY"), false);
                return false;
            }
            if (!Utilities.isJavaIdentifier((String)this.normalize(string4))) {
                this.setError(this.getMessage("ERR_FN_INVALID"));
                return false;
            }
        }
        this.markValid();
        return true;
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(CodeGeneratorPanel.class, (String)string);
    }
}

