/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerJavadoc;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerSources;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsSupport;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class EditClusterPanel
extends JPanel
implements DocumentListener {
    private NbPlatformCustomizerSources sourcesPanel;
    private NbPlatformCustomizerJavadoc javadocPanel;
    private JButton okButton;
    private ClusterInfo clusterInfo;
    private File prjDir;
    private JButton browseButton;
    private JTextField clusterDirText;
    private JLabel jLabel1;
    private JPanel javadocPanelContainer;
    private JPanel sourcesPanelContainer;

    static ClusterInfo showAddDialog(Project project) {
        EditClusterPanel editClusterPanel = new EditClusterPanel();
        editClusterPanel.prjDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        SourceRootsSupport sourceRootsSupport = new SourceRootsSupport(new URL[0], null);
        editClusterPanel.sourcesPanel.setSourceRootsProvider(sourceRootsSupport);
        JavadocRootsSupport javadocRootsSupport = new JavadocRootsSupport(new URL[0], null);
        editClusterPanel.javadocPanel.setJavadocRootsProvider(javadocRootsSupport);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editClusterPanel, NbBundle.getMessage(EditClusterPanel.class, (String)"CTL_AddCluster_Title"), true, new Object[]{editClusterPanel.okButton, NotifyDescriptor.CANCEL_OPTION}, (Object)editClusterPanel.okButton, 0, new HelpCtx(EditClusterPanel.class), null);
        dialogDescriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        editClusterPanel.updateDialog();
        dialog.setVisible(true);
        ClusterInfo clusterInfo = null;
        if (dialogDescriptor.getValue() == editClusterPanel.okButton) {
            clusterInfo = ClusterInfo.createExternal(editClusterPanel.getAbsoluteClusterPath(), sourceRootsSupport.getSourceRoots(), javadocRootsSupport.getJavadocRoots(), true);
        }
        dialog.dispose();
        return clusterInfo;
    }

    static ClusterInfo showEditDialog(ClusterInfo clusterInfo, Project project) {
        EditClusterPanel editClusterPanel = new EditClusterPanel();
        editClusterPanel.prjDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        SourceRootsSupport sourceRootsSupport = new SourceRootsSupport(clusterInfo.getSourceRoots() == null ? new URL[]{} : clusterInfo.getSourceRoots(), null);
        editClusterPanel.sourcesPanel.setSourceRootsProvider(sourceRootsSupport);
        JavadocRootsSupport javadocRootsSupport = new JavadocRootsSupport(clusterInfo.getJavadocRoots() == null ? new URL[]{} : clusterInfo.getJavadocRoots(), null);
        editClusterPanel.javadocPanel.setJavadocRootsProvider(javadocRootsSupport);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editClusterPanel, NbBundle.getMessage(EditClusterPanel.class, (String)"CTL_EditCluster_Title"), true, new Object[]{editClusterPanel.okButton, NotifyDescriptor.CANCEL_OPTION}, (Object)editClusterPanel.okButton, 0, new HelpCtx(EditClusterPanel.class), null);
        dialogDescriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        editClusterPanel.clusterDirText.setText(clusterInfo.getClusterDir().toString());
        editClusterPanel.updateDialog();
        editClusterPanel.browseButton.setEnabled(false);
        dialog.setVisible(true);
        ClusterInfo clusterInfo2 = null;
        if (dialogDescriptor.getValue() == editClusterPanel.okButton) {
            clusterInfo2 = ClusterInfo.createExternal(editClusterPanel.getAbsoluteClusterPath(), sourceRootsSupport.getSourceRoots(), javadocRootsSupport.getJavadocRoots(), true);
        }
        dialog.dispose();
        return clusterInfo2;
    }

    public EditClusterPanel() {
        this.initComponents();
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(EditClusterPanel.class, (String)"CTL_OK"));
    }

    private File getAbsoluteClusterPath() {
        String string = this.clusterDirText.getText();
        return PropertyUtils.resolveFile((File)this.prjDir, (String)string);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.clusterDirText = new JTextField();
        this.browseButton = new JButton();
        this.sourcesPanelContainer = new JPanel();
        this.sourcesPanel = new NbPlatformCustomizerSources();
        this.sourcesPanelContainer.add(this.sourcesPanel);
        this.javadocPanelContainer = new JPanel();
        this.javadocPanel = new NbPlatformCustomizerJavadoc();
        this.javadocPanelContainer.add(this.javadocPanel);
        this.jLabel1.setDisplayedMnemonic('C');
        this.jLabel1.setLabelFor(this.clusterDirText);
        this.jLabel1.setText(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.jLabel1.text"));
        this.clusterDirText.setEditable(false);
        this.clusterDirText.setText(NbBundle.getMessage(EditClusterPanel.class, (String)"MSG_BrowseForCluster"));
        this.clusterDirText.getDocument().addDocumentListener(this);
        this.browseButton.setMnemonic('B');
        this.browseButton.setText(NbBundle.getMessage(EditClusterPanel.class, (String)"EditClusterPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditClusterPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.sourcesPanelContainer.setLayout(new CardLayout());
        this.javadocPanelContainer.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.clusterDirText, -1, 283, Short.MAX_VALUE).add(10, 10, 10).add((Component)this.browseButton, -2, 87, -2)).add((Component)this.jLabel1)).addContainerGap()).add((Component)this.javadocPanelContainer, -1, 400, Short.MAX_VALUE).add((Component)this.sourcesPanelContainer, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.clusterDirText, -2, -1, -2)).add(12, 12, 12).add((Component)this.sourcesPanelContainer, -1, 106, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.javadocPanelContainer, -1, 122, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastUsedClusterLocation());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            if (!file.exists() || file.isFile() || !ClusterUtils.isValidCluster(file)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(EditClusterPanel.class, (String)"MSG_NotValidCluster")));
            } else {
                ModuleUISettings.getDefault().setLastUsedClusterLocation(file.getParentFile().getAbsolutePath());
                String string = PropertyUtils.relativizeFile((File)this.prjDir, (File)file);
                this.clusterDirText.setText(string);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateDialog();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateDialog();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateDialog();
    }

    private void updateDialog() {
        this.okButton.setEnabled(this.getAbsoluteClusterPath().exists());
    }
}

