/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class ModuleLogicalView
implements LogicalViewProvider {
    private final NbModuleProject project;

    public ModuleLogicalView(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public Node createLogicalView() {
        return new RootNode(this.project);
    }

    public Node findPath(Node node, Object object) {
        DataObject dataObject;
        if (node.getLookup().lookup(NbModuleProject.class) != this.project) {
            return null;
        }
        if (object instanceof FileObject) {
            try {
                dataObject = DataObject.find((FileObject)((FileObject)object));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new AssertionError((Object)dataObjectNotFoundException);
            }
        } else if (object instanceof DataObject) {
            dataObject = (DataObject)object;
        } else {
            return null;
        }
        for (Node node2 : node.getChildren().getNodes(true)) {
            Node node3 = PackageView.findPath((Node)node2, (Object)object);
            if (node3 != null) {
                return node3;
            }
            if (!node2.getName().equals("important.files")) continue;
            for (Node node4 : node2.getChildren().getNodes(true)) {
                if (node4.getLookup().lookup(DataObject.class) != dataObject) continue;
                return node4;
            }
        }
        return null;
    }

    private static final class RootNode
    extends AbstractNode {
        private final NbModuleProject project;

        public RootNode(NbModuleProject nbModuleProject) {
            super(NodeFactorySupport.createCompositeChildren((Project)nbModuleProject, (String)"Projects/org-netbeans-modules-apisupport-project/Nodes"), Lookups.fixed((Object[])new Object[]{nbModuleProject}));
            this.project = nbModuleProject;
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)nbModuleProject);
            this.setDisplayName(projectInformation.getDisplayName());
            this.setShortDescription(NbBundle.getMessage(ModuleLogicalView.class, (String)"HINT_project_root_node", (Object)FileUtil.getFileDisplayName((FileObject)nbModuleProject.getProjectDirectory())));
            projectInformation.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                    ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                        public void run() {
                            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                                RootNode.this.setDisplayName((String)propertyChangeEvent.getNewValue());
                            } else if ("name".equals(propertyChangeEvent.getPropertyName())) {
                                RootNode.this.setName((String)propertyChangeEvent.getNewValue());
                            }
                        }
                    });
                }
            });
        }

        public Action[] getActions(boolean bl) {
            return ModuleActions.getProjectActions(this.project);
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, (String)string);
        }
    }
}

