/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Evaluator
implements PropertyEvaluator,
PropertyChangeListener,
AntProjectListener {
    private final NbModuleProject project;
    private final NbModuleProvider typeProvider;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyEvaluator delegate;
    private volatile boolean loadedModuleList = false;
    private boolean runInAtomicAction;
    private boolean pendingReset = false;
    private static final Pattern ANT_PROP_REGEX = Pattern.compile("\\$\\{([a-zA-Z0-9._-]+)\\}");
    private static final Set<String> warnedModules = Collections.synchronizedSet(new HashSet());

    public Evaluator(NbModuleProject nbModuleProject, NbModuleProvider nbModuleProvider) {
        this.project = nbModuleProject;
        this.typeProvider = nbModuleProvider;
        this.delegate = this.createEvaluator(null);
        this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        nbModuleProject.getHelper().addAntProjectListener((AntProjectListener)this);
    }

    public String getProperty(String string) {
        PropertyEvaluator propertyEvaluator = this.delegatingEvaluator(false);
        assert (propertyEvaluator != this);
        String string2 = propertyEvaluator.getProperty(string);
        if (string2 == null && this.isModuleListDependentProperty(string) || this.isModuleListDependentValue(string2)) {
            return this.delegatingEvaluator(true).getProperty(string);
        }
        return string2;
    }

    public String evaluate(String string) {
        String string2 = this.delegatingEvaluator(false).evaluate(string);
        if (this.isModuleListDependentValue(string2)) {
            return this.delegatingEvaluator(true).evaluate(string);
        }
        return string2;
    }

    public Map<String, String> getProperties() {
        return this.delegatingEvaluator(true).getProperties();
    }

    private boolean isModuleListDependentProperty(String string) {
        return string.equals("module.classpath") || string.equals("cp") || string.endsWith(".cp") || string.endsWith(".cp.extra");
    }

    private boolean isModuleListDependentValue(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = ANT_PROP_REGEX.matcher(string);
        while (matcher.find()) {
            if (!this.isModuleListDependentProperty(matcher.group(1))) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private PropertyEvaluator delegatingEvaluator(final boolean bl) {
        return (PropertyEvaluator)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<PropertyEvaluator>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PropertyEvaluator run() {
                if (bl && !Evaluator.this.loadedModuleList) {
                    Evaluator.this.reset();
                    if (Util.err.isLoggable(1)) {
                        Util.err.log("Needed to reset evaluator in " + Evaluator.this.project + "due to use of module-list-dependent property; now cp=" + Evaluator.this.delegate.getProperty("cp"));
                    }
                }
                Evaluator evaluator = Evaluator.this;
                synchronized (evaluator) {
                    return Evaluator.this.delegate;
                }
            }
        });
    }

    private void reset() {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                ModuleList moduleList;
                try {
                    moduleList = Evaluator.this.project.getModuleList();
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    return null;
                }
                Evaluator evaluator = Evaluator.this;
                synchronized (evaluator) {
                    Evaluator.this.loadedModuleList = true;
                    Evaluator.this.delegate.removePropertyChangeListener((PropertyChangeListener)Evaluator.this);
                    Evaluator.this.delegate = Evaluator.this.createEvaluator(moduleList);
                    Evaluator.this.delegate.addPropertyChangeListener((PropertyChangeListener)Evaluator.this);
                }
                Evaluator.this.pcs.firePropertyChange(null, null, null);
                return null;
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("netbeans.dest.dir".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getPropertyName() == null) {
            this.reset();
        } else {
            Util.err.log("Refiring property change from delegate in " + propertyChangeEvent.getPropertyName() + " for " + this.project);
            this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            if (this.runInAtomicAction) {
                this.pendingReset = true;
            } else {
                this.reset();
            }
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    public void setRunInAtomicAction(boolean bl) {
        assert (bl != this.runInAtomicAction) : "Nested calls not supported";
        this.runInAtomicAction = bl;
        if (!bl && this.pendingReset) {
            this.reset();
        }
        this.pendingReset = false;
    }

    boolean isRunInAtomicAction() {
        return this.runInAtomicAction;
    }

    public void removeListeners() {
        this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
        this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
    }

    /*
     * WARNING - void declaration
     */
    private PropertyEvaluator createEvaluator(ModuleList moduleList) {
        Object object;
        Object object2;
        Object object33;
        Object object32;
        CharSequence charSequence;
        Object object6;
        Serializable serializable;
        File file;
        PropertyProvider propertyProvider = this.project.getHelper().getStockPropertyPreprovider();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        File file2 = this.project.getProjectDirectoryFile();
        NbModuleProvider.NbModuleType nbModuleType = this.typeProvider.getModuleType();
        PropertyProvider propertyProvider2 = this.project.getHelper().getPropertyProvider("nbproject/private/private.properties");
        PropertyProvider propertyProvider3 = this.project.getHelper().getPropertyProvider("nbproject/project.properties");
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            file = ModuleList.findNetBeansOrg(file2);
            assert (file != null) : "netbeans.org-type module not in a complete netbeans.org source root " + file2;
            hashMap.put("nb_all", file.getAbsolutePath());
            serializable = ModuleList.findNetBeansOrgDestDir(file);
            hashMap.put("netbeans.dest.dir", ((File)serializable).getAbsolutePath());
            object6 = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.propertiesFilePropertyProvider((File)new File(file, "nbbuild/cluster.properties"))}).getProperties();
            if (object6 != null) {
                void entry;
                charSequence = new StringBuilder();
                object32 = new PropertyProvider[]{propertyProvider2, propertyProvider3};
                int n = ((PropertyProvider[])object32).length;
                boolean bl = false;
                while (entry < n) {
                    PropertyProvider propertyProvider4 = object32[entry];
                    for (Object object33 : propertyProvider4.getProperties().values()) {
                        ((StringBuilder)charSequence).append((String)object33);
                    }
                    ++entry;
                }
                object32 = ((StringBuilder)charSequence).toString();
                for (Map.Entry file3 : object6.entrySet()) {
                    String string = (String)file3.getKey();
                    if (!string.endsWith(".dir")) continue;
                    object2 = new File((File)serializable, (String)file3.getValue()).getAbsolutePath().intern();
                    object33 = (String)object6.get(string.substring(0, string.length() - 4));
                    if (object33 == null) continue;
                    for (String string2 : ((String)object33).split(",")) {
                        String string3 = string2 + ".dir";
                        if (!((String)object32).contains(string3)) continue;
                        hashMap.put(string3.intern(), object2);
                    }
                }
            }
        } else {
            file = null;
        }
        serializable = new ArrayList<PropertyProvider>();
        serializable.add(PropertyUtils.fixedPropertyProvider(hashMap));
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            serializable.add(this.project.getHelper().getPropertyProvider("nbproject/private/suite-private.properties"));
            serializable.add(this.project.getHelper().getPropertyProvider("nbproject/suite.properties"));
        }
        object6 = this.project.getCodeNameBase();
        charSequence = null;
        object32 = null;
        try {
            charSequence = ModuleList.findClusterLocation(file2, file, nbModuleType);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, iOException);
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            object32 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])serializable.toArray(new PropertyProvider[serializable.size()]));
            charSequence = FileUtil.normalizeFile((File)new File(object32.evaluate((String)charSequence))).getAbsolutePath();
        }
        if (charSequence != null) {
            serializable.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("cluster", charSequence)));
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            object = object32.getProperty("suite.dir");
            if (object != null) {
                File hashMap2 = PropertyUtils.resolveFile((File)file2, (String)object);
                serializable.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(hashMap2, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                serializable.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(hashMap2, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (nbModuleType == NbModuleProvider.STANDALONE) {
            serializable.add(this.project.getHelper().getPropertyProvider("nbproject/private/platform-private.properties"));
            serializable.add(this.project.getHelper().getPropertyProvider("nbproject/platform.properties"));
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT || nbModuleType == NbModuleProvider.STANDALONE) {
            object = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])serializable.toArray(new PropertyProvider[serializable.size()]));
            serializable.add(new Util.UserPropertiesFileProvider((PropertyEvaluator)object, file2));
            object = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])serializable.toArray(new PropertyProvider[serializable.size()]));
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DestDirProvider
            extends Util.ComputedPropertyProvider {
                public DestDirProvider(PropertyEvaluator propertyEvaluator) {
                    super(propertyEvaluator);
                }

                @Override
                protected Map<String, String> getProperties(Map<String, String> map) {
                    String string = map.get("nbplatform.active");
                    if (string != null) {
                        return Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + string + ".netbeans.dest.dir}");
                    }
                    return Collections.emptyMap();
                }

                @Override
                protected Set<String> inputProperties() {
                    return Collections.singleton("nbplatform.active");
                }
            }
            serializable.add(new DestDirProvider((PropertyEvaluator)object));
        }
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            object = new File(file, "nbbuild");
            serializable.add(PropertyUtils.propertiesFilePropertyProvider((File)new File((File)object, "user.build.properties")));
            serializable.add(PropertyUtils.propertiesFilePropertyProvider((File)new File((File)object, "site.build.properties")));
            serializable.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(System.getProperty("user.home"), ".nbbuild.properties")));
        }
        object = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])serializable.toArray(new PropertyProvider[serializable.size()]));
        serializable.add(new NbJdkProvider((PropertyEvaluator)object));
        serializable.add(propertyProvider2);
        serializable.add(propertyProvider3);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (object6 != null) {
            hashMap2.put("code.name.base.dashes", ((String)object6).replace('.', '-'));
        }
        hashMap2.put("module.jar.dir", "modules");
        hashMap2.put("module.jar.basename", "${code.name.base.dashes}.jar");
        hashMap2.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        hashMap2.put("manifest.mf", "manifest.mf");
        hashMap2.put("src.dir", "src");
        hashMap2.put("build.classes.dir", "build/classes");
        hashMap2.put("javac.source", "1.4");
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            hashMap2.put("test.user.dir", "${nb_all}/nbbuild/testuserdir");
        } else if (nbModuleType == NbModuleProvider.STANDALONE) {
            hashMap2.put("test.user.dir", "build/testuserdir");
        } else {
            hashMap2.put("test.user.dir", "${suite.dir}/build/testuserdir");
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(NbModuleProject.COMMON_TEST_TYPES));
        for (Object object33 : hashSet) {
            hashMap2.put("test." + (String)object33 + ".src.dir", "test/" + (String)object33 + "/src");
            hashMap2.put("test." + (String)object33 + ".data.dir", "test/" + (String)object33 + "/data");
            hashMap2.put("build.test." + (String)object33 + ".classes.dir", "build/test/" + (String)object33 + "/classes");
        }
        serializable.add(PropertyUtils.fixedPropertyProvider(hashMap2));
        if (moduleList != null) {
            serializable.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.classpath", this.computeModuleClasspath(moduleList))));
            serializable.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.run.classpath", this.computeRuntimeModuleClasspath(moduleList))));
            object2 = new HashMap();
            object2.put("cp.extra", "");
            object2.put("cp", "${module.classpath}:${cp.extra}");
            object2.put("run.cp", "${module.run.classpath}:${cp.extra}:${build.classes.dir}");
            object = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])serializable.toArray(new PropertyProvider[serializable.size()]));
            object33 = this.computeTestingClassPaths(moduleList, (PropertyEvaluator)object, (Set<String>)hashSet);
            hashSet.addAll(object33.keySet());
            for (String string : hashSet) {
                String string2;
                object2.put("test." + string + ".cp.extra", "");
                TestClasspath testClasspath = TestClasspath.getOrEmpty((Map)object33, string);
                string2 = "${module.run.classpath}:${cp.extra}:${cluster}/${module.jar}:${test." + string + ".cp.extra}:";
                object2.put("test." + string + ".cp", string2 + testClasspath.getCompileClasspath());
                object2.put("test." + string + ".run.cp.extra", "");
                object2.put("test." + string + ".run.cp", string2 + "${build.test." + string + ".classes.dir}:${test." + string + ".run.cp.extra}:" + testClasspath.getRuntimeClasspath());
            }
            serializable.add(PropertyUtils.fixedPropertyProvider((Map)object2));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])serializable.toArray(new PropertyProvider[serializable.size()]));
    }

    private String computeModuleClasspath(ModuleList moduleList) {
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/3");
        assert (element2 != null) : "Malformed metadata in " + this.project;
        StringBuffer stringBuffer = new StringBuffer();
        for (Element element3 : Util.findSubElements(element2)) {
            if (Util.findElement(element3, "compile-dependency", "http://www.netbeans.org/ns/nb-module-project/3") == null) continue;
            Element element4 = Util.findElement(element3, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/3");
            String string = Util.findText(element4);
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Warning - could not find dependent module " + string + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            File file = moduleEntry.getJarLocation();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append(moduleEntry.getClassPathExtensions());
        }
        ModuleEntry moduleEntry = moduleList.getEntry(this.project.getCodeNameBase());
        if (moduleEntry == null) {
            return "";
        }
        stringBuffer.append(moduleEntry.getClassPathExtensions());
        return stringBuffer.toString();
    }

    private String computeRuntimeModuleClasspath(ModuleList moduleList) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.project.getCodeNameBase());
        HashSet<String> hashSet2 = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (!hashSet.isEmpty()) {
            object = hashSet.iterator();
            String string = (String)object.next();
            object.remove();
            if (!hashSet2.add(string)) continue;
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Warning - could not find dependent module " + string + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            if (!string.equals(this.project.getCodeNameBase())) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparatorChar);
                }
                stringBuffer.append(moduleEntry.getJarLocation().getAbsolutePath());
                stringBuffer.append(moduleEntry.getClassPathExtensions());
            }
            String[] stringArray = moduleEntry.getRunDependencies();
            hashSet.addAll(Arrays.asList(stringArray));
        }
        object = moduleList.getEntry(this.project.getCodeNameBase());
        if (object != null) {
            stringBuffer.append(object.getClassPathExtensions());
        }
        return stringBuffer.toString();
    }

    private Map<String, TestClasspath> computeTestingClassPaths(ModuleList moduleList, PropertyEvaluator propertyEvaluator, Set<String> set) {
        HashMap<String, TestClasspath> hashMap = new HashMap<String, TestClasspath>();
        ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
        Map<String, Set<TestModuleDependency>> map = projectXMLManager.getTestDependencies(moduleList);
        String string = propertyEvaluator.getProperty("test.dist.dir");
        if (string == null) {
            Object object2 = this.typeProvider.getModuleType();
            if (object2 == NbModuleProvider.NETBEANS_ORG) {
                String object = propertyEvaluator.getProperty("nb_all");
                string = object + File.separatorChar + "nbbuild" + File.separatorChar + "build" + File.separatorChar + "testdist";
            } else if (object2 == NbModuleProvider.SUITE_COMPONENT) {
                String string2 = propertyEvaluator.getProperty("suite.dir");
                string = string2 + File.separatorChar + "build" + File.separatorChar + "testdist";
            } else {
                String string3 = propertyEvaluator.getProperty("module.dir");
                string = string3 + File.separatorChar + "build" + File.separatorChar + "testdist";
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            this.computeTestType((String)entry.getKey(), new File(string), (Set)entry.getValue(), hashMap, moduleList);
        }
        for (String string4 : set) {
            if (map.containsKey(string4)) continue;
            this.computeTestType(string4, new File(string), Collections.<TestModuleDependency>emptySet(), hashMap, moduleList);
        }
        return hashMap;
    }

    private void computeTestType(String string, File file, Set<TestModuleDependency> set, Map<String, TestClasspath> map, ModuleList moduleList) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        Logger logger = Logger.getLogger(Evaluator.class.getName());
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (TestModuleDependency object2 : set) {
            String string2 = object2.getModule().getCodeNameBase();
            logger.fine("computeTestType: processing '" + string2 + "'");
            if (object2.isRecursive()) {
                HashSet<String> hashSet5 = new HashSet<String>();
                String string3 = this.project.getCodeNameBase();
                hashSet5.add(object2.getModule().getCodeNameBase());
                while (!hashSet5.isEmpty()) {
                    Iterator iterator = hashSet5.iterator();
                    String string4 = (String)iterator.next();
                    iterator.remove();
                    Boolean bl = (Boolean)hashMap.get(string4);
                    if (Boolean.TRUE.equals(bl)) continue;
                    if (Boolean.FALSE.equals(bl) && !object2.isCompile()) continue;
                    logger.fine("computeTestType: processing '" + string4 + "'");
                    ModuleEntry moduleEntry = moduleList.getEntry(string4);
                    if (moduleEntry == null) {
                        Util.err.log(16, "Warning - could not find dependent module " + string4 + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                        continue;
                    }
                    if (!string4.equals(string3)) {
                        hashSet2.add(string4);
                        if (object2.isCompile()) {
                            hashSet.add(string4);
                        }
                        hashMap.put(string4, object2.isCompile());
                    }
                    String[] stringArray = moduleEntry.getRunDependencies();
                    hashSet5.addAll(Arrays.asList(stringArray));
                }
            } else {
                hashSet2.add(string2);
                if (object2.isCompile()) {
                    hashSet.add(string2);
                }
            }
            if (!object2.isTest()) continue;
            if (object2.isCompile()) {
                hashSet3.add(string2);
            }
            hashSet4.add(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        TestClasspath testClasspath = new TestClasspath(this.mergePaths(hashSet, false, string, file, moduleList) + stringBuilder, this.mergePaths(hashSet2, false, string, file, moduleList) + stringBuilder, this.mergePaths(hashSet3, true, string, file, moduleList), this.mergePaths(hashSet4, true, string, file, moduleList));
        map.put(string, testClasspath);
    }

    private String mergePaths(Set<String> set, boolean bl, String string, File file, ModuleList moduleList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : set) {
            ModuleEntry moduleEntry = moduleList.getEntry(string2);
            if (moduleEntry == null) {
                if (!warnedModules.add(string2)) continue;
                Logger.getLogger(Evaluator.class.getName()).warning("Cannot find test module dependency: " + string2);
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(':');
            }
            if (bl) {
                File file2 = moduleEntry.getClusterDirectory();
                if (file2 == null) continue;
                String string3 = file2.getName();
                char c = File.separatorChar;
                File file3 = new File(file, string + c + string3 + c + string2.replace('.', '-') + c + "tests.jar");
                stringBuffer.append(file3.getPath());
                if (string.equals("unit")) continue;
                stringBuffer.append(':');
                file3 = new File(file, "unit" + c + string3 + c + string2.replace('.', '-') + c + "tests.jar");
                stringBuffer.append(file3.getPath());
                continue;
            }
            stringBuffer.append(moduleEntry.getJarLocation().getPath());
            stringBuffer.append(moduleEntry.getClassPathExtensions());
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NbJdkProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);

        public NbJdkProvider(PropertyEvaluator propertyEvaluator) {
            this.eval = propertyEvaluator;
            propertyEvaluator.addPropertyChangeListener(this.weakListener);
            JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakListener);
        }

        public final Map<String, String> getProperties() {
            Object object;
            Object object2;
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = this.eval.getProperty("nbjdk.home");
            if (string2 == null && (string = this.eval.getProperty("nbjdk.active")) != null && !string.equals("default") && (string2 = this.eval.getProperty("platforms." + string + ".home")) != null) {
                hashMap.put("nbjdk.home", string2);
            }
            if (string2 == null && (string = JavaPlatformManager.getDefault().getDefaultPlatform()) != null && (object2 = string.getInstallFolders()).size() == 1) {
                string2 = FileUtil.toFile((FileObject)((FileObject)object2.iterator().next())).getAbsolutePath();
            }
            string = null;
            if (string2 != null) {
                object2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string2)));
                if (object2 != null) {
                    object = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    int n = ((JavaPlatform[])object).length;
                    for (int i = 0; i < n; ++i) {
                        String[] stringArray = object[i];
                        if (!new HashSet(stringArray.getInstallFolders()).equals(Collections.singleton(object2))) continue;
                        ClassPath classPath = stringArray.getBootstrapLibraries();
                        classPath.removePropertyChangeListener(this.weakListener);
                        classPath.addPropertyChangeListener(this.weakListener);
                        string = classPath.toString(ClassPath.PathConversionMode.WARN);
                        break;
                    }
                }
                if (string == null) {
                    if (Utilities.isMac()) {
                        string = "${nbjdk.home}/../Classes/classes.jar";
                    } else if (string2 != null && ((File)(object = new File(string2, "jre/lib"))).isDirectory()) {
                        String[] stringArray = ((File)object).list(new FilenameFilter(){

                            public boolean accept(File file, String string) {
                                String string2 = string.toLowerCase(Locale.US);
                                return string2.endsWith(".jar");
                            }
                        });
                        StringBuilder stringBuilder = new StringBuilder();
                        for (String string3 : stringArray) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(File.pathSeparator);
                            }
                            stringBuilder.append("${nbjdk.home}/jre/lib/").append(string3);
                        }
                        string = stringBuilder.toString().replace('/', File.separatorChar);
                    } else {
                        string = "${nbjdk.home}/jre/lib/rt.jar".replace('/', File.separatorChar);
                    }
                }
            }
            if (string == null) {
                string = "${sun.boot.class.path}";
            }
            hashMap.put("nbjdk.bootclasspath", string);
            if (string2 != null && !Utilities.isMac()) {
                hashMap.put("tools.jar", string2 + "/lib/tools.jar".replace('/', File.separatorChar));
            }
            if (Util.err.isLoggable(1)) {
                object2 = new TreeMap(this.eval.getProperties());
                object = object2.keySet().iterator();
                while (object.hasNext()) {
                    String string4 = (String)object.next();
                    if (string4.startsWith("nbjdk.") || string4.startsWith("platforms.")) continue;
                    object.remove();
                }
                object2.putAll(hashMap);
                Util.err.log("JDK-related properties of " + Evaluator.this.project + ": " + object2);
            }
            return hashMap;
        }

        public final void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public final void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!(string == null || string.startsWith("nbjdk.") || string.startsWith("platforms.") || string.equals("entries") || string.equals("installedPlatforms"))) {
                return;
            }
            if (!this.changeSupport.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    NbJdkProvider.this.changeSupport.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RequestProcessor.getDefault().post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }
    }

    private static class TestClasspath {
        private final String compile;
        private final String runtime;
        private final String testCompile;
        private final String testRuntime;

        public TestClasspath(String string, String string2, String string3, String string4) {
            this.compile = string;
            this.runtime = string2;
            this.testCompile = string3;
            this.testRuntime = string4;
        }

        public String getCompileClasspath() {
            return this.compile + ':' + this.testCompile;
        }

        public String getRuntimeClasspath() {
            return this.runtime + ':' + this.testRuntime;
        }

        private static TestClasspath getOrEmpty(Map map, String string) {
            TestClasspath testClasspath = (TestClasspath)map.get(string);
            if (testClasspath == null) {
                testClasspath = new TestClasspath("", "", "", "");
            }
            return testClasspath;
        }
    }
}

