/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotations
implements DocumentListener {
    private HashMap<Mark, LineAnnotations> lineAnnotationsByMark = new HashMap(30);
    private ArrayList<LineAnnotations> lineAnnotationsArray = new ArrayList(20);
    private DrawLayerFactory.AnnotationLayer drawLayer = null;
    private BaseDocument doc;
    private EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener l;
    private boolean glyphColumn = false;
    private boolean glyphButtonColumn = false;
    private boolean menuInitialized = false;
    public static final Comparator<JMenu> MENU_COMPARATOR = new MenuComparator();

    public Annotations(BaseDocument baseDocument) {
        this.doc = baseDocument;
        baseDocument.addLayer(new DrawLayerFactory.AnnotationLayer(baseDocument), 2100);
        this.doc.addDocumentListener(this);
        this.l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AnnotationDesc annotationDesc;
                if (propertyChangeEvent.getPropertyName() == null || "annotationType".equals(propertyChangeEvent.getPropertyName())) {
                    annotationDesc = (AnnotationDesc)propertyChangeEvent.getSource();
                    LineAnnotations lineAnnotations = (LineAnnotations)Annotations.this.lineAnnotationsByMark.get(annotationDesc.getMark());
                    lineAnnotations.refreshAnnotations();
                    Annotations.this.refreshLine(lineAnnotations.getLine());
                }
                if (propertyChangeEvent.getPropertyName() == null || "moveToFront".equals(propertyChangeEvent.getPropertyName())) {
                    annotationDesc = (AnnotationDesc)propertyChangeEvent.getSource();
                    Annotations.this.frontAnnotation(annotationDesc);
                }
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null || "combineGlyphs".equals(propertyChangeEvent.getPropertyName())) {
                    for (LineAnnotations lineAnnotations : Annotations.this.lineAnnotationsArray) {
                        lineAnnotations.refreshAnnotations();
                    }
                }
                if (propertyChangeEvent.getPropertyName() == null || "annotationTypes".equals(propertyChangeEvent.getPropertyName())) {
                    for (LineAnnotations lineAnnotations : Annotations.this.lineAnnotationsArray) {
                        Iterator<AnnotationDesc> iterator = lineAnnotations.getAnnotations();
                        while (iterator.hasNext()) {
                            AnnotationDesc annotationDesc = iterator.next();
                            annotationDesc.updateAnnotationType();
                        }
                    }
                }
                Annotations.this.fireChangedAll();
            }
        });
    }

    public synchronized DrawLayerFactory.AnnotationLayer getLayer() {
        if (this.drawLayer == null) {
            this.drawLayer = (DrawLayerFactory.AnnotationLayer)this.doc.findLayer("annotation-layer");
        }
        return this.drawLayer;
    }

    public void addAnnotation(AnnotationDesc annotationDesc) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be run in EQ");
        }
        MarkChain markChain = this.getLayer().getMarkChain();
        try {
            markChain.addMark(annotationDesc.getOffset(), true);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException("offset=" + annotationDesc.getOffset() + ", docLen=" + this.doc.getLength());
        }
        MarkFactory.ChainDrawMark chainDrawMark = markChain.getAddedMark();
        if (chainDrawMark == null) {
            throw new NullPointerException();
        }
        annotationDesc.setMark(chainDrawMark);
        LineAnnotations lineAnnotations = this.lineAnnotationsByMark.get(chainDrawMark);
        if (lineAnnotations == null) {
            lineAnnotations = this.getLineAnnotations(annotationDesc.getLine());
            if (lineAnnotations == null) {
                lineAnnotations = new LineAnnotations();
                lineAnnotations.addAnnotation(annotationDesc);
                if (this.lineAnnotationsByMark.put(annotationDesc.getMark(), lineAnnotations) != null) {
                    throw new IllegalStateException("Mark already in the map.");
                }
                boolean bl = false;
                for (int i = 0; i < this.lineAnnotationsArray.size(); ++i) {
                    if (this.lineAnnotationsArray.get(i).getLine() <= lineAnnotations.getLine()) continue;
                    this.lineAnnotationsArray.add(i, lineAnnotations);
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.lineAnnotationsArray.add(lineAnnotations);
                }
            } else {
                lineAnnotations.addAnnotation(annotationDesc);
                if (this.lineAnnotationsByMark.get(annotationDesc.getMark()) == null) {
                    this.lineAnnotationsByMark.put(annotationDesc.getMark(), lineAnnotations);
                }
            }
        } else {
            lineAnnotations.addAnnotation(annotationDesc);
        }
        annotationDesc.addPropertyChangeListener(this.l);
        if (annotationDesc.isVisible() && (!annotationDesc.isDefaultGlyph() || annotationDesc.isDefaultGlyph() && lineAnnotations.getCount() > 1)) {
            this.glyphColumn = true;
        }
        if (lineAnnotations.getCount() > 1) {
            this.glyphButtonColumn = true;
        }
        this.refreshLine(lineAnnotations.getLine());
    }

    public void removeAnnotation(AnnotationDesc annotationDesc) {
        int n;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be run in EQ");
        }
        MarkFactory.ChainDrawMark chainDrawMark = (MarkFactory.ChainDrawMark)annotationDesc.getMark();
        if (chainDrawMark == null) {
            return;
        }
        LineAnnotations lineAnnotations = this.lineAnnotationsByMark.get(chainDrawMark);
        int n2 = lineAnnotations.getLine();
        lineAnnotations.removeAnnotation(annotationDesc);
        if (!lineAnnotations.isMarkStillReferenced(chainDrawMark)) {
            if (this.lineAnnotationsByMark.remove(chainDrawMark) != lineAnnotations) {
                throw new IllegalStateException();
            }
            MarkChain markChain = this.getLayer().getMarkChain();
            if (!markChain.removeMark(chainDrawMark)) {
                throw new IllegalStateException("Mark not removed");
            }
        }
        if (lineAnnotations.getCount() == 0 && (n = this.lineAnnotationsArray.indexOf(lineAnnotations)) != -1) {
            this.lineAnnotationsArray.remove(n);
        }
        annotationDesc.setMark(null);
        annotationDesc.removePropertyChangeListener(this.l);
        this.refreshLine(n2);
    }

    public AnnotationDesc getActiveAnnotation(Mark mark) {
        LineAnnotations lineAnnotations = this.lineAnnotationsByMark.get(mark);
        if (lineAnnotations == null) {
            return null;
        }
        AnnotationDesc annotationDesc = lineAnnotations.getActive();
        if (annotationDesc == null || annotationDesc.getMark() != mark) {
            return null;
        }
        return annotationDesc;
    }

    AnnotationDesc getLineActiveAnnotation(Mark mark) {
        LineAnnotations lineAnnotations = this.lineAnnotationsByMark.get(mark);
        if (lineAnnotations == null) {
            return null;
        }
        AnnotationDesc annotationDesc = lineAnnotations.getActive();
        return annotationDesc;
    }

    protected LineAnnotations getLineAnnotations(int n) {
        int n2 = 0;
        int n3 = this.lineAnnotationsArray.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            LineAnnotations lineAnnotations = this.lineAnnotationsArray.get(n4);
            int n5 = lineAnnotations.getLine();
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            return lineAnnotations;
        }
        return null;
    }

    public AnnotationDesc getActiveAnnotation(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return null;
        }
        return lineAnnotations.getActive();
    }

    public void frontAnnotation(AnnotationDesc annotationDesc) {
        int n = annotationDesc.getLine();
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return;
        }
        lineAnnotations.activate(annotationDesc);
        this.refreshLine(n);
    }

    public AnnotationDesc activateNextAnnotation(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return null;
        }
        AnnotationDesc annotationDesc = lineAnnotations.activateNext();
        this.refreshLine(n);
        return annotationDesc;
    }

    public int getNextLineWithAnnotation(int n) {
        int n2;
        LineAnnotations lineAnnotations;
        int n3;
        int n4 = 0;
        int n5 = this.lineAnnotationsArray.size() - 1;
        while (n4 <= n5) {
            n3 = (n4 + n5) / 2;
            lineAnnotations = this.lineAnnotationsArray.get(n3);
            n2 = lineAnnotations.getLine();
            if (n < n2) {
                n5 = n3 - 1;
                continue;
            }
            if (n > n2) {
                n4 = n3 + 1;
                continue;
            }
            return n2;
        }
        for (n3 = n4; n3 < this.lineAnnotationsArray.size(); ++n3) {
            lineAnnotations = this.lineAnnotationsArray.get(n3);
            n2 = lineAnnotations.getLine();
            if (n2 < n) continue;
            return n2;
        }
        return -1;
    }

    public AnnotationDesc getAnnotation(int n, String string) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations != null) {
            return lineAnnotations.getType(string);
        }
        return null;
    }

    public AnnotationDesc[] getPasiveAnnotations(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return null;
        }
        if (lineAnnotations.getCount() <= 1) {
            return null;
        }
        return lineAnnotations.getPasive();
    }

    public AnnotationDesc[] getPassiveAnnotations(int n) {
        int n2 = this.doc.getDefaultRootElement().getElementIndex(n);
        return n2 >= 0 ? this.getPasiveAnnotations(n2) : null;
    }

    public int getNumberOfAnnotations(int n) {
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        if (lineAnnotations == null) {
            return 0;
        }
        return lineAnnotations.getCount();
    }

    protected void refreshLine(int n) {
        this.fireChangedLine(n);
        int n2 = Utilities.getRowStartFromLineOffset(this.doc, n);
        int n3 = Utilities.getRowStartFromLineOffset(this.doc, n + 1);
        if (n3 == -1) {
            n3 = this.doc.getLength();
        }
        this.doc.repaintBlock(n2, n3);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
        int n = baseDocumentEvent.getLFCount();
        if (n == 0) {
            return;
        }
        this.fireChangedAll();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
        int n = baseDocumentEvent.getLFCount();
        if (n == 0) {
            return;
        }
        this.fireChangedAll();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void addAnnotationsListener(AnnotationsListener annotationsListener) {
        this.listenerList.add(AnnotationsListener.class, annotationsListener);
    }

    public void removeAnnotationsListener(AnnotationsListener annotationsListener) {
        this.listenerList.remove(AnnotationsListener.class, annotationsListener);
    }

    protected void fireChangedLine(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AnnotationsListener.class) continue;
            ((AnnotationsListener)objectArray[i + 1]).changedLine(n);
        }
    }

    protected void fireChangedAll() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AnnotationsListener.class) continue;
            ((AnnotationsListener)objectArray[i + 1]).changedAll();
        }
    }

    public boolean isGlyphColumn() {
        return this.glyphColumn;
    }

    public boolean isGlyphButtonColumn() {
        return this.glyphButtonColumn;
    }

    private void addAcceleretors(Action action, JMenuItem jMenuItem, BaseKit baseKit) {
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null) {
            return;
        }
        Keymap keymap = jTextComponent.getKeymap();
        if (keymap != null) {
            KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
            if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                jMenuItem.setAccelerator(keyStrokeArray[0]);
            } else {
                String string = (String)action.getValue("Name");
                if (string == null) {
                    return;
                }
                BaseAction baseAction = (BaseAction)baseKit.getActionByName(string);
                if (baseAction == null) {
                    return;
                }
                keyStrokeArray = keymap.getKeyStrokesForAction(baseAction);
                if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                }
            }
        }
    }

    private Action getAction(AnnotationDesc annotationDesc, Action action) {
        if (action instanceof ContextAwareAction && annotationDesc instanceof Lookup.Provider) {
            Lookup lookup = ((Lookup.Provider)annotationDesc).getLookup();
            action = ((ContextAwareAction)action).createContextAwareInstance(lookup);
        }
        return action;
    }

    private JMenuItem createMenuItem(Action action, BaseKit baseKit) {
        JMenuItem jMenuItem;
        if (action instanceof BaseAction) {
            jMenuItem = new JMenuItem(((BaseAction)action).getPopupMenuText(null));
            jMenuItem.addActionListener(action);
            this.addAcceleretors(action, jMenuItem, baseKit);
        } else if (action instanceof Presenter.Popup) {
            jMenuItem = ((Presenter.Popup)action).getPopupPresenter();
        } else {
            jMenuItem = new JMenuItem((String)action.getValue("Name"));
            Actions.connect((JMenuItem)jMenuItem, (Action)action, (boolean)true);
            this.addAcceleretors(action, jMenuItem, baseKit);
        }
        return jMenuItem;
    }

    public JPopupMenu createPopupMenu(BaseKit baseKit, int n) {
        return this.createMenu(baseKit, n, false).getPopupMenu();
    }

    private JMenu createSubMenu(AnnotationDesc annotationDesc, BaseKit baseKit) {
        JMenu jMenu = null;
        Action[] actionArray = annotationDesc.getActions();
        if (actionArray != null) {
            jMenu = new JMenu(annotationDesc.getAnnotationTypeInstance().getDescription());
            for (int i = 0; i < actionArray.length; ++i) {
                JMenuItem jMenuItem = this.createMenuItem(this.getAction(annotationDesc, actionArray[i]), baseKit);
                if (jMenuItem instanceof DynamicMenuContent) {
                    JComponent[] jComponentArray;
                    for (JComponent jComponent : jComponentArray = ((DynamicMenuContent)jMenuItem).getMenuPresenters()) {
                        jMenu.add(jComponent);
                    }
                    continue;
                }
                jMenu.add(jMenuItem);
            }
            if (jMenu.getItemCount() == 0) {
                jMenu = null;
            }
        }
        return jMenu;
    }

    private List<JMenu> createSubMenus(AnnotationDesc annotationDesc, BaseKit baseKit) {
        JMenu jMenu = this.createSubMenu(annotationDesc, baseKit);
        if (jMenu != null) {
            return Collections.singletonList(jMenu);
        }
        if (annotationDesc instanceof AnnotationCombination) {
            List<AnnotationDesc> list = ((AnnotationCombination)annotationDesc).getCombinedAnnotations();
            ArrayList<JMenu> arrayList = new ArrayList<JMenu>(list.size());
            for (AnnotationDesc annotationDesc2 : list) {
                jMenu = this.createSubMenu(annotationDesc2, baseKit);
                if (jMenu == null) continue;
                arrayList.add(jMenu);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void initMenu(JMenu jMenu, BaseKit baseKit, int n) {
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        Object object3;
        LineAnnotations lineAnnotations = this.getLineAnnotations(n);
        HashMap<String, String> hashMap = new HashMap<String, String>(AnnotationTypes.getTypes().getVisibleAnnotationTypeNamesCount() * 4 / 3);
        TreeSet<JMenu> treeSet = new TreeSet<JMenu>(MENU_COMPARATOR);
        if (lineAnnotations != null) {
            object3 = lineAnnotations.getActive();
            if (object3 != null) {
                object2 = this.createSubMenus((AnnotationDesc)object3, baseKit);
                treeSet.addAll((Collection<JMenu>)object2);
                hashMap.put(((AnnotationDesc)object3).getAnnotationType(), ((AnnotationDesc)object3).getAnnotationType());
            }
            if ((object2 = lineAnnotations.getPasive()) != null) {
                for (int i = 0; i < ((AnnotationDesc[])object2).length; ++i) {
                    object = this.createSubMenus((AnnotationDesc)object2[i], baseKit);
                    treeSet.addAll((Collection<JMenu>)object);
                    hashMap.put(((AnnotationDesc)object2[i]).getAnnotationType(), ((AnnotationDesc)object2[i]).getAnnotationType());
                }
            }
        }
        object2 = AnnotationTypes.getTypes().getAnnotationTypeNames();
        while (object2.hasNext()) {
            Action[] actionArray;
            object3 = AnnotationTypes.getTypes().getType((String)object2.next());
            if (object3 == null || !((AnnotationType)object3).isVisible() || hashMap.get(((AnnotationType)object3).getName()) != null || (actionArray = ((AnnotationType)object3).getActions()) == null) continue;
            object = new JMenu(((AnnotationType)object3).getDescription());
            for (int i = 0; i < actionArray.length; ++i) {
                if (!actionArray[i].isEnabled()) continue;
                ((JMenu)object).add(this.createMenuItem(actionArray[i], baseKit));
            }
            if (((JMenu)object).getItemCount() <= 0) continue;
            treeSet.add((JMenu)object);
        }
        if (!treeSet.isEmpty()) {
            object2 = treeSet.iterator();
            while (object2.hasNext()) {
                JMenu jMenu2 = (JMenu)object2.next();
                jMenu.add(jMenu2);
            }
            jMenu.addSeparator();
        }
        if ((jMenuItem = Annotations.getPopupMenuItem((Action)(object2 = baseKit.getActionByName("toggle-line-numbers")))) != null) {
            jMenu.add(jMenuItem);
        }
        if ((object2 = baseKit.getActionByName("toggle-toolbar")) != null && (jMenuItem = Annotations.getPopupMenuItem((Action)object2)) != null) {
            jMenu.add(jMenuItem);
        }
        this.menuInitialized = true;
    }

    private static JMenuItem getPopupMenuItem(Action action) {
        JMenuItem jMenuItem = null;
        if (action instanceof BaseAction) {
            jMenuItem = ((BaseAction)action).getPopupMenuItem(null);
        }
        if (jMenuItem == null && action instanceof Presenter.Popup) {
            jMenuItem = ((Presenter.Popup)action).getPopupPresenter();
        }
        return jMenuItem;
    }

    private JMenu createMenu(BaseKit baseKit, int n, boolean bl) {
        final DelayedMenu delayedMenu = new DelayedMenu(NbBundle.getBundle(BaseKit.class).getString("generate-gutter-popup"));
        final BaseKit baseKit2 = baseKit;
        final int n2 = n;
        if (bl) {
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            RequestProcessor.Task task = requestProcessor.create(new Runnable(){

                public void run() {
                    Annotations.this.initMenu(delayedMenu, baseKit2, n2);
                    delayedMenu.clearTask();
                }
            });
            delayedMenu.setTask(task);
            task.schedule(0);
        } else {
            this.initMenu(delayedMenu, baseKit2, n2);
        }
        return delayedMenu;
    }

    public JMenu createMenu(BaseKit baseKit, int n) {
        boolean bl = this.menuInitialized;
        this.menuInitialized = true;
        return this.createMenu(baseKit, n, !bl);
    }

    private String dumpAnnotaionDesc(AnnotationDesc annotationDesc) {
        return "offset=" + annotationDesc.getOffset() + "(ls=" + this.doc.getParagraphElement(annotationDesc.getOffset()).getStartOffset() + "), line=" + annotationDesc.getLine() + ", type=" + annotationDesc.getAnnotationType();
    }

    private String dumpLineAnnotationsArray() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lineAnnotationsArray.size(); ++i) {
            LineAnnotations lineAnnotations = this.lineAnnotationsArray.get(i);
            LinkedList linkedList = lineAnnotations.annos;
            stringBuffer.append("[" + i + "]: line=" + lineAnnotations.getLine() + ", anos:");
            for (AnnotationDesc annotationDesc : linkedList) {
                stringBuffer.append("\n    " + this.dumpAnnotaionDesc(annotationDesc));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MenuComparator
    implements Comparator<JMenu> {
        @Override
        public int compare(JMenu jMenu, JMenu jMenu2) {
            if (jMenu2 == null || jMenu == null) {
                return 0;
            }
            String string = jMenu.getText();
            String string2 = jMenu2.getText();
            if (string2 == null || string == null) {
                return 0;
            }
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationCombination
    extends AnnotationDesc
    implements Lookup.Provider {
        private AnnotationDesc delegate;
        private String type;
        private LinkedList<AnnotationDesc> list;

        public AnnotationCombination(String string, AnnotationDesc annotationDesc) {
            super(annotationDesc.getOffset(), annotationDesc.getLength());
            this.delegate = annotationDesc;
            this.type = string;
            this.updateAnnotationType();
            this.list = new LinkedList();
            this.list.add(annotationDesc);
        }

        @Override
        public int getOffset() {
            return this.delegate.getOffset();
        }

        @Override
        public int getLine() {
            return this.delegate.getLine();
        }

        @Override
        public String getShortDescription() {
            return this.getAnnotationTypeInstance().getDescription();
        }

        @Override
        public String getAnnotationType() {
            return this.type;
        }

        public void addCombinedAnnotation(AnnotationDesc annotationDesc) {
            this.list.add(annotationDesc);
        }

        public boolean isAnnotationCombined(AnnotationDesc annotationDesc) {
            return this.list.indexOf(annotationDesc) != -1;
        }

        List<AnnotationDesc> getCombinedAnnotations() {
            return this.list;
        }

        @Override
        Mark getMark() {
            return this.delegate.getMark();
        }

        public Lookup getLookup() {
            Lookup lookup = null;
            for (AnnotationDesc annotationDesc : this.list) {
                if (!(annotationDesc instanceof Lookup.Provider)) continue;
                Lookup lookup2 = ((Lookup.Provider)annotationDesc).getLookup();
                if (lookup == null) {
                    lookup = lookup2;
                    continue;
                }
                lookup = new ProxyLookup(new Lookup[]{lookup, lookup2});
            }
            if (lookup == null) {
                lookup = Lookups.fixed((Object[])new Object[0]);
            }
            return lookup;
        }
    }

    public static interface AnnotationsListener
    extends EventListener {
        public void changedLine(int var1);

        public void changedAll();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineAnnotations {
        private LinkedList<AnnotationDesc> annos = new LinkedList();
        private LinkedList<AnnotationDesc> annosVisible = new LinkedList();
        private AnnotationDesc active;

        protected LineAnnotations() {
        }

        public void addAnnotation(AnnotationDesc annotationDesc) {
            this.annos.add(annotationDesc);
            this.refreshAnnotations();
        }

        public void removeAnnotation(AnnotationDesc annotationDesc) {
            this.annos.remove(annotationDesc);
            this.refreshAnnotations();
        }

        public AnnotationDesc getActive() {
            return this.active;
        }

        AnnotationDesc getType(String string) {
            for (AnnotationDesc annotationDesc : this.annosVisible) {
                if (!annotationDesc.getAnnotationType().equals(string)) continue;
                return annotationDesc;
            }
            return null;
        }

        public int getLine() {
            return this.annos.size() > 0 ? this.annos.peek().getLine() : 0;
        }

        public void setLine(int n) {
            throw new IllegalStateException("Setting of line number not allowed");
        }

        public AnnotationDesc[] getPasive() {
            int n;
            AnnotationDesc[] annotationDescArray = new AnnotationDesc[this.getCount() - 1];
            int n2 = n = this.annosVisible.indexOf(this.getActive());
            int n3 = 0;
            while (true) {
                if (++n2 >= this.annosVisible.size()) {
                    n2 = 0;
                }
                if (n2 == n) break;
                annotationDescArray[n3] = this.annosVisible.get(n2);
                ++n3;
            }
            return annotationDescArray;
        }

        public boolean activate(AnnotationDesc annotationDesc) {
            int n = this.annosVisible.indexOf(annotationDesc);
            if (n == -1) {
                for (int i = 0; i < this.annosVisible.size(); ++i) {
                    if (!(this.annosVisible.get(i) instanceof AnnotationCombination) || !((AnnotationCombination)this.annosVisible.get(i)).isAnnotationCombined(annotationDesc)) continue;
                    n = i;
                    annotationDesc = (AnnotationCombination)this.annosVisible.get(i);
                    break;
                }
            }
            if (n == -1) {
                return false;
            }
            if (this.annosVisible.get(n) == null) {
                return false;
            }
            if (annotationDesc == this.active || !annotationDesc.isVisible()) {
                return false;
            }
            this.active = annotationDesc;
            return true;
        }

        public int getCount() {
            return this.annosVisible.size();
        }

        public AnnotationDesc activateNext() {
            if (this.getCount() <= 1) {
                return this.active;
            }
            int n = this.annosVisible.indexOf(this.active);
            if (++n >= this.getCount()) {
                n = 0;
            }
            this.active = this.annosVisible.get(n);
            return this.active;
        }

        private void fillInCombinationsAndOrderThem(LinkedList<AnnotationType> linkedList) {
            Iterator<String> iterator = AnnotationTypes.getTypes().getAnnotationTypeNames();
            while (iterator.hasNext()) {
                AnnotationType.CombinationMember[] combinationMemberArray;
                AnnotationType annotationType = AnnotationTypes.getTypes().getType(iterator.next());
                if (annotationType == null || (combinationMemberArray = annotationType.getCombinations()) == null || !annotationType.isWholeLine() || combinationMemberArray.length < 2 && (combinationMemberArray.length != 1 || !combinationMemberArray[0].isAbsorbAll())) continue;
                if (annotationType.getCombinationOrder() == 0) {
                    linkedList.add(annotationType);
                    continue;
                }
                boolean bl = false;
                for (int i = 0; i < linkedList.size(); ++i) {
                    if (linkedList.get(i).getCombinationOrder() <= annotationType.getCombinationOrder()) continue;
                    linkedList.add(i, annotationType);
                    bl = true;
                    break;
                }
                if (bl) continue;
                linkedList.add(annotationType);
            }
        }

        private boolean combineType(AnnotationType annotationType, LinkedList<AnnotationDesc> linkedList) {
            int n;
            int n2 = 0;
            int n3 = 0;
            LinkedList<AnnotationDesc> linkedList2 = new LinkedList<AnnotationDesc>();
            AnnotationType.CombinationMember[] combinationMemberArray = annotationType.getCombinations();
            boolean bl = true;
            for (n = 0; n < combinationMemberArray.length; ++n) {
                AnnotationType.CombinationMember combinationMember = combinationMemberArray[n];
                boolean bl2 = false;
                for (int i = 0; i < linkedList.size(); ++i) {
                    int n4;
                    AnnotationDesc annotationDesc = linkedList.get(i);
                    if (annotationDesc == null || !combinationMember.getName().equals(annotationDesc.getAnnotationType())) continue;
                    ++n2;
                    if (combinationMember.getMinimumCount() == 0) {
                        bl2 = true;
                        ++n2;
                        linkedList2.add(annotationDesc);
                        if (combinationMember.isAbsorbAll()) continue;
                        break;
                    }
                    int n5 = combinationMember.getMinimumCount() - 1;
                    for (n4 = i + 1; n4 < linkedList.size() && n5 > 0; ++n4) {
                        if (linkedList.get(n4) == null || !combinationMember.getName().equals(linkedList.get(n4).getAnnotationType())) continue;
                        --n5;
                    }
                    if (n5 != 0) break;
                    bl2 = true;
                    linkedList2.add(annotationDesc);
                    for (n4 = i + 1; n4 < linkedList.size(); ++n4) {
                        if (linkedList.get(n4) == null || !combinationMember.getName().equals(linkedList.get(n4).getAnnotationType())) continue;
                        ++n2;
                        linkedList2.add(linkedList.get(n4));
                    }
                    break;
                }
                if (bl2) {
                    if (!combinationMember.isOptional()) continue;
                    ++n3;
                    continue;
                }
                if (combinationMember.isOptional()) continue;
                bl = false;
                break;
            }
            if (annotationType.getMinimumOptionals() > n3) {
                bl = false;
            }
            AnnotationCombination annotationCombination = null;
            if (bl) {
                boolean bl3 = false;
                for (n = 0; n < linkedList2.size(); ++n) {
                    if (linkedList2.get(n) == this.active) {
                        bl3 = true;
                    }
                    if (annotationCombination == null) {
                        annotationCombination = new AnnotationCombination(annotationType.getName(), (AnnotationDesc)linkedList2.get(n));
                        linkedList.remove(linkedList2.get(n));
                        linkedList.add(annotationCombination);
                        continue;
                    }
                    annotationCombination.addCombinedAnnotation((AnnotationDesc)linkedList2.get(n));
                    linkedList.remove(linkedList2.get(n));
                }
                if (bl3) {
                    this.active = annotationCombination;
                }
                return true;
            }
            return false;
        }

        public void refreshAnnotations() {
            if (!AnnotationTypes.getTypes().isCombineGlyphs().booleanValue()) {
                this.annosVisible = new LinkedList();
                for (AnnotationDesc annotationDesc : this.annos) {
                    if (!annotationDesc.isVisible()) continue;
                    this.annosVisible.add(annotationDesc);
                }
            } else {
                LinkedList<AnnotationDesc> linkedList = new LinkedList<AnnotationDesc>(this.annos);
                LinkedList<AnnotationType> linkedList2 = new LinkedList<AnnotationType>();
                this.fillInCombinationsAndOrderThem(linkedList2);
                for (int i = 0; i < linkedList2.size(); ++i) {
                    this.combineType(linkedList2.get(i), linkedList);
                }
                this.annosVisible = new LinkedList();
                for (AnnotationDesc annotationDesc : linkedList) {
                    if (!annotationDesc.isVisible()) continue;
                    this.annosVisible.add(annotationDesc);
                }
            }
            Collections.sort(this.annosVisible);
            if (this.annosVisible.size() > 0) {
                this.active = this.annosVisible.get(0);
            }
        }

        public boolean isMarkStillReferenced(Mark mark) {
            for (AnnotationDesc annotationDesc : this.annos) {
                if (annotationDesc.getMark() != mark) continue;
                return true;
            }
            return false;
        }

        public Iterator<AnnotationDesc> getAnnotations() {
            return this.annos.iterator();
        }
    }

    private static class DelayedMenu
    extends JMenu {
        RequestProcessor.Task task;

        public DelayedMenu(String string) {
            super(string);
        }

        public JPopupMenu getPopupMenu() {
            RequestProcessor.Task task = this.task;
            if (task != null && !task.isFinished()) {
                task.waitFinished();
            }
            return super.getPopupMenu();
        }

        void setTask(RequestProcessor.Task task) {
            this.task = task;
        }

        void clearTask() {
            this.task = null;
        }
    }
}

