/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.repository.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryCategory;
import org.netbeans.modules.profiler.oql.repository.api.OQLQueryDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OQLQueryRepository {
    private static final String MATCH_ALL = ".*";
    private static final Logger LOGGER = Logger.getLogger(OQLQueryRepository.class.getName());

    private OQLQueryRepository() {
    }

    public static OQLQueryRepository getInstance() {
        return Singleton.INSTANCE;
    }

    @NonNull
    private FileObject getRepositoryRoot() {
        FileObject fileObject = FileUtil.getConfigFile((String)"NBProfiler/Config/OQL");
        if (fileObject == null) {
            throw new IllegalStateException("can not find OQL queries repository");
        }
        return fileObject;
    }

    @NonNull
    private String getDisplayName(@NonNull FileObject fileObject) {
        String string = (String)fileObject.getAttribute("displayName");
        return string != null ? string : fileObject.getName();
    }

    private String getDescription(FileObject fileObject) {
        return (String)fileObject.getAttribute("desc");
    }

    @NonNull
    private List<? extends OQLQueryDefinition> getQueries(FileObject fileObject, String string) {
        ArrayList<OQLQueryDefinition> arrayList = new ArrayList<OQLQueryDefinition>();
        try {
            Pattern pattern = Pattern.compile(string);
            List<FileObject> list = OQLQueryRepository.sortedFOs(fileObject.getData(false));
            for (FileObject fileObject2 : list) {
                String string2 = this.getDisplayName(fileObject2);
                if (!pattern.matcher(string2).matches()) continue;
                arrayList.add(new OQLQueryDefinition(string2, this.getDescription(fileObject2), fileObject2.asText()));
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "error while retrieving query definitions", iOException);
        }
        return arrayList;
    }

    @NonNull
    public List<? extends OQLQueryCategory> listCategories() {
        return this.listCategories(MATCH_ALL);
    }

    @NonNull
    public List<? extends OQLQueryCategory> listCategories(@NonNull String string) {
        FileObject fileObject = this.getRepositoryRoot();
        Pattern pattern = Pattern.compile(string);
        ArrayList<OQLQueryCategory> arrayList = new ArrayList<OQLQueryCategory>();
        List<FileObject> list = OQLQueryRepository.sortedFOs(fileObject.getFolders(false));
        for (FileObject fileObject2 : list) {
            String string2 = this.getDisplayName(fileObject2);
            if (!pattern.matcher(string2).matches()) continue;
            arrayList.add(new OQLQueryCategory(this, fileObject2.getName(), string2, this.getDescription(fileObject2)));
        }
        return arrayList;
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries() {
        return this.listQueries(MATCH_ALL);
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries(@NonNull String string) {
        FileObject fileObject = this.getRepositoryRoot();
        ArrayList<? extends OQLQueryDefinition> arrayList = new ArrayList<OQLQueryDefinition>();
        for (OQLQueryCategory oQLQueryCategory : this.listCategories()) {
            FileObject fileObject2 = fileObject.getFileObject(oQLQueryCategory.getID());
            arrayList.addAll(this.getQueries(fileObject2, string));
        }
        return arrayList;
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries(@NonNull OQLQueryCategory oQLQueryCategory) {
        return this.listQueries(oQLQueryCategory, MATCH_ALL);
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries(@NonNull OQLQueryCategory oQLQueryCategory, @NonNull String string) {
        FileObject fileObject = this.getRepositoryRoot();
        FileObject fileObject2 = fileObject.getFileObject(oQLQueryCategory.getID());
        return this.getQueries(fileObject2, string);
    }

    private static List<FileObject> sortedFOs(Enumeration<? extends FileObject> enumeration) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return FileUtil.getOrder(arrayList, (boolean)false);
    }

    private static final class Singleton {
        private static final OQLQueryRepository INSTANCE = new OQLQueryRepository();

        private Singleton() {
        }
    }
}

